/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job.impl;

import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.ResourceUtils;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.ValidationUtils;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.JobInput;
import com.sas.lsaf.execution.job.JobInputFile;
import com.sas.lsaf.execution.job.JobInputFolder;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobProgram;
import com.sas.lsaf.execution.job.JobPublishCheckin;
import com.sas.lsaf.execution.job.JobPublishCheckinLocation;
import com.sas.lsaf.execution.job.JobPublishSetup;
import com.sas.lsaf.execution.job.JobPublishSetupFile;
import com.sas.lsaf.execution.job.JobPublishSetupFolder;
import com.sas.lsaf.execution.job.JobPublishSetupItem;
import com.sas.lsaf.execution.job.JobSubmission;
import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestExternalReference;
import com.sas.lsaf.execution.job.ManifestFile;
import com.sas.lsaf.execution.job.ManifestFileRef;
import com.sas.lsaf.execution.job.ManifestInput;
import com.sas.lsaf.execution.job.ManifestJob;
import com.sas.lsaf.execution.job.ManifestMetrics;
import com.sas.lsaf.execution.job.ManifestOutput;
import com.sas.lsaf.execution.job.ManifestProgram;
import com.sas.lsaf.execution.job.ManifestRepositoryFile;
import com.sas.lsaf.execution.job.ManifestSynchronizationMetrics;
import com.sas.lsaf.execution.job.ManifestSystemFile;
import com.sas.lsaf.execution.job.ManifestWorkspaceFile;
import com.sas.lsaf.execution.job.OutputFileSpec;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.execution.session.EngineType;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationCheckinSpecification;
import com.sas.lsaf.svcs.execution.job.client.JobManifest;
import com.sas.lsaf.svcs.execution.job.client.JobManifestExternalReference;
import com.sas.lsaf.svcs.execution.job.client.JobManifestFile;
import com.sas.lsaf.svcs.execution.job.client.JobManifestFileRef;
import com.sas.lsaf.svcs.execution.job.client.JobManifestInput;
import com.sas.lsaf.svcs.execution.job.client.JobManifestJob;
import com.sas.lsaf.svcs.execution.job.client.JobManifestJobSubmission;
import com.sas.lsaf.svcs.execution.job.client.JobManifestMetrics;
import com.sas.lsaf.svcs.execution.job.client.JobManifestOutput;
import com.sas.lsaf.svcs.execution.job.client.JobManifestParameter;
import com.sas.lsaf.svcs.execution.job.client.JobManifestProgram;
import com.sas.lsaf.svcs.execution.job.client.JobManifestRepositoryFile;
import com.sas.lsaf.svcs.execution.job.client.JobManifestSystemFile;
import com.sas.lsaf.svcs.execution.job.client.JobManifestTransferMetrics;
import com.sas.lsaf.svcs.execution.job.client.JobManifestWorkspaceFile;
import com.sas.lsaf.svcs.execution.job.client.JobOutputSpecification;
import com.sas.lsaf.svcs.execution.job.client.JobParameter;
import com.sas.lsaf.svcs.execution.job.client.JobService;
import com.sas.lsaf.svcs.execution.job.client.JobSubmission;
import com.sas.lsaf.svcs.execution.job.client.exception.JobFormatException;
import com.sas.lsaf.svcs.execution.job.client.exception.JobNotFoundException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class JobHelper {
    public static Job toApiJob(com.sas.lsaf.svcs.execution.job.client.Job serverJob) {
        if (serverJob == null) {
            return null;
        }
        String path = ResourceUtils.getPath(serverJob.getUri(), true);
        String version = ResourceUtils.getVersion(serverJob.getUri());
        Job rval = new Job(path, version, serverJob.getOwner(), serverJob.isRunAsOwner());
        rval.setDescription(serverJob.getDescription());
        rval.setLogsLocation(serverJob.getLogsLocation());
        rval.setResultsLocation(serverJob.getResultsLocation());
        rval.setManifestLocation(serverJob.getManifestLocation());
        rval.setPublishSetup(JobHelper.toApiPublishSetup(serverJob.getPublishSetup()));
        rval.setPrograms(JobHelper.toApiJobPrograms(serverJob.getPrograms()));
        rval.setParameters(JobHelper.toApiJobParameters(serverJob.getParameters()));
        rval.setSourceLocation(ResourceUtils.isWorkspaceFile(serverJob.getUri()) ? SourceLocation.WORKSPACE : SourceLocation.REPOSITORY);
        rval.setPublishCheckin(JobHelper.toApiPublishCheckin(serverJob.getPublishCheckin()));
        return rval;
    }

    public static JobSubmission toApiJobSubmission(com.sas.lsaf.svcs.execution.job.client.JobSubmission jobSubmission) {
        if (jobSubmission == null) {
            return null;
        }
        boolean isWorkspace = ResourceUtils.isWorkspaceFile(jobSubmission.getJobUri());
        String jobVersion = ResourceUtils.getVersion(jobSubmission.getJobUri());
        JobSubmission rval = new JobSubmission(jobSubmission.getId(), isWorkspace ? JobSubmission.JobSubmissionType.WORKSPACE : JobSubmission.JobSubmissionType.REPOSITORY, jobSubmission.getJobId(), jobSubmission.getJobPath(), jobVersion, jobSubmission.getSessionId(), JobHelper.toApiJobSubmissionStatus(jobSubmission), jobSubmission.getSubmittedBy(), jobSubmission.getSubmitted(), jobSubmission.getCompleted(), jobSubmission.getJobOwner(), jobSubmission.getRunAsUser());
        return rval;
    }

    public static JobSubmission toApiManifestJobSubmission(JobManifestJobSubmission serverManifestJobSubmission, JobManifestJob serverManifestJob) {
        if (serverManifestJobSubmission != null && serverManifestJob != null) {
            JobManifestFile mnfJobFile = serverManifestJob.getFile();
            return new JobSubmission(serverManifestJobSubmission.getId(), mnfJobFile instanceof JobManifestRepositoryFile ? JobSubmission.JobSubmissionType.REPOSITORY : JobSubmission.JobSubmissionType.WORKSPACE, mnfJobFile.getId(), mnfJobFile.getPath(), mnfJobFile.getVersion(), serverManifestJobSubmission.getSessionId(), JobHelper.toApiManifestJobSubmissionStatus(serverManifestJobSubmission), serverManifestJobSubmission.getSubmittedBy(), serverManifestJobSubmission.getSubmitted(), serverManifestJobSubmission.getCompleted(), serverManifestJob.getOwner(), serverManifestJobSubmission.getRunAsUser());
        }
        return null;
    }

    public static JobSubmissionStatus toApiJobSubmissionStatus(com.sas.lsaf.svcs.execution.job.client.JobSubmission serverJobSubmission) {
        if (serverJobSubmission != null) {
            return new JobSubmissionStatus(JobHelper.toApiSummaryStatus(serverJobSubmission.getState()), JobHelper.toApiDetailStatus(serverJobSubmission.getState()), serverJobSubmission.getInfo());
        }
        return null;
    }

    public static JobSubmissionStatus toApiManifestJobSubmissionStatus(JobManifestJobSubmission serverManifestJobSubmission) {
        if (serverManifestJobSubmission != null) {
            return new JobSubmissionStatus(JobHelper.toApiSummaryStatus(serverManifestJobSubmission.getState()), JobHelper.toApiDetailStatus(serverManifestJobSubmission.getState()), serverManifestJobSubmission.getInfo());
        }
        return null;
    }

    private static JobSubmissionStatus.SummaryStatus toApiSummaryStatus(JobSubmission.JobExecutionState status) {
        if (status != null) {
            switch (status) {
                case STARTED: 
                case RUNNING_TASKS: 
                case POST_EXECUTION_PUBLISHING: {
                    return JobSubmissionStatus.SummaryStatus.STARTED;
                }
                case NOT_STARTED: {
                    return JobSubmissionStatus.SummaryStatus.NOT_STARTED;
                }
                case COMPLETED_CANCELED: 
                case COMPLETED_CHECKIN_ERROR: 
                case COMPLETED_FAILED: 
                case COMPLETED_PROGRAM_ERRORS: 
                case COMPLETED_PROGRAM_ERRORS_CHECKIN_ERROR: 
                case COMPLETED_PROGRAM_WARNINGS: 
                case COMPLETED_PROGRAM_WARNINGS_CHECKIN_ERROR: 
                case COMPLETED_SUCCESSFUL: {
                    return JobSubmissionStatus.SummaryStatus.COMPLETED;
                }
            }
            throw new SystemException("Unmapped job summary status: " + status);
        }
        return null;
    }

    private static JobSubmissionStatus.DetailStatus toApiDetailStatus(JobSubmission.JobExecutionState status) {
        if (status != null) {
            switch (status) {
                case STARTED: {
                    return JobSubmissionStatus.DetailStatus.STARTED;
                }
                case RUNNING_TASKS: {
                    return JobSubmissionStatus.DetailStatus.RUNNING_TASKS;
                }
                case POST_EXECUTION_PUBLISHING: {
                    return JobSubmissionStatus.DetailStatus.POST_EXECUTION_PUBLISHING;
                }
                case NOT_STARTED: {
                    return JobSubmissionStatus.DetailStatus.NOT_STARTED;
                }
                case COMPLETED_CANCELED: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_CANCELED;
                }
                case COMPLETED_CHECKIN_ERROR: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_CHECKIN_ERROR;
                }
                case COMPLETED_FAILED: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_FAILED;
                }
                case COMPLETED_PROGRAM_ERRORS: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_ERRORS;
                }
                case COMPLETED_PROGRAM_ERRORS_CHECKIN_ERROR: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_ERRORS_CHECKIN_ERROR;
                }
                case COMPLETED_PROGRAM_WARNINGS: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_WARNINGS;
                }
                case COMPLETED_PROGRAM_WARNINGS_CHECKIN_ERROR: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_WARNINGS_CHECKIN_ERROR;
                }
                case COMPLETED_SUCCESSFUL: {
                    return JobSubmissionStatus.DetailStatus.COMPLETED_SUCCESSFUL;
                }
            }
            throw new SystemException("Unmapped job detail status: " + status);
        }
        return null;
    }

    private static ManifestProgram.ExecutionStatus toApiExecutionState(JobManifestProgram.ExecutionState serverExecutionState) {
        if (serverExecutionState != null) {
            switch (serverExecutionState) {
                case CANCELED: {
                    return ManifestProgram.ExecutionStatus.CANCELED;
                }
                case ERRORS: {
                    return ManifestProgram.ExecutionStatus.ERRORS;
                }
                case FAILED: {
                    return ManifestProgram.ExecutionStatus.FAILED;
                }
                case SUCCESSFUL: {
                    return ManifestProgram.ExecutionStatus.SUCCESSFUL;
                }
                case WARNINGS: {
                    return ManifestProgram.ExecutionStatus.WARNINGS;
                }
                case UNEXECUTED: {
                    return ManifestProgram.ExecutionStatus.UNEXECUTED;
                }
            }
            throw new SystemException("Unmapped manifest program execution state: " + serverExecutionState);
        }
        return null;
    }

    private static EngineType toApiManifestSystemType(JobManifestSystemFile.Type serverItem) {
        if (serverItem != null) {
            switch (serverItem) {
                case SAS: {
                    return EngineType.SAS;
                }
                case R: {
                    return EngineType.R;
                }
            }
            throw new SystemException("Unmapped server manifest system file type: " + serverItem);
        }
        return null;
    }

    private static List<JobProgram> toApiJobPrograms(List<com.sas.lsaf.svcs.execution.job.client.JobProgram> serverItems) {
        ArrayList<JobProgram> apiProgramSpecs = new ArrayList<JobProgram>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.execution.job.client.JobProgram serverItem : serverItems) {
                apiProgramSpecs.add(JobHelper.toApiJobProgram(serverItem));
            }
        }
        return apiProgramSpecs;
    }

    public static JobProgram toApiJobProgram(com.sas.lsaf.svcs.execution.job.client.JobProgram serverItem) {
        if (serverItem != null) {
            return new JobProgram(serverItem.getPath(), serverItem.getVersion());
        }
        return null;
    }

    public static JobPublishSetup toApiPublishSetup(com.sas.lsaf.svcs.execution.job.client.JobPublishSetup serverItem) {
        if (serverItem != null) {
            JobPublishSetup apiItem = new JobPublishSetup();
            if (serverItem.getFiles() != null) {
                for (com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile serverFile : serverItem.getFiles()) {
                    apiItem.addFile(serverFile.getPath(), serverFile.getVersion());
                }
            }
            if (serverItem.getFolders() != null) {
                for (com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder serverFolder : serverItem.getFolders()) {
                    apiItem.addFolder(serverFolder.getPath(), serverFolder.isIncludeFiles(), serverFolder.isIncludeSubfolders());
                }
            }
            return apiItem;
        }
        return null;
    }

    public static JobPublishSetupItem toApiPublishSetupItem(com.sas.lsaf.svcs.execution.job.client.JobPublishSetupItem serverItem) {
        if (serverItem != null) {
            if (serverItem instanceof com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile) {
                com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile inputFile = (com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile)serverItem;
                return new JobPublishSetupFile(inputFile.getPath(), inputFile.getVersion());
            }
            if (serverItem instanceof com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder) {
                com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder inputFolder = (com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder)serverItem;
                return new JobPublishSetupFolder(inputFolder.getPath(), inputFolder.isIncludeFiles(), inputFolder.isIncludeSubfolders());
            }
        }
        return null;
    }

    public static com.sas.lsaf.svcs.execution.job.client.Job toServerJob(Job job, boolean isRepository) {
        com.sas.lsaf.svcs.execution.job.client.Job rval = new com.sas.lsaf.svcs.execution.job.client.Job();
        rval.setDescription(job.getDescription());
        rval.setLogsLocation(job.getLogsLocation());
        rval.setResultsLocation(job.getResultsLocation());
        rval.setManifestLocation(job.getManifestLocation());
        rval.setPrograms(JobHelper.toServerJobPrograms(job.getPrograms()));
        rval.setPublishSetup(JobHelper.toServerPublishSetup(job.getPublishSetup()));
        rval.setPublishCheckin(JobHelper.toServerPublishCheckin(job.getPublishCheckin()));
        if (isRepository) {
            rval.setUri(ResourceUtils.repositoryUri(job.getPath(), null, null, true));
        } else {
            rval.setUri(ResourceUtils.workspaceUri(job.getPath(), null, true));
        }
        rval.setParameters(JobHelper.toServerJobParameters(job.getParameters()));
        return rval;
    }

    public static String getUriForApiJob(String path, String version, SourceLocation sourceLocation) {
        Assert.notNull((Object)path, (String)"Job path is required.");
        Assert.notNull((Object)sourceLocation, (String)"SourceLocation is required.");
        if (sourceLocation == SourceLocation.REPOSITORY) {
            return ResourceUtils.repositoryUri(path, null, version, true);
        }
        return ResourceUtils.workspaceUri(path, null);
    }

    public static String getUriForApiRepositoryJob(String path, String version) {
        return ResourceUtils.repositoryUri(path, null, version, true);
    }

    private static List<com.sas.lsaf.svcs.execution.job.client.JobParameter> toServerJobParameters(List<JobParameter> apiJobParameters) {
        ArrayList<com.sas.lsaf.svcs.execution.job.client.JobParameter> serverJobParameters = new ArrayList<com.sas.lsaf.svcs.execution.job.client.JobParameter>();
        if (apiJobParameters != null) {
            for (JobParameter jp : apiJobParameters) {
                serverJobParameters.add(JobHelper.toServerJobParameter(jp));
            }
        }
        return serverJobParameters;
    }

    public static List<com.sas.lsaf.svcs.execution.job.client.JobProgram> toServerJobPrograms(List<JobProgram> apiItems) {
        ArrayList<com.sas.lsaf.svcs.execution.job.client.JobProgram> serverItems = new ArrayList<com.sas.lsaf.svcs.execution.job.client.JobProgram>();
        if (apiItems != null) {
            for (JobProgram apiItem : apiItems) {
                serverItems.add(JobHelper.toServerJobProgram(apiItem));
            }
            return serverItems;
        }
        return serverItems;
    }

    public static com.sas.lsaf.svcs.execution.job.client.JobPublishSetup toServerPublishSetup(JobPublishSetup apiItem) {
        if (apiItem != null) {
            com.sas.lsaf.svcs.execution.job.client.JobPublishSetup jobPublishSetup = new com.sas.lsaf.svcs.execution.job.client.JobPublishSetup();
            ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile> setupFiles = new ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile>();
            if (apiItem.getFiles() != null) {
                for (JobPublishSetupFile file : apiItem.getFiles()) {
                    setupFiles.add(new com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFile(file.getPath(), file.getVersion() != null ? file.getVersion().trim() : null));
                }
            }
            ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder> setupFolders = new ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder>();
            if (apiItem.getFolders() != null) {
                for (JobPublishSetupFolder folder : apiItem.getFolders()) {
                    setupFolders.add(new com.sas.lsaf.svcs.execution.job.client.JobPublishSetupFolder(folder.getPath(), folder.isIncludeFiles(), folder.isIncludeSubfolders()));
                }
            }
            jobPublishSetup.setFiles(setupFiles);
            jobPublishSetup.setFolders(setupFolders);
            return jobPublishSetup;
        }
        return null;
    }

    public static com.sas.lsaf.svcs.execution.job.client.JobProgram toServerJobProgram(JobProgram apiItem) {
        if (apiItem != null) {
            return new com.sas.lsaf.svcs.execution.job.client.JobProgram(apiItem.getPath(), apiItem.getVersion() != null ? apiItem.getVersion().trim() : null);
        }
        return null;
    }

    public static List<JobParameter> toApiJobParameters(List<com.sas.lsaf.svcs.execution.job.client.JobParameter> serverJobParameters) {
        ArrayList<JobParameter> apiJobParameters = new ArrayList<JobParameter>();
        if (serverJobParameters != null) {
            for (com.sas.lsaf.svcs.execution.job.client.JobParameter jp : serverJobParameters) {
                apiJobParameters.add(JobHelper.toApiJobParameter(jp));
            }
        }
        return apiJobParameters;
    }

    public static List<JobParameter> toApiJobManifestParameters(List<JobManifestParameter> serverJobParameters) {
        ArrayList<JobParameter> apiJobParameters = new ArrayList<JobParameter>();
        if (serverJobParameters != null) {
            for (JobManifestParameter jp : serverJobParameters) {
                apiJobParameters.add(JobHelper.toApiJobManifestParameter(jp));
            }
        }
        return apiJobParameters;
    }

    public static com.sas.lsaf.svcs.execution.job.client.Job toServerCreateJob(Job apiItem, RepositoryCheckinSpecification apiCheckinSpec) {
        com.sas.lsaf.svcs.execution.job.client.Job rval = new com.sas.lsaf.svcs.execution.job.client.Job();
        rval.setDescription(apiItem.getDescription());
        rval.setLogsLocation(apiItem.getLogsLocation());
        rval.setResultsLocation(apiItem.getResultsLocation());
        rval.setManifestLocation(apiItem.getManifestLocation());
        rval.setUri(JobHelper.getUriForApiJob(apiItem.getPath(), RepositoryHelper.toServerVersion(apiCheckinSpec), apiItem.getSourceLocation()));
        rval.setPrograms(JobHelper.toServerJobPrograms(apiItem.getPrograms()));
        rval.setPublishSetup(JobHelper.toServerPublishSetup(apiItem.getPublishSetup()));
        rval.setPublishCheckin(JobHelper.toServerPublishCheckin(apiItem.getPublishCheckin()));
        rval.setParameters(JobHelper.toServerJobParameters(apiItem.getParameters()));
        return rval;
    }

    private static OutputFileSpec toApiOutputFileSpec(JobOutputSpecification jobPublishCheckin) {
        if (jobPublishCheckin != null) {
            return new OutputFileSpec(jobPublishCheckin.isEnableVersioningOnNewFiles(), RepositoryHelper.toApiVersionType(jobPublishCheckin.getVersionType()), jobPublishCheckin.getCustomVersion());
        }
        return null;
    }

    private static JobPublishCheckin toApiPublishCheckin(com.sas.lsaf.svcs.execution.job.client.JobPublishCheckin jobPublishCheckin) {
        if (jobPublishCheckin != null) {
            JobPublishCheckin ret = new JobPublishCheckin().enableVersioningForNewFiles(jobPublishCheckin.isEnableVersioningOnNewFiles()).versionType(RepositoryHelper.toApiVersionType(jobPublishCheckin.getVersionType()), jobPublishCheckin.getCustomVersion());
            if (jobPublishCheckin.getLocations() != null && !jobPublishCheckin.getLocations().isEmpty()) {
                ret.setLocations(JobHelper.toApiPublishCheckinLocations(jobPublishCheckin.getLocations()));
            }
            return ret;
        }
        return null;
    }

    private static List<JobPublishCheckinLocation> toApiPublishCheckinLocations(List<com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation> serverItems) {
        if (serverItems != null) {
            ArrayList<JobPublishCheckinLocation> apiItems = new ArrayList<JobPublishCheckinLocation>();
            for (com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation serverItem : serverItems) {
                apiItems.add(JobHelper.toApiPublishCheckinLocation(serverItem));
            }
            return apiItems;
        }
        return null;
    }

    private static JobPublishCheckinLocation toApiPublishCheckinLocation(com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation serverItem) {
        if (serverItem != null) {
            return new JobPublishCheckinLocation(serverItem.getPath(), serverItem.isIncludeSubfolders());
        }
        return null;
    }

    private static List<com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation> toServerJobPublishCheckinLocations(List<JobPublishCheckinLocation> apiItems) {
        ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation> serverItems = new ArrayList<com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation>();
        if (apiItems != null) {
            for (JobPublishCheckinLocation apiItem : apiItems) {
                serverItems.add(JobHelper.toServerJobPublishCheckinLocation(apiItem));
            }
        }
        return serverItems;
    }

    private static com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation toServerJobPublishCheckinLocation(JobPublishCheckinLocation apiItem) {
        if (apiItem != null) {
            return new com.sas.lsaf.svcs.execution.job.client.JobPublishCheckinLocation(apiItem.getPath(), apiItem.isIncludeSubfolders());
        }
        return null;
    }

    private static com.sas.lsaf.svcs.execution.job.client.JobPublishCheckin toServerPublishCheckin(JobPublishCheckin apiPublishCheckin) {
        com.sas.lsaf.svcs.execution.job.client.JobPublishCheckin jobPublishCheckin = new com.sas.lsaf.svcs.execution.job.client.JobPublishCheckin();
        if (apiPublishCheckin != null) {
            jobPublishCheckin.setEnableVersioningOnNewFiles(apiPublishCheckin.isEnableVersioningForNewFiles());
            jobPublishCheckin.setVersionType(RepositoryHelper.toServerVersionType(apiPublishCheckin.getVersionType()));
            jobPublishCheckin.setCustomVersion(apiPublishCheckin.getCustomVersion());
            jobPublishCheckin.setLocations(JobHelper.toServerJobPublishCheckinLocations(apiPublishCheckin.getLocations()));
        }
        return jobPublishCheckin;
    }

    public static List<com.sas.lsaf.svcs.execution.job.client.ParameterValue> toServerParameterValues(List<ParameterValue> apiParameterValues) {
        if (apiParameterValues == null) {
            return null;
        }
        ArrayList<com.sas.lsaf.svcs.execution.job.client.ParameterValue> serverParameterValues = new ArrayList<com.sas.lsaf.svcs.execution.job.client.ParameterValue>();
        for (ParameterValue apiParameterValue : apiParameterValues) {
            serverParameterValues.add(JobHelper.toServerParameterValue(apiParameterValue));
        }
        return serverParameterValues;
    }

    private static com.sas.lsaf.svcs.execution.job.client.ParameterValue toServerParameterValue(ParameterValue apiParameterValue) {
        if (apiParameterValue != null) {
            return new com.sas.lsaf.svcs.execution.job.client.ParameterValue(apiParameterValue.getName(), JobHelper.toServerValueFromApiParameterValue(apiParameterValue.getValue()), JobHelper.toServerParameterType(apiParameterValue.getType()));
        }
        return null;
    }

    public static List<ParameterValue> toApiParameterValues(List<com.sas.lsaf.svcs.execution.job.client.ParameterValue> serverParameterValues) {
        ArrayList<ParameterValue> apiParameterValues = new ArrayList<ParameterValue>();
        if (serverParameterValues != null) {
            for (com.sas.lsaf.svcs.execution.job.client.ParameterValue serverParameterValue : serverParameterValues) {
                apiParameterValues.add(JobHelper.toApiParameterValue(serverParameterValue));
            }
        }
        return apiParameterValues;
    }

    public static ParameterValue toApiParameterValue(com.sas.lsaf.svcs.execution.job.client.ParameterValue serverParameterValue) {
        if (serverParameterValue != null) {
            return new ParameterValue(serverParameterValue.getName(), JobHelper.toApiValueFromServerParameterValue(serverParameterValue.getValue()), JobHelper.toApiParameterType(serverParameterValue.getType()));
        }
        return null;
    }

    private static com.sas.lsaf.svcs.execution.job.client.JobParameter toServerJobParameter(JobParameter apiJobParameter) {
        if (apiJobParameter != null) {
            return new com.sas.lsaf.svcs.execution.job.client.JobParameter(apiJobParameter.getName(), apiJobParameter.getLabel(), JobHelper.toServerParameterType(apiJobParameter.getType()), JobHelper.toServerValueFromApiParameterValue(apiJobParameter.getDefaultValue()));
        }
        return null;
    }

    private static Object toServerValueFromApiParameterValue(Object apiItem) {
        Object serverValue = apiItem;
        if (apiItem != null && apiItem instanceof JobInput) {
            JobInput apiItemSpec = (JobInput)apiItem;
            if (apiItem instanceof JobInputFolder) {
                return new com.sas.lsaf.svcs.execution.job.client.JobInputFolder(apiItemSpec.getPath(), ((JobInputFolder)apiItem).isIncludeSubfolders());
            }
            if (apiItem instanceof JobInputFile) {
                String version = ((JobInputFile)apiItem).getVersion() != null ? ((JobInputFile)apiItem).getVersion().trim() : null;
                return new com.sas.lsaf.svcs.execution.job.client.JobInputFile(apiItemSpec.getPath(), version);
            }
        }
        return serverValue;
    }

    private static JobParameter toApiJobParameter(com.sas.lsaf.svcs.execution.job.client.JobParameter serverJobParameter) {
        if (serverJobParameter != null) {
            return new JobParameter(serverJobParameter.getName(), serverJobParameter.getLabel(), JobHelper.toApiParameterType(serverJobParameter.getType()), JobHelper.toApiValueFromServerParameterValue(serverJobParameter.getDefaultValue()));
        }
        return null;
    }

    private static JobParameter toApiJobManifestParameter(JobManifestParameter serverJobParameter) {
        if (serverJobParameter != null) {
            return new JobParameter(serverJobParameter.getName(), serverJobParameter.getLabel(), JobHelper.toApiParameterType(serverJobParameter.getType()), JobHelper.toApiValueFromServerParameterValue(serverJobParameter.getValue()));
        }
        return null;
    }

    private static Serializable toApiValueFromServerParameterValue(Object serverParameterValue) {
        if (serverParameterValue == null) {
            return null;
        }
        Serializable apiValue = (Serializable)serverParameterValue;
        if (serverParameterValue instanceof com.sas.lsaf.svcs.execution.job.client.JobInput) {
            return JobHelper.toApiJobParameterInput((com.sas.lsaf.svcs.execution.job.client.JobInput)serverParameterValue);
        }
        return apiValue;
    }

    private static JobParameter.ParameterType toServerParameterType(JobParameter.ParameterType apiParameterType) {
        if (apiParameterType != null) {
            switch (apiParameterType) {
                case CHARACTER: {
                    return JobParameter.ParameterType.CHARACTER;
                }
                case CHARACTER_MASKED: {
                    return JobParameter.ParameterType.CHARACTER_MASKED;
                }
                case DATE: {
                    return JobParameter.ParameterType.DATE;
                }
                case FILE: {
                    return JobParameter.ParameterType.FILE;
                }
                case FOLDER: {
                    return JobParameter.ParameterType.FOLDER;
                }
                case NUMERIC: {
                    return JobParameter.ParameterType.NUMERIC;
                }
            }
            throw new SystemException("Unmapped parameter type: " + apiParameterType.name());
        }
        return null;
    }

    private static JobParameter.ParameterType toApiParameterType(JobParameter.ParameterType serverParameterType) {
        if (serverParameterType != null) {
            switch (serverParameterType) {
                case CHARACTER: {
                    return JobParameter.ParameterType.CHARACTER;
                }
                case CHARACTER_MASKED: {
                    return JobParameter.ParameterType.CHARACTER_MASKED;
                }
                case DATE: {
                    return JobParameter.ParameterType.DATE;
                }
                case FILE: {
                    return JobParameter.ParameterType.FILE;
                }
                case FOLDER: {
                    return JobParameter.ParameterType.FOLDER;
                }
                case NUMERIC: {
                    return JobParameter.ParameterType.NUMERIC;
                }
            }
            throw new SystemException("Unmapped parameter type: " + serverParameterType.name());
        }
        return null;
    }

    public static JobInput toApiJobParameterInput(com.sas.lsaf.svcs.execution.job.client.JobInput serverItem) {
        if (serverItem != null) {
            if (serverItem instanceof com.sas.lsaf.svcs.execution.job.client.JobInputFile) {
                com.sas.lsaf.svcs.execution.job.client.JobInputFile inputFile = (com.sas.lsaf.svcs.execution.job.client.JobInputFile)serverItem;
                return new JobInputFile(inputFile.getPath(), inputFile.getVersion() != null ? inputFile.getVersion().trim() : null);
            }
            if (serverItem instanceof com.sas.lsaf.svcs.execution.job.client.JobInputFolder) {
                com.sas.lsaf.svcs.execution.job.client.JobInputFolder inputFolder = (com.sas.lsaf.svcs.execution.job.client.JobInputFolder)serverItem;
                return new JobInputFolder(inputFolder.getPath(), inputFolder.isIncludeSubfolders());
            }
        }
        return null;
    }

    public static Manifest toApiManifest(JobManifest serverManifest) {
        if (serverManifest != null) {
            return new Manifest(JobHelper.toApiManifestFile(serverManifest.getManifest()), JobHelper.toApiManifestJob(serverManifest.getJob()), JobHelper.toApiManifestJobSubmission(serverManifest.getJobSubmission(), serverManifest.getJob()), JobHelper.toApiManifestPrograms(serverManifest.getPrograms()), JobHelper.toApiManifestInputs(serverManifest.getInputs()), JobHelper.toApiManifestOutputs(serverManifest.getOutputs()), JobHelper.toApiOutputFileSpec(serverManifest.getOutputSpecification()), JobHelper.toApiJobManifestParameters(serverManifest.getParameters()), JobHelper.toApiManifestType(serverManifest.getType()), JobHelper.toApiManifestSystemFiles(serverManifest.getLogs()), JobHelper.toApiManifestSystemFiles(serverManifest.getResults()), JobHelper.toApiManifestMetrics(serverManifest.getMetrics()), JobHelper.getTotalExecutionTime(serverManifest.getPrograms()), JobHelper.toApiManifestExtInputs(serverManifest.getExternalInputs()), JobHelper.toApiManifestExtOutputs(serverManifest.getExternalOutputs()));
        }
        return null;
    }

    private static ManifestFile toApiManifestFile(JobManifestFile serverItem) {
        if (serverItem != null) {
            if (serverItem instanceof JobManifestRepositoryFile) {
                JobManifestRepositoryFile repoFile = (JobManifestRepositoryFile)serverItem;
                return new ManifestRepositoryFile(repoFile.getId(), repoFile.getVersion(), repoFile.getPath(), repoFile.getName(), repoFile.getLastModified(), repoFile.getSize());
            }
            if (serverItem instanceof JobManifestWorkspaceFile) {
                JobManifestWorkspaceFile wkspFile = (JobManifestWorkspaceFile)serverItem;
                return new ManifestWorkspaceFile(wkspFile.getPath(), wkspFile.getName(), wkspFile.getLastModified(), wkspFile.getSize());
            }
        }
        return null;
    }

    private static ManifestFileRef toApiManifestFileRef(JobManifestFileRef serverItem) {
        if (serverItem != null) {
            if (serverItem instanceof JobManifestSystemFile) {
                return new ManifestSystemFile(JobHelper.toApiManifestFile(serverItem.getFile()), JobHelper.toApiManifestSystemType(((JobManifestSystemFile)serverItem).getType()));
            }
            if (serverItem instanceof JobManifestInput) {
                return new ManifestInput(JobHelper.toApiManifestFile(serverItem.getFile()), ((JobManifestInput)serverItem).getReferencingProgram());
            }
            if (serverItem instanceof JobManifestOutput) {
                return new ManifestOutput(JobHelper.toApiManifestFile(serverItem.getFile()), ((JobManifestOutput)serverItem).getReferencingProgram(), ((JobManifestOutput)serverItem).getCheckinErrorMessage());
            }
            if (serverItem instanceof JobManifestProgram) {
                return new ManifestProgram(JobHelper.toApiManifestFile(serverItem.getFile()), JobHelper.toApiExecutionState(((JobManifestProgram)serverItem).getExecutionState()), ((JobManifestProgram)serverItem).getExecutionTime(), ((JobManifestProgram)serverItem).getExecutionInfo());
            }
            if (serverItem instanceof JobManifestJob) {
                return new ManifestJob(JobHelper.toApiManifestFile(serverItem.getFile()), ((JobManifestJob)serverItem).getOwner(), ((JobManifestJob)serverItem).isRunAsOwner(), ((JobManifestJob)serverItem).getDescription());
            }
        }
        return null;
    }

    private static List<ManifestSystemFile> toApiManifestSystemFiles(List<JobManifestSystemFile> serverItems) {
        if (serverItems != null) {
            ArrayList<ManifestSystemFile> apiItems = new ArrayList<ManifestSystemFile>();
            for (JobManifestSystemFile serverItem : serverItems) {
                apiItems.add(JobHelper.toApiManifestSystemFile(serverItem));
            }
            return apiItems;
        }
        return null;
    }

    private static ManifestSystemFile toApiManifestSystemFile(JobManifestSystemFile serverItem) {
        if (serverItem != null) {
            if (serverItem.getType() == JobManifestSystemFile.Type.SAS) {
                return new ManifestSystemFile(JobHelper.toApiManifestFile(serverItem.getFile()), EngineType.SAS);
            }
            if (serverItem.getType() == JobManifestSystemFile.Type.R) {
                return new ManifestSystemFile(JobHelper.toApiManifestFile(serverItem.getFile()), EngineType.R);
            }
        }
        return null;
    }

    private static ManifestMetrics toApiManifestMetrics(JobManifestMetrics serverManifestMetrics) {
        if (serverManifestMetrics != null) {
            return new ManifestMetrics(JobHelper.toApiManifestSynchronizationMetrics(serverManifestMetrics.getJobMetrics()), JobHelper.toApiManifestSynchronizationMetrics(serverManifestMetrics.getProgramsMetrics()), JobHelper.toApiManifestSynchronizationMetrics(serverManifestMetrics.getInputsMetrics()), JobHelper.toApiManifestSynchronizationMetrics(serverManifestMetrics.getOutputsMetrics()), JobHelper.toApiManifestInputsReferencedMetrics(serverManifestMetrics), JobHelper.toApiManifestOutputsReferencedMetrics(serverManifestMetrics), JobHelper.getTotalInputMetrics(serverManifestMetrics));
        }
        return null;
    }

    private static ManifestSynchronizationMetrics getTotalInputMetrics(JobManifestMetrics serverManifestMetrics) {
        int total = 0;
        long size = 0L;
        long time = 0L;
        if (serverManifestMetrics.getJobMetrics() != null) {
            total = serverManifestMetrics.getJobMetrics().getTotal();
            size = serverManifestMetrics.getJobMetrics().getSize();
            time = serverManifestMetrics.getJobMetrics().getTime();
        }
        if (serverManifestMetrics.getProgramsMetrics() != null) {
            total += serverManifestMetrics.getProgramsMetrics().getTotal();
            size += serverManifestMetrics.getProgramsMetrics().getSize();
            time += serverManifestMetrics.getProgramsMetrics().getTime();
        }
        if (serverManifestMetrics.getInputsMetrics() != null) {
            total += serverManifestMetrics.getInputsMetrics().getTotal();
            size += serverManifestMetrics.getInputsMetrics().getSize();
            time += serverManifestMetrics.getInputsMetrics().getTime();
        }
        return new ManifestSynchronizationMetrics(total, size, time);
    }

    private static ManifestSynchronizationMetrics toApiManifestSynchronizationMetrics(JobManifestTransferMetrics serverMetrics) {
        if (serverMetrics != null) {
            return new ManifestSynchronizationMetrics(serverMetrics.getTotal(), serverMetrics.getSize(), serverMetrics.getTime());
        }
        return null;
    }

    private static ManifestSynchronizationMetrics toApiManifestInputsReferencedMetrics(JobManifestMetrics serverMetrics) {
        if (serverMetrics != null && serverMetrics.getInputsReferencedMetrics() != null) {
            return new ManifestSynchronizationMetrics(serverMetrics.getInputsReferencedMetrics().getTotal(), serverMetrics.getInputsReferencedMetrics().getSize(), serverMetrics.getInputsReferencedMetrics().getTime());
        }
        return null;
    }

    private static ManifestSynchronizationMetrics toApiManifestOutputsReferencedMetrics(JobManifestMetrics serverMetrics) {
        if (serverMetrics != null && serverMetrics.getOutputsReferencedMetrics() != null) {
            return new ManifestSynchronizationMetrics(serverMetrics.getOutputsReferencedMetrics().getTotal(), serverMetrics.getOutputsReferencedMetrics().getSize(), serverMetrics.getOutputsReferencedMetrics().getTime());
        }
        return null;
    }

    private static Manifest.ManifestType toApiManifestType(JobManifest.JobManifestType serverManifestType) {
        if (serverManifestType != null) {
            switch (serverManifestType) {
                case PUBLISHED: {
                    return Manifest.ManifestType.PUBLISHED;
                }
                case WORKSPACE: {
                    return Manifest.ManifestType.WORKSPACE;
                }
                case TEST: {
                    return Manifest.ManifestType.TEST;
                }
            }
            throw new SystemException("Unmapped manifest type: " + serverManifestType.name());
        }
        return null;
    }

    private static List<ManifestOutput> toApiManifestOutputs(List<JobManifestOutput> serverOutputs) {
        ArrayList<ManifestOutput> outputs = new ArrayList<ManifestOutput>();
        if (serverOutputs != null) {
            for (JobManifestOutput serverOutput : serverOutputs) {
                outputs.add((ManifestOutput)JobHelper.toApiManifestFileRef((JobManifestFileRef)serverOutput));
            }
        }
        return outputs;
    }

    private static List<ManifestExternalReference> toApiManifestExtOutputs(List<JobManifestExternalReference> serverExtOutputs) {
        ArrayList<ManifestExternalReference> outputs = new ArrayList<ManifestExternalReference>();
        if (serverExtOutputs != null) {
            for (JobManifestExternalReference serverExtOutput : serverExtOutputs) {
                ManifestExternalReference apiOutput = JobHelper.toApiManifestExtOutput(serverExtOutput);
                if (apiOutput == null) continue;
                outputs.add(apiOutput);
            }
        }
        return outputs;
    }

    private static ManifestExternalReference toApiManifestExtOutput(JobManifestExternalReference serverExtOutput) {
        if (serverExtOutput != null) {
            return new ManifestExternalReference(serverExtOutput.getLocation() + "/" + serverExtOutput.getName(), serverExtOutput.getReferencingProgram());
        }
        return null;
    }

    private static List<ManifestExternalReference> toApiManifestExtInputs(List<JobManifestExternalReference> serverExtInputs) {
        ArrayList<ManifestExternalReference> inputs = new ArrayList<ManifestExternalReference>();
        if (serverExtInputs != null) {
            for (JobManifestExternalReference serverExtInput : serverExtInputs) {
                ManifestExternalReference apiInput = JobHelper.toApiManifestExtInput(serverExtInput);
                if (apiInput == null) continue;
                inputs.add(apiInput);
            }
        }
        return inputs;
    }

    private static ManifestExternalReference toApiManifestExtInput(JobManifestExternalReference serverExtInput) {
        if (serverExtInput != null) {
            return new ManifestExternalReference(serverExtInput.getLocation() + "/" + serverExtInput.getName(), serverExtInput.getReferencingProgram());
        }
        return null;
    }

    public static SourceLocation getApiSourceLocation(String uri) {
        if (uri != null && !uri.isEmpty()) {
            if (ResourceUtils.isRepositoryFile(uri)) {
                return SourceLocation.REPOSITORY;
            }
            if (ResourceUtils.isWorkspaceFile(uri)) {
                return SourceLocation.WORKSPACE;
            }
        }
        return null;
    }

    private static List<ManifestInput> toApiManifestInputs(List<JobManifestInput> serverInputs) {
        ArrayList<ManifestInput> inputs = new ArrayList<ManifestInput>();
        if (serverInputs != null) {
            for (JobManifestInput serverInput : serverInputs) {
                inputs.add((ManifestInput)JobHelper.toApiManifestFileRef((JobManifestFileRef)serverInput));
            }
        }
        return inputs;
    }

    private static ManifestJob toApiManifestJob(JobManifestJob serverItem) {
        return (ManifestJob)JobHelper.toApiManifestFileRef((JobManifestFileRef)serverItem);
    }

    private static List<ManifestProgram> toApiManifestPrograms(List<JobManifestProgram> serverManifestPrograms) {
        ArrayList<ManifestProgram> programs = new ArrayList<ManifestProgram>();
        if (serverManifestPrograms != null) {
            for (JobManifestProgram serverManifestProgram : serverManifestPrograms) {
                programs.add((ManifestProgram)JobHelper.toApiManifestFileRef((JobManifestFileRef)serverManifestProgram));
            }
        }
        return programs;
    }

    public static List<JobSubmission> toApiJobSubmissions(List<com.sas.lsaf.svcs.execution.job.client.JobSubmission> jobSubs) {
        ArrayList<JobSubmission> apiJobSubs = new ArrayList<JobSubmission>();
        if (jobSubs != null) {
            for (com.sas.lsaf.svcs.execution.job.client.JobSubmission serverJobSub : jobSubs) {
                apiJobSubs.add(JobHelper.toApiJobSubmission(serverJobSub));
            }
        }
        return apiJobSubs;
    }

    public static SynchronizationCheckinSpecification toServerSynchronizationCheckinSpecification(RepositoryCheckinSpecification apiItem) {
        SynchronizationCheckinSpecification serverItem = new SynchronizationCheckinSpecification();
        if (apiItem != null) {
            serverItem.setComment(apiItem.getComment());
            serverItem.setVersionType(RepositoryHelper.toServerVersionType(apiItem.getVersionType()));
            serverItem.setCustomVersion(apiItem.getCustomVersion());
            serverItem.setEnableVersioningForNewFiles(apiItem.isEnableVersioningForNewFiles());
        } else {
            serverItem.setEnableVersioningForNewFiles(false);
        }
        return serverItem;
    }

    public static void validateJobPath(String path) {
        if (path != null && !path.trim().isEmpty()) {
            ValidationUtils.validatePath(path);
            String jobUri = ResourceUtils.workspaceUri(path, null, true);
            try {
                URI realUri = URI.create(jobUri);
                String uriPath = realUri.getPath();
                if (!ResourceUtils.getPath(jobUri, true).equals(uriPath)) {
                    throw new ValidationException("Job path is invalid " + path);
                }
            }
            catch (Exception e) {
                throw new ValidationException(e.getLocalizedMessage());
            }
        }
    }

    public static void validateManifestPath(String path) {
        JobHelper.validateManifestPathAndVersion(path, null);
    }

    public static void validateManifestPathAndVersion(String path, String version) {
        ValidationUtils.validateVersion(version);
        if (path != null && !path.trim().isEmpty()) {
            ValidationUtils.validatePath(path);
            String mnfUri = ResourceUtils.repositoryUri(path, null, version != null ? version.trim() : null, true);
            try {
                URI realUri = URI.create(mnfUri);
                String uriPath = realUri.getPath();
                if (!ResourceUtils.getPath(mnfUri, true).equals(uriPath)) {
                    throw new ValidationException("Manifest path is invalid " + path);
                }
            }
            catch (Exception e) {
                throw new ValidationException(e.getLocalizedMessage());
            }
        }
    }

    public static void validateJobPathAndVersion(String path, String version) {
        JobHelper.validateJobPath(path);
        ValidationUtils.validateVersion(version);
    }

    public static void validateJobFormat(String path, String version, boolean isRepository, JobService jobService) {
        block2: {
            try {
                String uri = isRepository ? ResourceUtils.repositoryUri(path, null, version, true) : ResourceUtils.workspaceUri(path, null, true);
                jobService.loadJob(uri);
            }
            catch (Exception e) {
                if (!(e instanceof JobFormatException)) break block2;
                throw new IllegalArgumentException("Job could not be found or is in an invalid format.");
            }
        }
    }

    public static Long getTotalExecutionTime(List<JobManifestProgram> manifestPrograms) {
        Long totalExecutionTime = null;
        if (manifestPrograms != null) {
            for (JobManifestProgram mt : manifestPrograms) {
                if (mt == null || mt.getExecutionTime() == null) continue;
                if (totalExecutionTime == null) {
                    totalExecutionTime = 0L;
                }
                totalExecutionTime = totalExecutionTime + mt.getExecutionTime();
            }
        }
        return totalExecutionTime;
    }

    private static void validateJobTaskWithJobParameters(List<com.sas.lsaf.svcs.execution.job.client.JobParameter> jobParms, List<ParameterValue> jobTaskParmValues) {
        if (jobParms == null || jobParms.isEmpty()) {
            if (jobTaskParmValues != null && !jobTaskParmValues.isEmpty()) {
                throw new ValidationException("The job has no default parameters, but parameter values were provided.  This is not allowed.");
            }
        } else if (jobTaskParmValues != null && !jobTaskParmValues.isEmpty()) {
            String extraneousParm = JobHelper.doGetParmNotOnJob(jobTaskParmValues, jobParms);
            if (extraneousParm != null) {
                throw new ValidationException("The parameter, " + extraneousParm + ", does not exist on the job. Please provide parameter values for parameters that exist on the job.");
            }
            block0: for (com.sas.lsaf.svcs.execution.job.client.JobParameter sddDefaultParm : jobParms) {
                for (ParameterValue apiScheduleParmValue : jobTaskParmValues) {
                    if (!apiScheduleParmValue.getName().equals(sddDefaultParm.getName())) continue;
                    if (apiScheduleParmValue.getType().equals((Object)JobParameter.ParameterType.valueOf((String)sddDefaultParm.getType().name()))) continue block0;
                    throw new ValidationException("The parameter, " + apiScheduleParmValue.getName() + ", type does not match the default parameter type on the job.  The type must be the same.");
                }
            }
        }
    }

    private static String doGetParmNotOnJob(List<ParameterValue> parmValues, List<com.sas.lsaf.svcs.execution.job.client.JobParameter> jobParms) {
        String rval = null;
        for (ParameterValue schedParm : parmValues) {
            boolean found = false;
            for (com.sas.lsaf.svcs.execution.job.client.JobParameter jobParm : jobParms) {
                if (!schedParm.getName().equals(jobParm.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            rval = schedParm.getName();
            break;
        }
        return rval;
    }

    public static void validateParameterValueOverrides(String jobPath, String jobVersion, boolean isRepository, List<ParameterValue> parmOverrides, JobService jobService) {
        if (parmOverrides != null && !parmOverrides.isEmpty()) {
            for (ParameterValue pv : parmOverrides) {
                JobHelper.validateParameterValue(pv);
            }
            if (jobPath == null || jobPath.isEmpty()) {
                throw new ValidationException("Job parameter override values have been specified but no job path is specified.");
            }
            try {
                String uri = isRepository ? ResourceUtils.repositoryUri(jobPath, null, jobVersion, true) : ResourceUtils.workspaceUri(jobPath, null, true);
                com.sas.lsaf.svcs.execution.job.client.Job job = jobService.loadJob(uri);
                JobHelper.validateJobTaskWithJobParameters(job.getParameters(), parmOverrides);
            }
            catch (JobFormatException | JobNotFoundException e) {
                throw new ValidationException("Job parameter override values have been specified but the job specified cannot be found.");
            }
        }
    }

    private static void validateParameterValue(ParameterValue pv) {
        Assert.notNull((Object)pv, (String)"Parameter value is invalid, null object specified");
        Assert.hasText((String)pv.getName(), (String)"Parameter value is invalid, name is null or empty value specified");
        Assert.notNull((Object)pv.getType(), (String)"Parameter value is invalid, type is null value specified");
        if (pv.getName().length() > 32) {
            throw new ValidationException("Parameter value is invalid, parameter name cannot exceed " + Integer.toString(32) + " characters, name specified = " + pv.getName());
        }
        Serializable value = pv.getValue();
        if (value != null) {
            if (pv.getType() == JobParameter.ParameterType.CHARACTER) {
                if (!(value instanceof String)) {
                    throw new ValidationException("Parameter value is invalid, parameter value for CHARACTER type must be specified as a String.");
                }
                if (((String)((Object)value)).length() > 3900) {
                    throw new ValidationException("Parameter value is invalid, parameter value cannot exceed " + Integer.toString(3900) + " characters in size");
                }
            } else if (pv.getType() == JobParameter.ParameterType.NUMERIC) {
                if (!(value instanceof String)) {
                    throw new ValidationException("Parameter value is invalid, parameter value for NUMERIC type must be a String.");
                }
                if (((String)((Object)value)).length() > 3900) {
                    throw new ValidationException("Parameter value is invalid, parameter value cannot exceed " + Integer.toString(3900) + " characters in size");
                }
                if (!Pattern.compile("^-?(?:[0-9]+(?:\\.[0-9]+)?|[0-9]*(?:\\.[0-9]+))*$").matcher((String)((Object)value)).matches()) {
                    throw new ValidationException("Parameter value is invalid, parameter value contains characters which are not valid for NUMERIC type.");
                }
            } else if (pv.getType() == JobParameter.ParameterType.FILE || pv.getType() == JobParameter.ParameterType.FOLDER) {
                if (pv.getValue() != null && pv.getValue() instanceof JobInput) {
                    JobInput itemSpec = (JobInput)pv.getValue();
                    String path = itemSpec.getPath();
                    Assert.hasText((String)path, (String)"Parameter value is invalid, file path specified is null or empty");
                    if (path.length() > 3900) {
                        throw new ValidationException("Parameter value is invalid, file path value cannot exceed " + Integer.toString(3900) + " characters in size");
                    }
                    if (pv.getType() == JobParameter.ParameterType.FILE) {
                        ValidationUtils.validateVersion(((JobInputFile)itemSpec).getVersion());
                    }
                }
            } else if (pv.getType() == JobParameter.ParameterType.DATE && !(value instanceof Date)) {
                throw new ValidationException("Parameter value is invalid, parameter value for DATE type must be a Date object");
            }
        }
    }

    public static void validateJobInfo(String jobPath, String jobVersion, boolean isRepository, List<ParameterValue> parmValueOverrides, JobService jobService) {
        ValidationUtils.validateVersion(jobVersion != null ? jobVersion.trim() : null);
        JobHelper.validateParameterValueOverrides(jobPath, jobVersion, isRepository, parmValueOverrides, jobService);
    }
}

