/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job.impl;

import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.execution.job.InternalJobService;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.JobNotFoundException;
import com.sas.lsaf.execution.job.JobUpdateException;
import com.sas.lsaf.execution.job.impl.JobHelper;
import com.sas.lsaf.svcs.content.repository.client.exception.BatchCheckinException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.resource.client.Resource;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationService;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException;
import com.sas.lsaf.svcs.execution.job.client.JobService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

public class InternalJobServiceImpl
implements InternalJobService {
    private JobService jobService;
    private SynchronizationService synchronizationService;

    @Required
    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    @Required
    public void setSynchronizationService(SynchronizationService synchronizationService) {
        this.synchronizationService = synchronizationService;
    }

    @Override
    @Transactional(rollbackFor={JobUpdateException.class, ValidationException.class})
    public String internalUpdateJob(Job job, RepositoryCheckinSpecification spec) throws JobNotFoundException, JobUpdateException {
        try {
            String workspaceId = this.synchronizationService.getCurrentUserWorkspace().getId();
            this.synchronizationService.checkout(workspaceId, job.getPath());
            this.jobService.updateJob(JobHelper.toServerJob(job, true));
            Set resources = this.synchronizationService.checkin(workspaceId, JobHelper.toServerSynchronizationCheckinSpecification(spec), job.getPath());
            if (resources != null && !resources.isEmpty()) {
                return ((Resource)resources.iterator().next()).getUri();
            }
        }
        catch (RepositoryItemNotFoundException | WorkspaceItemNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.execution.job.client.exception.JobNotFoundException e) {
            throw new JobNotFoundException(e.getLocalizedMessage());
        }
        catch (BatchCheckinException e) {
            RepositoryItemCheckinException ex = RepositoryHelper.handleBatchCheckinException(job.getPath(), e);
            throw new JobUpdateException(ex.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            throw new ValidationException(e.getLocalizedMessage());
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobUpdateException(e.getLocalizedMessage());
        }
        return null;
    }
}

