/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.type.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.core.type.TypeDescriptor;
import com.sas.lsaf.core.type.TypeNotFoundException;
import com.sas.lsaf.core.type.TypeService;
import com.sas.lsaf.core.type.impl.TypeHelper;
import com.sas.lsaf.svcs.core.common.client.exception.ConfigurationException;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class TypeServiceImpl
implements TypeService {
    private com.sas.lsaf.svcs.core.type.client.TypeService typeService;

    @Required
    public void setTypeService(com.sas.lsaf.svcs.core.type.client.TypeService typeService) {
        this.typeService = typeService;
    }

    public boolean typeExists(String id) {
        Assert.hasText((String)id, (String)"Type identifier is required.");
        for (Type serverItem : this.getTypes()) {
            if (!serverItem.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public List<Type> getTypes() {
        return TypeHelper.toApiTypes(this.typeService.getTypes());
    }

    public List<Type> getSearchableTypes() {
        return TypeHelper.toApiSearchableTypes(this.typeService.getTypes());
    }

    public List<Type> getAuditableTypes() {
        return TypeHelper.toApiAuditableTypes(this.typeService.getTypes());
    }

    public List<Type> getContextTypes() {
        return TypeHelper.toApiTypes(this.typeService.getContextTypes());
    }

    public List<TypeDescriptor> getTopLevelTypes() {
        return TypeHelper.toApiTypeDescriptors(this.typeService.getTopLevelTypes());
    }

    public List<Type> getTypesByCapability(Type.Capability c) {
        Assert.notNull((Object)c, (String)"Capability is required.");
        return TypeHelper.toApiTypesByCapability(this.typeService.getTypesByCapability(TypeHelper.toServerCapability(c)));
    }

    public boolean isTypeCapable(String id, Type.Capability c) {
        Assert.hasText((String)id, (String)"Type identifier is required.");
        Assert.notNull((Object)c, (String)"Capability is required.");
        try {
            return this.typeService.isTypeCapable(id, TypeHelper.toServerCapability(c));
        }
        catch (ConfigurationException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Type getTypeById(String id) throws TypeNotFoundException {
        Assert.hasText((String)id, (String)"Type identifier is required.");
        for (com.sas.lsaf.svcs.core.type.client.Type serverItem : this.typeService.getTypes()) {
            if (!serverItem.getId().equals(id) || serverItem.isMixin()) continue;
            return TypeHelper.toApiType(serverItem);
        }
        throw new TypeNotFoundException("Type does not exist with identifier: " + id);
    }
}

