/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.type.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.core.type.TypeDescriptor;
import com.sas.lsaf.svcs.core.type.client.AttributeDefinition;
import com.sas.lsaf.svcs.core.type.client.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class TypeHelper {
    private static AttributeDefinition.AttributeType toApiAttributeType(AttributeDefinition.AttributeType serverItem) {
        switch (serverItem) {
            case LONG: {
                return AttributeDefinition.AttributeType.LONG;
            }
            case STRING: {
                return AttributeDefinition.AttributeType.STRING;
            }
            case DATE: {
                return AttributeDefinition.AttributeType.DATE;
            }
            case BOOLEAN: {
                return AttributeDefinition.AttributeType.BOOLEAN;
            }
        }
        throw new SystemException("Unmapped attribute type: " + serverItem.name());
    }

    public static List<Type.Capability> toApiCapabilities(List<Type.Capability> serverItems) {
        ArrayList<Type.Capability> apiItems = new ArrayList<Type.Capability>(serverItems.size());
        for (Type.Capability serverItem : serverItems) {
            apiItems.add(TypeHelper.toApiCapability(serverItem));
        }
        return apiItems;
    }

    private static Type.Capability toApiCapability(Type.Capability serverItem) {
        switch (serverItem) {
            case TOP: {
                return Type.Capability.TOP;
            }
            case MEMBERSHIP: {
                return Type.Capability.MEMBERSHIP;
            }
            case WORKFLOW: {
                return Type.Capability.WORKFLOW;
            }
            case STATE: {
                return Type.Capability.STATE;
            }
            case STUDY: {
                return Type.Capability.STUDY;
            }
            case FILES: {
                return Type.Capability.FILES;
            }
        }
        throw new SystemException("Unmapped server capability: " + serverItem.name());
    }

    public static List<AttributeDefinition> toApiAttributeDefinitions(String typeId, List<com.sas.lsaf.svcs.core.type.client.AttributeDefinition> serverItems) {
        ArrayList<AttributeDefinition> apiItems = new ArrayList<AttributeDefinition>(serverItems.size());
        for (com.sas.lsaf.svcs.core.type.client.AttributeDefinition serverItem : serverItems) {
            apiItems.add(TypeHelper.toApiAttributeDefinition(typeId, serverItem));
        }
        return apiItems;
    }

    public static AttributeDefinition toApiAttributeDefinition(String typeId, com.sas.lsaf.svcs.core.type.client.AttributeDefinition serverItem) {
        return new AttributeDefinition(serverItem.getId(), serverItem.getName(), TypeHelper.toApiAttributeType(serverItem.getAttributeType()), !serverItem.getDeclaringTypeId().equals(typeId), serverItem.isEditable(), serverItem.isExtended(), serverItem.isRequired());
    }

    public static List<Type> toApiTypes(List<com.sas.lsaf.svcs.core.type.client.Type> serverItems) {
        ArrayList<Type> apiItems = new ArrayList<Type>();
        for (com.sas.lsaf.svcs.core.type.client.Type serverItem : serverItems) {
            if (serverItem.isMixin() || !serverItem.isAuditable()) continue;
            apiItems.add(TypeHelper.toApiType(serverItem));
        }
        return apiItems;
    }

    public static List<Type> toApiTypesByCapability(List<com.sas.lsaf.svcs.core.type.client.Type> serverItems) {
        return TypeHelper.toApiTypes(serverItems);
    }

    public static Type toApiType(com.sas.lsaf.svcs.core.type.client.Type serverItem) {
        return new Type(serverItem.getId(), serverItem.getName(), serverItem.getDescription(), serverItem.isContextType(), serverItem.isFolderType(), serverItem.isSharedFolderType(), serverItem.isFileType(), TypeHelper.toApiAttributeDefinitions(serverItem.getId(), serverItem.getAttributeDefinitions()), TypeHelper.toApiCapabilities(serverItem.getCapabilities()), serverItem.getAllowableChildTypes(), serverItem.getRevision());
    }

    public static List<TypeDescriptor> toApiTypeDescriptors(List<com.sas.lsaf.svcs.core.type.client.TypeDescriptor> serverItems) {
        ArrayList<TypeDescriptor> apiItems = new ArrayList<TypeDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.core.type.client.TypeDescriptor serverItem : serverItems) {
            if (serverItem.isMixin() || serverItem.isAbstract() || !serverItem.isAuditable()) continue;
            apiItems.add(TypeHelper.toApiTypeDescriptor(serverItem));
        }
        return apiItems;
    }

    public static TypeDescriptor toApiTypeDescriptor(com.sas.lsaf.svcs.core.type.client.TypeDescriptor serverItem) {
        return new TypeDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getDescription(), serverItem.isContextType(), serverItem.isFolderType(), serverItem.isSharedFolderType(), serverItem.isFileType());
    }

    public static List<Type> toApiSearchableTypes(List<com.sas.lsaf.svcs.core.type.client.Type> serverItems) {
        ArrayList<Type> apiItems = new ArrayList<Type>();
        for (com.sas.lsaf.svcs.core.type.client.Type serverItem : serverItems) {
            if (serverItem.isMixin() || !serverItem.isSearchable()) continue;
            apiItems.add(TypeHelper.toApiType(serverItem));
        }
        return apiItems;
    }

    public static List<Type> toApiAuditableTypes(List<com.sas.lsaf.svcs.core.type.client.Type> serverItems) {
        ArrayList<Type> apiItems = new ArrayList<Type>();
        for (com.sas.lsaf.svcs.core.type.client.Type serverItem : serverItems) {
            if (serverItem.isMixin() || !serverItem.isAuditable()) continue;
            apiItems.add(TypeHelper.toApiType(serverItem));
        }
        return apiItems;
    }

    public static Type.Capability toServerCapability(Type.Capability apiItem) {
        switch (apiItem) {
            case TOP: {
                return Type.Capability.TOP;
            }
            case MEMBERSHIP: {
                return Type.Capability.MEMBERSHIP;
            }
            case WORKFLOW: {
                return Type.Capability.WORKFLOW;
            }
            case STATE: {
                return Type.Capability.STATE;
            }
            case STUDY: {
                return Type.Capability.STUDY;
            }
            case FILES: {
                return Type.Capability.FILES;
            }
        }
        throw new SystemException("Unmapped api capability: " + apiItem.name());
    }
}

