/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.dao.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractJdbcDao {
    public static final int DEFAULT_INCLAUSE_VARIABLE_LIMIT = 1000;
    public static final int DEFAULT_LOCK_FOR_UPDATE_WAIT = 0;
    public static final String LOCK_NOWAIT_CLAUSE = " for update nowait";
    public static final String LOCK_WAIT_CLAUSE = " for update wait ";
    protected JdbcTemplate jdbcTemplate;
    private int inClauseVariableLimit = 1000;

    @Required
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setInClauseVariableLimit(int inClauseVariableLimit) {
        this.inClauseVariableLimit = inClauseVariableLimit;
    }

    protected List<InStatement> buildInClause(String sql, Set<? extends Object> values) {
        return this.buildInClause(sql, new ArrayList<Object>(values));
    }

    protected List<InStatement> buildInClause(String sql, List<? extends Object> values) {
        return this.buildInClause(sql, values, "@");
    }

    protected List<InStatement> buildInClause(String sql, List<? extends Object> values, String token) {
        int end;
        ArrayList<InStatement> inStatements = new ArrayList<InStatement>();
        int start = 0;
        int n = end = values.size() > this.inClauseVariableLimit ? this.inClauseVariableLimit : values.size();
        while (start < values.size()) {
            StringBuilder inClauseSb = new StringBuilder();
            ArrayList<Object> inValues = new ArrayList<Object>(end - start);
            for (int i = start; i < end; ++i) {
                inClauseSb.append("?,");
                inValues.add(values.get(i));
            }
            String inClause = inClauseSb.substring(0, inClauseSb.length() - 1);
            String newSql = sql.replace(token, inClause);
            inStatements.add(new InStatement(newSql, inValues));
            start = end;
            end = values.size() > (end += this.inClauseVariableLimit) ? end : values.size();
        }
        return inStatements;
    }

    protected int queryForInt(String sql, Object ... args) throws DataAccessException {
        Number number = (Number)this.jdbcTemplate.queryForObject(sql, args, Integer.class);
        return number != null ? number.intValue() : 0;
    }

    protected long queryForLong(String sql, Object ... args) throws DataAccessException {
        Number number = (Number)this.jdbcTemplate.queryForObject(sql, args, Long.class);
        return number != null ? number.longValue() : 0L;
    }

    protected String queryForString(String sql, Object ... args) throws DataAccessException {
        String string = (String)this.jdbcTemplate.queryForObject(sql, args, String.class);
        return string;
    }

    public static class InStatement {
        private String sql;
        private List<? extends Object> values;

        public InStatement(String sql, List<? extends Object> values) {
            this.sql = sql;
            this.values = values;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public List<? extends Object> getValues() {
            return this.values;
        }

        public void setValues(List<? extends Object> values) {
            this.values = values;
        }
    }
}

