/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.configuration.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.configuration.ApplicationInformation;
import com.sas.lsaf.core.configuration.ApplicationInformationService;
import com.sas.lsaf.core.configuration.impl.ServerVersion;
import com.sas.lsaf.svcs.core.config.client.Configuration;
import com.sas.lsaf.svcs.core.config.client.ConfigurationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class ApplicationInformationServiceImpl
implements ApplicationInformationService,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(ApplicationInformationServiceImpl.class);
    private ConfigurationService configurationService;
    private ApplicationInformation applicationInformation;

    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ApplicationInformation getApplicationInformation() {
        return this.applicationInformation;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Configuration temp = this.configurationService.getConfiguration();
            if (temp != null) {
                this.applicationInformation = new ApplicationInformation(ServerVersion.getVersion(), temp.getApplicationInfo().getServerApplicationVersion());
                LOG.info((Object)"SAS Life Sciences Analytics Framework Java API is installed");
                LOG.info((Object)("    JAPI client version:  " + this.applicationInformation.getApiClientVersion()));
                LOG.info((Object)("    JAPI server version:  " + this.applicationInformation.getApiServerVersion()));
                LOG.info((Object)("    LSAF server version:  " + this.applicationInformation.getAppServerVersion()));
            } else {
                LOG.error((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                LOG.error((Object)"!! SAS Life Sciences Analytics Framework Java API is not installed properly");
                LOG.error((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

