/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.action.impl;

import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.impl.ActionStatusHelper;
import com.sas.lsaf.core.action.impl.InternalActionStatusService;
import com.sas.lsaf.svcs.core.action.client.ActionStatus;
import com.sas.lsaf.svcs.core.action.client.ActionStatusService;
import com.sas.lsaf.svcs.core.utils.client.ThreadUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class InternalActionStatusServiceImpl
implements InternalActionStatusService {
    private ActionStatusService actionStatusService;
    private int sleepMillis = 1000;
    private int maxWaitMillis = 3600000;

    @Required
    public void setActionStatusService(ActionStatusService actionStatusService) {
        this.actionStatusService = actionStatusService;
    }

    public void setSleepMillis(int sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    public void setMaxWaitMillis(int maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public ActionStatus getCompletedActionStatusById(String id) {
        Assert.hasText((String)id, (String)"Action status identifier is required.");
        try {
            com.sas.lsaf.svcs.core.action.client.ActionStatus serverItem = this.actionStatusService.getActionStatusById(id);
            long start = System.currentTimeMillis();
            while (serverItem.getSummary().getProgressStatus() != ActionStatus.ProgressStatus.CANCELED && serverItem.getSummary().getProgressStatus() != ActionStatus.ProgressStatus.COMPLETED) {
                ThreadUtils.sleepQuietly((long)this.sleepMillis);
                serverItem = this.actionStatusService.getActionStatusById(id);
                Date lastUpdate = serverItem.getSummary().getLastUpdated();
                if (System.currentTimeMillis() <= (lastUpdate != null ? lastUpdate.getTime() : start) + (long)this.maxWaitMillis) continue;
                throw new IllegalStateException("Action status never reached COMPLETED state after waiting " + this.maxWaitMillis + "ms");
            }
            return ActionStatusHelper.toApiActionStatus(serverItem);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void clearById(String id) {
        Assert.hasText((String)id, (String)"Action status identifier is required.");
        try {
            this.actionStatusService.clearById(id);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

