/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.action.impl;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.ActionStatusDetail;
import com.sas.lsaf.svcs.core.action.client.ActionStatus;
import java.util.ArrayList;
import java.util.List;

public class ActionStatusHelper {
    private static ActionStatus.CompletionStatus toApiCompletionStatus(ActionStatus.CompletionStatus serverItem) {
        switch (serverItem) {
            case INFO: {
                return ActionStatus.CompletionStatus.INFO;
            }
            case WARN: {
                return ActionStatus.CompletionStatus.WARN;
            }
            case ERROR: {
                return ActionStatus.CompletionStatus.ERROR;
            }
        }
        throw new SystemException("Unmapped completion status: " + serverItem.name());
    }

    public static ActionStatusDetail toApiActionStatusDetail(com.sas.lsaf.svcs.core.action.client.ActionStatusDetail serverItem) {
        ActionStatusDetail apiItem = new ActionStatusDetail(serverItem.getId(), serverItem.getItemIdentifier(), serverItem.getItemLocation(), serverItem.getItemName(), serverItem.getMessageCode(), serverItem.getMessage(), ActionStatusHelper.toApiCompletionStatus(serverItem.getCompletionStatus()));
        return apiItem;
    }

    public static List<ActionStatusDetail> toApiActionStatusDetails(List<com.sas.lsaf.svcs.core.action.client.ActionStatusDetail> serverItems) {
        ArrayList<ActionStatusDetail> apiItems = new ArrayList<ActionStatusDetail>(serverItems.size());
        for (com.sas.lsaf.svcs.core.action.client.ActionStatusDetail serverItem : serverItems) {
            apiItems.add(ActionStatusHelper.toApiActionStatusDetail(serverItem));
        }
        return apiItems;
    }

    public static ActionStatus toApiActionStatus(com.sas.lsaf.svcs.core.action.client.ActionStatus serverItem) {
        ActionStatus apiItem = new ActionStatus(ActionStatusHelper.toApiCompletionStatus(serverItem.getSummary().getCompletionStatus()), serverItem.getSummary().getMessage());
        apiItem.getDetails().addAll(ActionStatusHelper.toApiActionStatusDetails(serverItem.getDetails()));
        return apiItem;
    }
}

