/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core;

import com.sas.lsaf.core.ValidationException;

public final class ValidationUtils {
    public static void validateVersion(String version) throws ValidationException {
        if (version != null && !version.trim().isEmpty()) {
            int dot = version.indexOf(46);
            if (dot == -1) {
                throw new ValidationException("Invalid version syntax, missing dot notation:  '" + version + "'");
            }
            int newMajor = 0;
            String majorString = version.substring(0, dot);
            try {
                newMajor = Integer.parseInt(majorString);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid version syntax, major specification is not an integer:  '" + version + "'");
            }
            if (majorString.length() > 1 && majorString.startsWith("0")) {
                throw new ValidationException("Invalid version syntax, major specification cannot lead with zeroes:  '" + version + "'");
            }
            if (newMajor > 99999) {
                throw new ValidationException("Invalid version syntax, major specification cannot exceed 99999:  '" + version + "'");
            }
            int newMinor = 0;
            String minorString = version.substring(dot + 1);
            if (minorString.length() > 1 && minorString.startsWith("0")) {
                throw new ValidationException("Invalid version syntax, minor specification cannot lead with zeroes:  '" + version + "'");
            }
            try {
                newMinor = Integer.parseInt(minorString);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid version syntax, minor specification is not an integer:  '" + version + "'");
            }
            if (newMinor > 99999) {
                throw new ValidationException("Invalid version syntax, minor specification cannot exceed 99999:  '" + version + "'");
            }
            if (newMajor == 0 && newMinor == 0) {
                throw new ValidationException("Invalid version syntax. 0.0 is not a valid version.");
            }
            if (newMajor < 0) {
                throw new ValidationException("Invalid version syntax. Version value cannot be negative.");
            }
        }
    }

    public static void validatePath(String path) {
        if (!path.startsWith("/")) {
            throw new ValidationException("Path must start with a slash.");
        }
    }
}

