/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core;

import com.sas.lsaf.svcs.content.workspace.client.WorkspaceFolder;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceItem;
import com.sas.lsaf.svcs.core.utils.client.PathUtils;
import com.sas.lsaf.svcs.core.utils.client.UriUtils;

public final class ResourceUtils {
    public static final String WORKSPACE_PARAMETER = "workspace";
    public static final String ID = "id";
    public static final String VERSION = "version";
    public static final String TYPE = "objectType";

    private ResourceUtils() {
    }

    public static String getName(String uri) {
        return PathUtils.getName((String)ResourceUtils.getPath(uri));
    }

    public static String getName(String uri, boolean decode) {
        return PathUtils.getName((String)ResourceUtils.getPath(uri, decode));
    }

    public static String getVersion(String uri) {
        return UriUtils.getQueryParameterValue((String)uri, (String)VERSION);
    }

    public static String getId(String uri) {
        return UriUtils.getQueryParameterValue((String)uri, (String)ID);
    }

    public static String getWorkspace(String uri) {
        String ret = null;
        if (uri.lastIndexOf("/") == uri.length() - 1) {
            return null;
        }
        if (uri.indexOf("?workspace", uri.lastIndexOf("/")) != -1) {
            ret = uri.substring(uri.indexOf("?workspace", uri.lastIndexOf("/")) + 11);
        }
        return ret;
    }

    public static String getScheme(String uri) {
        if (uri == null) {
            return null;
        }
        if (ResourceUtils.isWorkspaceFile(uri)) {
            return "work://";
        }
        if (ResourceUtils.isRepositoryFile(uri)) {
            return "sdd://";
        }
        return null;
    }

    public static String getParentPath(String uri) {
        return PathUtils.getParentPath((String)ResourceUtils.getPath(uri));
    }

    public static String getParentPath(String uri, boolean decode) {
        return PathUtils.getParentPath((String)ResourceUtils.getPath(uri, decode));
    }

    public static String getPath(String uri) {
        return ResourceUtils.getPath(uri, false);
    }

    public static String getPath(String uri, boolean decode) {
        String ret = uri;
        if (ret == null) {
            return ret;
        }
        ret = ret.replace("/^.*:\\/\\/([^?]*)\\??.*$/", "$1");
        if (decode) {
            ret = UriUtils.decode((String)ret);
        }
        if (ret.substring(0, "work://".length()).equals("work://")) {
            int endPathIndex = (ret = ret.substring("work://".length())).lastIndexOf("?");
            if (endPathIndex == -1) {
                endPathIndex = ret.length();
            }
            ret = ret.substring(0, endPathIndex);
        } else if (ret.substring(0, "sdd://".length()).equals("sdd://")) {
            int endPathIndex = ret.lastIndexOf("?");
            if (endPathIndex == -1) {
                endPathIndex = ret.length();
            }
            ret = ret.substring("sdd://".length(), endPathIndex);
        }
        return ret;
    }

    public static String workspaceUri(WorkspaceItem item, boolean encode) {
        return ResourceUtils.workspaceUri(item.getPath(), item.getWorkspaceId(), encode);
    }

    public static String workspaceUri(WorkspaceFolder parent, String name, boolean encode) {
        return ResourceUtils.workspaceUri(parent.getPath() + "/" + name, parent.getWorkspaceId(), encode);
    }

    public static String workspaceUri(String path, String workspaceId, boolean encode) {
        return "work://" + (encode ? UriUtils.encodeFragment((String)path) : path) + (workspaceId != null && workspaceId.length() > 0 ? "?workspace=" + workspaceId : "");
    }

    public static String workspaceUri(String path, String workspaceId) {
        return "work://" + UriUtils.encodeFragment((String)path) + (workspaceId != null && workspaceId.length() > 0 ? "?workspace=" + workspaceId : "");
    }

    public static String repositoryUri(String path, String resourceId, String version, boolean encode) {
        return ResourceUtils.repositoryUri(path, resourceId, null, version, encode);
    }

    public static String repositoryUri(String path, String resourceId, String typeId, String version, boolean encode) {
        StringBuffer uri = new StringBuffer("sdd://");
        if (path != null && !path.isEmpty()) {
            if (encode) {
                uri.append(UriUtils.encodeFragment((String)path));
            } else {
                uri.append(path);
            }
        }
        StringBuffer query = new StringBuffer();
        if (resourceId != null && !resourceId.isEmpty()) {
            query.append("&id=" + resourceId);
        }
        if (typeId != null && !typeId.isEmpty()) {
            query.append("&objectType=" + typeId);
        }
        if (version != null && !version.isEmpty()) {
            query.append("&version=" + version);
        }
        if (query.length() > 1) {
            uri.append("?" + query.substring(1));
        }
        return uri.toString();
    }

    public static boolean isWorkspaceFile(String uri) {
        return uri.substring(0, "work://".length()).equals("work://");
    }

    public static boolean isRepositoryFile(String uri) {
        return uri.substring(0, "sdd://".length()).equals("sdd://");
    }

    public static boolean isSASFile(String uri) {
        return uri.substring(0, "sas://".length()).equals("sas://");
    }

    public static String sasUri(String libName, String memberName, boolean encode) {
        StringBuffer sasUri = new StringBuffer();
        sasUri.append("sas://");
        if (libName != null) {
            sasUri.append(encode ? UriUtils.encodeFragment((String)libName) : libName);
            sasUri.append(".");
            if (memberName != null) {
                sasUri.append(encode ? UriUtils.encodeFragment((String)memberName) : memberName);
            }
        }
        return sasUri.toString();
    }

    public static String getLibraryName(String uri) {
        String libEntityName;
        int extensionIndex;
        String rval = uri;
        if (uri != null && uri.startsWith("sas://") && (extensionIndex = (libEntityName = uri.substring("sas://".length())).indexOf(".")) > -1) {
            rval = libEntityName.substring(0, extensionIndex);
        }
        return rval;
    }
}

