/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core;

import com.sas.lsaf.content.repository.CopyToWorkspaceException;
import com.sas.lsaf.content.repository.RepositoryContextTypeDisabledException;
import com.sas.lsaf.content.repository.RepositoryItemCheckedoutException;
import com.sas.lsaf.content.workspace.WorkspacePathNotFoundException;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.DataAccessException;
import com.sas.lsaf.core.Identifiable;
import com.sas.lsaf.core.IllegalPathException;
import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.core.OptimisticLockException;
import com.sas.lsaf.core.PessimisticLockException;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.ValidationMessage;
import com.sas.lsaf.core.ValidationResult;
import com.sas.lsaf.core.type.IllegalChildTypeException;
import com.sas.lsaf.core.type.IllegalTypeException;
import com.sas.lsaf.execution.session.SessionUnsupportedFeatureException;
import com.sas.lsaf.query.QueryLimitException;
import com.sas.lsaf.security.group.GroupContextNotFoundException;
import com.sas.lsaf.security.role.RoleContextNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.exception.CheckedoutException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemIllegalStateException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemLockedException;
import com.sas.lsaf.svcs.content.resource.client.exception.ResourceIllegalStateException;
import com.sas.lsaf.svcs.content.synchronization.client.exception.SynchronizationItemDeniedException;
import com.sas.lsaf.svcs.content.workspace.client.exception.SharedWorkspaceNotFoundException;
import com.sas.lsaf.svcs.core.common.client.ValidationMessage;
import com.sas.lsaf.svcs.core.event.server.EventListenerException;
import com.sas.lsaf.svcs.security.acl.client.exception.AclValidationException;
import com.sas.lsaf.svcs.security.membership.client.exception.MembershipContextNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CoreHelper {
    public static RuntimeException handleThrowable(Throwable t) {
        if (t instanceof RepositoryItemLockedException) {
            return new com.sas.lsaf.content.repository.RepositoryItemLockedException(((RepositoryItemLockedException)t).getPath(), t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.content.repository.client.exception.RepositoryContextTypeDisabledException) {
            return new RepositoryContextTypeDisabledException(((com.sas.lsaf.svcs.content.repository.client.exception.RepositoryContextTypeDisabledException)t).getPath(), t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.dao.client.exception.OptimisticLockException) {
            return new OptimisticLockException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.dao.client.exception.PessimisticLockException) {
            return new PessimisticLockException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.dao.client.exception.DataAccessException) {
            return new DataAccessException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.type.client.exception.IllegalChildTypeException) {
            return new IllegalChildTypeException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.type.client.exception.IllegalTypeException) {
            return new IllegalTypeException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.core.validation.client.ValidationException) {
            return new ValidationException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.security.authorization.client.exception.AccessDeniedException) {
            return new AccessDeniedException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.security.group.client.exception.GroupContextNotFoundException) {
            return new GroupContextNotFoundException(t.getLocalizedMessage());
        }
        if (t instanceof MembershipContextNotFoundException) {
            return new com.sas.lsaf.security.membership.MembershipContextNotFoundException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.security.role.client.exceptions.RoleContextNotFoundException) {
            return new RoleContextNotFoundException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.execution.session.client.exception.SessionUnsupportedFeatureException) {
            return new SessionUnsupportedFeatureException(t.getLocalizedMessage());
        }
        if (t instanceof SharedWorkspaceNotFoundException) {
            return new com.sas.lsaf.content.workspace.SharedWorkspaceNotFoundException(t.getLocalizedMessage());
        }
        if (t instanceof com.sas.lsaf.svcs.content.workspace.client.exception.WorkspacePathNotFoundException) {
            return new WorkspacePathNotFoundException(t.getLocalizedMessage());
        }
        if (t instanceof GroupContextNotFoundException) {
            return (GroupContextNotFoundException)t;
        }
        if (t instanceof com.sas.lsaf.security.membership.MembershipContextNotFoundException) {
            return (com.sas.lsaf.security.membership.MembershipContextNotFoundException)t;
        }
        if (t instanceof RoleContextNotFoundException) {
            return (RoleContextNotFoundException)t;
        }
        if (t instanceof QueryLimitException) {
            return (QueryLimitException)t;
        }
        if (t instanceof RuntimeException) {
            String exceptionClassName = t.getClass().getCanonicalName();
            if (exceptionClassName == null) {
                exceptionClassName = "";
            }
            if (t instanceof ResourceIllegalStateException) {
                IllegalArgumentException better = new IllegalArgumentException(t.getLocalizedMessage());
                better.setStackTrace(t.getStackTrace());
                return better;
            }
            if (t instanceof SynchronizationItemDeniedException) {
                SynchronizationItemDeniedException e = (SynchronizationItemDeniedException)t;
                return new CopyToWorkspaceException(e.getPath(), e.getLocalizedMessage());
            }
            if (exceptionClassName.startsWith("com.sas.hls")) {
                return (RuntimeException)t;
            }
            if (t instanceof IllegalArgumentException) {
                IllegalArgumentException noDependencies = new IllegalArgumentException(t.getLocalizedMessage(), CoreHelper.stripExceptionOfIdentity(t.getCause()));
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof IllegalPathException) {
                IllegalPathException noDependencies = new IllegalPathException(t.getLocalizedMessage());
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof IllegalTypeException) {
                IllegalTypeException noDependencies = new IllegalTypeException(t.getLocalizedMessage());
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof IllegalStateException) {
                IllegalStateException noDependencies = new IllegalStateException(t.getLocalizedMessage(), CoreHelper.stripExceptionOfIdentity(t.getCause()));
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof ValidationException) {
                ValidationException noDependencies = new ValidationException(t.getLocalizedMessage());
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof AccessDeniedException) {
                AccessDeniedException noDependencies = new AccessDeniedException(t.getLocalizedMessage());
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof SessionUnsupportedFeatureException) {
                SessionUnsupportedFeatureException noDependencies = new SessionUnsupportedFeatureException(t.getLocalizedMessage());
                noDependencies.setStackTrace(t.getStackTrace());
                return noDependencies;
            }
            if (t instanceof CheckedoutException) {
                RepositoryItemCheckedoutException e = new RepositoryItemCheckedoutException(((CheckedoutException)t).getPath(), t.getLocalizedMessage());
                e.setStackTrace(t.getStackTrace());
                return e;
            }
            if (t instanceof RepositoryItemLockedException) {
                com.sas.lsaf.content.repository.RepositoryItemLockedException e = new com.sas.lsaf.content.repository.RepositoryItemLockedException(((RepositoryItemLockedException)t).getPath(), t.getLocalizedMessage());
                e.setStackTrace(t.getStackTrace());
                return e;
            }
            if (t instanceof RepositoryItemIllegalStateException) {
                com.sas.lsaf.content.repository.RepositoryItemIllegalStateException e = new com.sas.lsaf.content.repository.RepositoryItemIllegalStateException(((RepositoryItemIllegalStateException)t).getPath(), t.getLocalizedMessage());
                e.setStackTrace(t.getStackTrace());
                return e;
            }
            if (t instanceof EventListenerException && t.getCause() != null && t.getCause() instanceof AclValidationException) {
                return new com.sas.lsaf.security.acl.AclValidationException(t.getCause().getLocalizedMessage());
            }
        }
        SystemException facadeException = new SystemException(t.getLocalizedMessage(), (Throwable)CoreHelper.stripExceptionOfIdentity(t.getCause()));
        facadeException.setStackTrace(t.getStackTrace());
        return facadeException;
    }

    public static RuntimeException stripExceptionOfIdentity(Exception e) {
        if (e == null) {
            return null;
        }
        RuntimeException ret = new RuntimeException(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage());
        ret.setStackTrace(e.getStackTrace());
        return ret;
    }

    public static RuntimeException stripExceptionOfIdentity(Throwable e) {
        if (e == null) {
            return null;
        }
        RuntimeException ret = new RuntimeException(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage());
        ret.setStackTrace(e.getStackTrace());
        return ret;
    }

    public static Set<String> toStringSet(List<String> list) {
        HashSet<String> rval = new HashSet<String>(0);
        rval.addAll(list);
        return rval;
    }

    public static List<String> toStringList(Set<String> list) {
        ArrayList<String> rval = new ArrayList<String>(0);
        rval.addAll(list);
        return rval;
    }

    public static Attribute toApiAttribute(com.sas.lsaf.svcs.core.common.client.Attribute a) {
        Attribute rval = new Attribute();
        rval.setId(a.getName());
        Serializable val = a.getValue();
        if (val != null) {
            rval.setValue(val);
        }
        return rval;
    }

    public static List<Attribute> toApiAttributes(List<com.sas.lsaf.svcs.core.common.client.Attribute> as) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        if (as != null) {
            for (com.sas.lsaf.svcs.core.common.client.Attribute a : as) {
                ret.add(CoreHelper.toApiAttribute(a));
            }
        }
        return ret;
    }

    public static com.sas.lsaf.svcs.core.common.client.Attribute toServerAttribute(Attribute a) {
        com.sas.lsaf.svcs.core.common.client.Attribute rval = new com.sas.lsaf.svcs.core.common.client.Attribute();
        Serializable val = a.getValue();
        rval.setName(a.getId());
        if (val != null) {
            rval.setValue(val);
        }
        return rval;
    }

    public static List<com.sas.lsaf.svcs.core.common.client.Attribute> toServerAttributes(List<Attribute> as) {
        ArrayList<com.sas.lsaf.svcs.core.common.client.Attribute> ret = new ArrayList<com.sas.lsaf.svcs.core.common.client.Attribute>();
        if (as != null) {
            for (Attribute a : as) {
                ret.add(CoreHelper.toServerAttribute(a));
            }
        }
        return ret;
    }

    public static ObjectIdentity toApiObjectIdentity(com.sas.lsaf.svcs.core.common.client.ObjectIdentity serverItem) {
        return new ObjectIdentity(serverItem.getTypeId(), serverItem.getId());
    }

    public static com.sas.lsaf.svcs.core.common.client.ObjectIdentity toServerObjectIdentity(ObjectIdentity apiItem) {
        if (apiItem == null) {
            return null;
        }
        return new com.sas.lsaf.svcs.core.common.client.ObjectIdentity(apiItem.getTypeId(), apiItem.getId());
    }

    public static Set<String> toIds(Collection<? extends Identifiable> apiItems) {
        HashSet<String> ids = new HashSet<String>();
        if (apiItems != null) {
            for (Identifiable identifiable : apiItems) {
                if (identifiable == null) continue;
                ids.add(identifiable.getId());
            }
        }
        return ids;
    }

    public static SearchResultsInfo toApiSearchResultsInfo(com.sas.lsaf.svcs.core.search.client.SearchResultsInfo serverItem) {
        return new SearchResultsInfo(serverItem.getToken(), serverItem.getRowCount(), serverItem.isLimitReached());
    }

    public static ValidationResult toApiValidationResult(com.sas.lsaf.svcs.core.common.client.ValidationResult serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ValidationResult(CoreHelper.toApiValidationMessages(serverItem.getErrors()), CoreHelper.toApiValidationMessages(serverItem.getWarnings()), CoreHelper.toApiValidationMessages(serverItem.getNotes()), serverItem.getRunBy(), serverItem.getRunDate());
    }

    private static List<ValidationMessage> toApiValidationMessages(List<com.sas.lsaf.svcs.core.common.client.ValidationMessage> serverItems) {
        ArrayList<ValidationMessage> ret = new ArrayList<ValidationMessage>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.core.common.client.ValidationMessage serverItem : serverItems) {
                ret.add(CoreHelper.toApiValidationMessage(serverItem));
            }
        }
        return ret;
    }

    private static ValidationMessage toApiValidationMessage(com.sas.lsaf.svcs.core.common.client.ValidationMessage serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ValidationMessage(serverItem.getProblem(), CoreHelper.toApiValidationMessageSeverity(serverItem.getSeverity()), serverItem.getColumnName(), serverItem.getRowNumber());
    }

    private static ValidationMessage.Severity toApiValidationMessageSeverity(ValidationMessage.Severity serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case ERROR: {
                return ValidationMessage.Severity.ERROR;
            }
            case WARNING: {
                return ValidationMessage.Severity.WARNING;
            }
            case NOTE: {
                return ValidationMessage.Severity.NOTE;
            }
        }
        throw new SystemException("Unmapped server validation message severity: " + serverItem.name());
    }
}

