/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.workspace.impl;

import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.content.workspace.WorkspaceFile;
import com.sas.lsaf.content.workspace.WorkspaceFolder;
import com.sas.lsaf.content.workspace.WorkspaceItem;
import com.sas.lsaf.content.workspace.WorkspaceItemCopyException;
import com.sas.lsaf.content.workspace.WorkspaceItemDeleteException;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.content.workspace.WorkspaceItemMoveException;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.content.workspace.WorkspaceMarkForAddException;
import com.sas.lsaf.content.workspace.WorkspaceService;
import com.sas.lsaf.content.workspace.impl.InternalWorkspaceService;
import com.sas.lsaf.content.workspace.impl.WorkspaceHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.IllegalPathException;
import com.sas.lsaf.core.utils.impl.PathUtils;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationEntry;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationService;
import com.sas.lsaf.svcs.content.synchronization.client.exception.SynchronizationItemException;
import com.sas.lsaf.svcs.content.workspace.client.BatchWorkspaceService;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public class WorkspaceServiceImpl
implements WorkspaceService,
InternalWorkspaceService {
    private com.sas.lsaf.svcs.content.workspace.client.WorkspaceService workspaceService;
    private BatchWorkspaceService batchWorkspaceService;
    private SynchronizationService synchronizationService;

    private String doGetWorkspaceId() {
        return this.workspaceService.getCurrentUserWorkspace().getId();
    }

    private void doAssertPathIsToFile(String path) throws com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException {
        com.sas.lsaf.svcs.content.workspace.client.WorkspaceItem lsafWorkspaceItem = this.workspaceService.getByPath(this.doGetWorkspaceId(), path);
        if (!(lsafWorkspaceItem instanceof com.sas.lsaf.svcs.content.workspace.client.WorkspaceFile)) {
            throw new IllegalPathException("Path must be to a file not a container.");
        }
    }

    @Required
    public void setWorkspaceService(com.sas.lsaf.svcs.content.workspace.client.WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    @Required
    public void setBatchWorkspaceService(BatchWorkspaceService batchWorkspaceService) {
        this.batchWorkspaceService = batchWorkspaceService;
    }

    @Required
    public void setSynchronizationService(SynchronizationService synchronizationService) {
        this.synchronizationService = synchronizationService;
    }

    public WorkspaceFolder createFolder(String path, boolean createParentFolders) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        PathUtils.validatePath((String)path);
        try {
            return WorkspaceHelper.toApiWorkspaceFolder(this.workspaceService.createFolderByPath(this.doGetWorkspaceId(), path, createParentFolders));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException e) {
            throw new WorkspaceItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public WorkspaceFile createFile(String path, String localFilePath, boolean createParentFolders) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public WorkspaceItem rename(String path, String name) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)name, (String)"Name is required.");
        try {
            com.sas.lsaf.svcs.content.workspace.client.WorkspaceItem serverItem = this.workspaceService.getByPath(this.doGetWorkspaceId(), path);
            return WorkspaceHelper.toApiWorkspaceItem(this.workspaceService.rename(serverItem, name));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException e) {
            throw new WorkspaceItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public WorkspaceItem move(String sourcePath, String destinationPath) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, WorkspaceItemMoveException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        PathUtils.validatePath((String)sourcePath);
        PathUtils.validatePath((String)destinationPath);
        try {
            return WorkspaceHelper.toApiWorkspaceItem(this.workspaceService.move(this.doGetWorkspaceId(), sourcePath, destinationPath));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException e) {
            throw new WorkspaceItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemMoveException e) {
            throw new WorkspaceItemMoveException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public WorkspaceItem copy(String sourcePath, String destinationPath) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, WorkspaceItemCopyException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        PathUtils.validatePath((String)sourcePath);
        PathUtils.validatePath((String)destinationPath);
        try {
            return WorkspaceHelper.toApiWorkspaceItem(this.workspaceService.copy(this.doGetWorkspaceId(), sourcePath, destinationPath));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException e) {
            throw new WorkspaceItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemCopyException e) {
            throw new WorkspaceItemCopyException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void delete(String path) throws WorkspaceItemNotFoundException, WorkspaceItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        PathUtils.validatePath((String)path);
        try {
            this.workspaceService.deleteByPath(this.doGetWorkspaceId(), path);
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemDeleteException e) {
            throw new WorkspaceItemDeleteException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void downloadFile(String path, String outputFilePath) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public boolean exists(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            PathUtils.validatePath((String)path);
            return this.workspaceService.existsByPath(this.doGetWorkspaceId(), path);
        }
        catch (IllegalPathException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public WorkspaceItem getItem(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        PathUtils.validatePath((String)path);
        try {
            return WorkspaceHelper.toApiWorkspaceItem(this.workspaceService.getByPath(this.doGetWorkspaceId(), path));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<WorkspaceItem> getChildren(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            com.sas.lsaf.svcs.content.workspace.client.WorkspaceItem serverParent = this.workspaceService.getByPath(this.doGetWorkspaceId(), path);
            if (serverParent instanceof com.sas.lsaf.svcs.content.workspace.client.WorkspaceFile) {
                throw new IllegalPathException("Path must be to a folder not a file: " + path);
            }
            List serverChildren = this.workspaceService.getChildren((com.sas.lsaf.svcs.content.workspace.client.WorkspaceFolder)serverParent);
            return WorkspaceHelper.toApiWorkspaceItems(serverChildren);
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public WorkspaceFile updateFileContents(String path, String localFilePath) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public void markForAdd(String path) throws WorkspaceMarkForAddException, WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        PathUtils.validatePath((String)path);
        try {
            this.doAssertPathIsToFile(path);
            this.synchronizationService.markForAdd(this.doGetWorkspaceId(), path);
        }
        catch (SynchronizationItemException e) {
            throw new WorkspaceMarkForAddException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String batchPrepareUpload(Set<String> paths) {
        Assert.notEmpty(paths, (String)"Paths are required.");
        return this.batchWorkspaceService.batchPrepareUpload(paths).getId();
    }

    public String batchPrepareUploadAndExpand(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.batchWorkspaceService.batchPrepareUploadAndExpand(path).getId();
    }

    public SynchronizationInfo.CheckoutStatus getCheckoutStatus(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doAssertPathIsToFile(path);
            SynchronizationEntry syncEntry = this.synchronizationService.getSynchronizationEntry(this.doGetWorkspaceId(), path);
            return RepositoryHelper.toApiCheckoutStatus(syncEntry.getCheckoutStatus());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

