/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.workspace.impl;

import com.sas.lsaf.content.workspace.SharedWorkspaceEntry;
import com.sas.lsaf.content.workspace.SharedWorkspaceLinkNotFoundException;
import com.sas.lsaf.content.workspace.SharedWorkspaceService;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.content.workspace.impl.WorkspaceHelper;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.security.privilege.ScopedPrivileges;
import com.sas.lsaf.svcs.content.repository.client.RepositoryPrivileges;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.workspace.client.SharedWorkspace;
import com.sas.lsaf.svcs.content.workspace.client.exception.SharedWorkspaceEntryNotFoundException;
import com.sas.lsaf.svcs.security.authentication.server.ServerSecurityContext;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import com.sas.lsaf.svcs.security.principal.client.Principal;
import com.sas.lsaf.svcs.security.principal.server.PrincipalIdentity;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class SharedWorkspaceServiceImpl
implements SharedWorkspaceService {
    private com.sas.lsaf.svcs.content.workspace.client.SharedWorkspaceService sharedWorkspaceService;
    private RepositoryService repositoryService;
    private AuthorizationService authorizationService;

    @Required
    public void setSharedWorkspaceService(com.sas.lsaf.svcs.content.workspace.client.SharedWorkspaceService sharedWorkspaceService) {
        this.sharedWorkspaceService = sharedWorkspaceService;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public SharedWorkspaceEntry createLink(String sharedFolderId, String userId) throws WorkspaceItemExistsException, WorkspaceItemNotFoundException {
        Assert.hasText((String)sharedFolderId, (String)"Shared folder ID is required.");
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            this.doCheckUserCanCreateLink(sharedFolderId, userId);
            return WorkspaceHelper.toApiSharedWorkspaceEntry(this.sharedWorkspaceService.createLink(sharedFolderId, userId));
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException e) {
            throw new WorkspaceItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemExistsException e) {
            throw new WorkspaceItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void deleteLink(String sharedFolderId, String userId) throws SharedWorkspaceLinkNotFoundException {
        Assert.hasText((String)sharedFolderId, (String)"Shared folder ID is required.");
        Assert.hasText((String)userId, (String)"User ID is required.");
        try {
            if (!ServerSecurityContext.getCurrentUserId().equals(userId)) {
                this.doPrivilegeCheck(sharedFolderId, ServerSecurityContext.getCurrentUserId());
            }
            this.sharedWorkspaceService.deleteLink(sharedFolderId, userId);
        }
        catch (com.sas.lsaf.svcs.content.workspace.client.exception.SharedWorkspaceLinkNotFoundException e) {
            throw new SharedWorkspaceLinkNotFoundException(e.getSharedWorkspaceId(), e.getUserId(), e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<SharedWorkspaceEntry> getSharedWorkspaceEntries(String sharedFolderId) {
        Assert.hasText((String)sharedFolderId, (String)"Shared folder ID is required.");
        try {
            this.sharedWorkspaceService.getSharedWorkspace(sharedFolderId);
            return WorkspaceHelper.toApiSharedWorkspaceEntries(this.sharedWorkspaceService.getSharedWorkspaceEntries(sharedFolderId));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void doCheckUserCanCreateLink(String sharedFolderId, String userId) {
        this.sharedWorkspaceService.getSharedWorkspace(sharedFolderId);
        try {
            this.sharedWorkspaceService.getSharedWorkspaceEntry(sharedFolderId, userId);
        }
        catch (SharedWorkspaceEntryNotFoundException e) {
            throw new ValidationException("User must be a valid member of the context to have a link to the shared folder.");
        }
    }

    private void doPrivilegeCheck(String sharedFolderId, String userId) {
        try {
            SharedWorkspace sw = this.sharedWorkspaceService.getSharedWorkspace(sharedFolderId);
            PrincipalIdentity principal = new PrincipalIdentity("sas:user", userId);
            if (!this.authorizationService.principalHasPrivilege((Securable)this.repositoryService.getContextById(sw.getContextId()), (Principal)principal, RepositoryPrivileges.PRIVILEGE_MANAGE_SHARED_FOLDERS)) {
                throw new AccessDeniedException("You cannot perform this action. You have not been granted the privilege \"" + ScopedPrivileges.PRIVILEGE_MANAGE_SHARED_FOLDERS.getName() + "\".");
            }
        }
        catch (RepositoryItemNotFoundException repositoryItemNotFoundException) {
            // empty catch block
        }
    }
}

