/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.utilization.impl;

import com.sas.lsaf.content.utilization.ResourceUtilizationContainerInfo;
import com.sas.lsaf.content.utilization.ResourceUtilizationPathNotFoundException;
import com.sas.lsaf.content.utilization.ResourceUtilizationService;
import com.sas.lsaf.content.utilization.ResourceUtilizationSummaryTransientWorkspaceInfo;
import com.sas.lsaf.content.utilization.ResourceUtilizationTransientWorkspaceInfo;
import com.sas.lsaf.content.utilization.ResourceUtilizationWorkspaceInfo;
import com.sas.lsaf.content.utilization.impl.ResourceUtilizationHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService;
import com.sas.lsaf.svcs.content.workspace.client.SharedWorkspace;
import com.sas.lsaf.svcs.content.workspace.server.InternalSharedWorkspaceService;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class ResourceUtilizationServiceImpl
implements ResourceUtilizationService {
    private com.sas.lsaf.svcs.content.utilization.client.ResourceUtilizationService resourceUtilizationService;
    private InternalSharedWorkspaceService internalSharedWorkspaceService;
    private InternalRepositoryService internalRepositoryService;

    @Required
    public void setResourceUtilizationService(com.sas.lsaf.svcs.content.utilization.client.ResourceUtilizationService resourceUtilizationService) {
        this.resourceUtilizationService = resourceUtilizationService;
    }

    @Required
    public void setInternalSharedWorkspaceService(InternalSharedWorkspaceService internalSharedWorkspaceService) {
        this.internalSharedWorkspaceService = internalSharedWorkspaceService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    public List<ResourceUtilizationSummaryTransientWorkspaceInfo> getAllTransientWorkspaceUtilization() {
        try {
            List serverAllTransient = this.resourceUtilizationService.getAllTransientWorkspaceUtilization();
            HashMap<String, UserTransient> userTransientMap = new HashMap<String, UserTransient>();
            boolean initialCount = true;
            for (com.sas.lsaf.svcs.content.utilization.client.ResourceUtilizationWorkspaceInfo wir : serverAllTransient) {
                UserTransient ut = (UserTransient)userTransientMap.get(wir.getOwner());
                if (ut != null) {
                    ut.setCount(ut.getCount() + 1);
                    ut.setSize(ut.getSize() + wir.getSize());
                    continue;
                }
                userTransientMap.put(wir.getOwner(), new UserTransient(1, wir.getSize()));
            }
            ArrayList<ResourceUtilizationSummaryTransientWorkspaceInfo> ret = new ArrayList<ResourceUtilizationSummaryTransientWorkspaceInfo>();
            for (Map.Entry ent : userTransientMap.entrySet()) {
                ret.add(new ResourceUtilizationSummaryTransientWorkspaceInfo((String)ent.getKey(), ((UserTransient)ent.getValue()).getSize(), ((UserTransient)ent.getValue()).getCount()));
            }
            return ret;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationWorkspaceInfo> getAllUserWorkspaceUtilization() {
        try {
            return ResourceUtilizationHelper.toApiResourceUtilizationWorkspaceInfos(this.resourceUtilizationService.getAllUserWorkspaceUtilization());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getTotalRepositorySize() {
        try {
            return this.resourceUtilizationService.getTotalRepositorySize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getTotalUserWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getTotalUserWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getTotalSharedWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getTotalSharedWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getCurrentUserSharedWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getCurrentUserSharedWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getCurrentUserWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getCurrentUserWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getCurrentUserRepositorySize() {
        try {
            return this.resourceUtilizationService.getCurrentUserRepositorySize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getCurrentUserTransientWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getCurrentUserTransientWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public long getTotalTransientWorkspaceSize() {
        try {
            return this.resourceUtilizationService.getTotalTransientWorkspaceSize();
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationContainerInfo> getRepositoryContainerChildrenAndSizes(String path) throws ResourceUtilizationPathNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return ResourceUtilizationHelper.toApiResourceUtilizationContainerInfos(this.resourceUtilizationService.getRepositoryContainerChildrenAndSizes(path));
        }
        catch (com.sas.lsaf.svcs.content.utilization.client.exception.ResourceUtilizationPathNotFoundException e) {
            throw new ResourceUtilizationPathNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationContainerInfo> getWorkspaceContainerChildrenAndSizes(String path) throws ResourceUtilizationPathNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return ResourceUtilizationHelper.toApiResourceUtilizationContainerInfos(this.resourceUtilizationService.getWorkspaceContainerChildrenAndSizes(path));
        }
        catch (com.sas.lsaf.svcs.content.utilization.client.exception.ResourceUtilizationPathNotFoundException e) {
            throw new ResourceUtilizationPathNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationContainerInfo> getAdminSharedWorkspaceContainerChildrenAndSizes(String path) throws ResourceUtilizationPathNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doCheckPathIsValid(path);
            return ResourceUtilizationHelper.toApiResourceUtilizationContainerInfos(this.resourceUtilizationService.getAdminSharedWorkspaceContainerChildrenAndSizes(path));
        }
        catch (com.sas.lsaf.svcs.content.utilization.client.exception.ResourceUtilizationPathNotFoundException e) {
            throw new ResourceUtilizationPathNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (ResourceUtilizationPathNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationContainerInfo> getUserSharedWorkspaceContainerChildrenAndSizes(String path) throws ResourceUtilizationPathNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return ResourceUtilizationHelper.toApiResourceUtilizationContainerInfos(this.resourceUtilizationService.getUserSharedWorkspaceContainerChildrenAndSizes(path));
        }
        catch (com.sas.lsaf.svcs.content.utilization.client.exception.ResourceUtilizationPathNotFoundException e) {
            throw new ResourceUtilizationPathNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<ResourceUtilizationTransientWorkspaceInfo> getCurrentUserTransientWorkspaceUtilization() {
        try {
            return ResourceUtilizationHelper.toApiResourceUtilizationTransientWorkspaceInfos(this.resourceUtilizationService.getCurrentUserTransientWorkspaceUtilization());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void doCheckPathIsValid(String path) throws ResourceUtilizationPathNotFoundException {
        List rcs = null;
        try {
            rcs = this.internalRepositoryService.internalGetContainerChildren(path);
        }
        catch (RepositoryItemNotFoundException repositoryItemNotFoundException) {
            // empty catch block
        }
        SharedWorkspace sw = this.internalSharedWorkspaceService.internalGetSharedWorkspaceByPathOrChildPath(path);
        if ((rcs == null || rcs.isEmpty()) && sw == null) {
            throw new ResourceUtilizationPathNotFoundException(path, "Path does not exist " + path);
        }
    }

    private class UserTransient {
        private Integer count;
        private long size;

        protected UserTransient(Integer count, long size) {
            this.count = count;
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }
}

