/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.signature.impl;

import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.content.repository.signature.CreateSignatureInfo;
import com.sas.lsaf.content.repository.signature.Signature;
import com.sas.lsaf.content.repository.signature.SignatureService;
import com.sas.lsaf.content.repository.signature.SigningException;
import com.sas.lsaf.content.repository.signature.impl.SignatureHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.security.authentication.AuthenticationException;
import com.sas.lsaf.security.authentication.impl.AuthenticationHelper;
import com.sas.lsaf.security.crypto.impl.EncryptionHelper;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContainer;
import com.sas.lsaf.svcs.content.repository.client.RepositoryFile;
import com.sas.lsaf.svcs.content.repository.client.RepositoryItem;
import com.sas.lsaf.svcs.content.repository.client.RepositoryService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class SignatureServiceImpl
implements SignatureService {
    private com.sas.lsaf.svcs.content.signature.client.SignatureService signatureService;
    private RepositoryService repositoryService;
    private EncryptionHelper encryptionHelper;

    @Required
    public void setSignatureService(com.sas.lsaf.svcs.content.signature.client.SignatureService signatureService) {
        this.signatureService = signatureService;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setEncryptionHelper(EncryptionHelper encryptionHelper) {
        this.encryptionHelper = encryptionHelper;
    }

    public Set<String> getSignatureReasons() {
        try {
            return Collections.unmodifiableSet(new HashSet(this.signatureService.getSignatureReasons()));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<String> getSignatureRoles() {
        try {
            return Collections.unmodifiableSet(new HashSet(this.signatureService.getSignatureRoles()));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Signature createSignature(String path, CreateSignatureInfo csi) throws AuthenticationException, SigningException {
        Assert.hasText((String)path, (String)"Path is required to create signature.");
        Assert.notNull((Object)csi, (String)"Create signature info is required to create signature.");
        Assert.hasText((String)csi.getUserId(), (String)"UserId on create signature info is required to create signature.");
        Assert.isTrue((csi.getPassword() != null && csi.getPassword().length > 0 ? 1 : 0) != 0, (String)"Password on create signature info is required to create signature.");
        try {
            csi.setPassword(this.encryptionHelper.decrypt(new String(csi.getPassword())).getBytes());
            return SignatureHelper.toApiSignature(path, this.signatureService.sign(path, SignatureHelper.toServerSignatureParameters(csi)));
        }
        catch (com.sas.lsaf.svcs.security.authentication.client.exception.AuthenticationException e) {
            throw AuthenticationHelper.toApiAuthenticationException(e);
        }
        catch (com.sas.lsaf.svcs.content.signature.client.exception.SigningException e) {
            throw new SigningException(path, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile.SigningStatus getSigningStatus(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            RepositoryItem ri = this.repositoryService.getByPath(path);
            if (ri instanceof RepositoryContainer) {
                throw new IllegalArgumentException("Path must be to a file.");
            }
            return RepositoryHelper.toApiSigningStatus(((RepositoryFile)ri).getSigningStatus());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean isVersionSigned(String path, String version) {
        Assert.hasText((String)path, (String)"Path is required to check for signatures");
        Assert.hasText((String)version, (String)"Version is required to check for signatures");
        try {
            return !this.getSignaturesByVersion(path, version).isEmpty();
        }
        catch (RepositoryItemNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Signature> getSignatures(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required to get signatures");
        try {
            RepositoryItem ri = this.repositoryService.getByPath(path);
            if (ri instanceof RepositoryContainer) {
                throw new IllegalArgumentException("Path must be to a file.");
            }
            return SignatureHelper.toApiSignatures(path, this.signatureService.getAllSignatures(ri.getId()));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Signature> getSignaturesForLatestVersion(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required to get signatures");
        try {
            RepositoryItem ri = this.repositoryService.getByPath(path);
            if (ri instanceof RepositoryContainer) {
                throw new IllegalArgumentException("Path must be to a file.");
            }
            return SignatureHelper.toApiSignatures(path, this.signatureService.getSignatures((RepositoryFile)ri));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Signature> getSignaturesByVersion(String path, String version) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required to get signatures");
        Assert.hasText((String)version, (String)"Version is required to get signatures");
        try {
            RepositoryFile rf = this.repositoryService.getVersion(path, version);
            return SignatureHelper.toApiSignatures(path, this.signatureService.getSignatures(rf));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

