/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.recyclebin.impl;

import com.sas.lsaf.content.repository.recyclebin.RecycleBinItem;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinItemDeleteException;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinItemNotFoundException;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinItemSearchException;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinQuery;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinSearchResults;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinService;
import com.sas.lsaf.content.repository.recyclebin.impl.RecycleBinHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.ActionStatusDetail;
import com.sas.lsaf.core.action.impl.InternalActionStatusService;
import com.sas.lsaf.svcs.content.trashcan.client.BatchTrashcanService;
import com.sas.lsaf.svcs.content.trashcan.client.TrashcanItem;
import com.sas.lsaf.svcs.content.trashcan.client.TrashcanService;
import com.sas.lsaf.svcs.content.trashcan.client.exception.TrashcanItemDeleteException;
import com.sas.lsaf.svcs.content.trashcan.client.exception.TrashcanItemNotFoundException;
import com.sas.lsaf.svcs.content.trashcan.client.exception.TrashcanItemSearchException;
import com.sas.lsaf.svcs.content.trashcan.client.query.TrashcanQuery;
import com.sas.lsaf.svcs.content.trashcan.client.query.TrashcanSearchService;
import com.sas.lsaf.svcs.core.action.client.ActionStatusToken;
import com.sas.lsaf.svcs.core.search.client.SearchResultsInfo;
import com.sas.lsaf.svcs.core.utils.client.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class RecycleBinServiceImpl
implements RecycleBinService {
    private TrashcanService trashcanService;
    private TrashcanSearchService trashcanSearchService;
    private BatchTrashcanService batchTrashcanService;
    private InternalActionStatusService internalActionStatusService;
    private static final Log LOG = LogFactory.getLog((String)RecycleBinServiceImpl.class.getName());

    @Required
    public void setTrashcanService(TrashcanService trashcanService) {
        this.trashcanService = trashcanService;
    }

    @Required
    public void setTrashcanSearchService(TrashcanSearchService trashcanSearchService) {
        this.trashcanSearchService = trashcanSearchService;
    }

    @Required
    public void setBatchTrashcanService(BatchTrashcanService batchTrashcanService) {
        this.batchTrashcanService = batchTrashcanService;
    }

    @Required
    public void setInternalActionStatusService(InternalActionStatusService internalActionStatusService) {
        this.internalActionStatusService = internalActionStatusService;
    }

    public List<String> deleteAvailableItems() {
        try {
            return this.deleteItemsByQuery(new RecycleBinQuery("/", null, null, null, null));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<String> deleteItemsByQuery(RecycleBinQuery query) throws RecycleBinItemSearchException {
        Assert.notNull((Object)query, (String)"Recycle bin query is required.");
        Assert.isTrue((!StringUtils.isEmpty((Object)query.getLocation()) || !StringUtils.isEmpty((Object)query.getName()) || !StringUtils.isEmpty((Object)query.getDeletedBy()) || query.getFromDate() != null || query.getToDate() != null ? 1 : 0) != 0, (String)"At least one recycle bin query variable must be specified.");
        ArrayList<String> deletedItems = new ArrayList<String>();
        SearchResultsInfo trashcanItemsInfo = null;
        try {
            TrashcanQuery trashcanQuery = RecycleBinHelper.toServerTrashcanQuery(query, this.trashcanSearchService.getQuery());
            trashcanItemsInfo = this.trashcanSearchService.search(trashcanQuery);
            List<Object> deletedPaths = new ArrayList();
            while (trashcanItemsInfo.getRowCount() > 0) {
                LOG.info((Object)("Attempting to remove " + trashcanItemsInfo.getRowCount() + " from the recycle bin."));
                ActionStatusToken asr = this.trashcanSearchService.batchDeleteAll(trashcanItemsInfo.getToken());
                ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(asr.getId());
                deletedPaths = this.getSuccesfullyDeletedPaths(as);
                this.trashcanSearchService.clearResults(trashcanItemsInfo.getToken());
                if (deletedPaths.size() == 0) {
                    break;
                }
                LOG.info((Object)("Removed " + deletedPaths.size() + " from the recycle bin."));
                deletedItems.addAll(deletedPaths);
                trashcanQuery = RecycleBinHelper.toServerTrashcanQuery(query, this.trashcanSearchService.getQuery());
                trashcanItemsInfo = this.trashcanSearchService.search(trashcanQuery);
            }
        }
        catch (TrashcanItemSearchException e) {
            throw new RecycleBinItemSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        finally {
            if (trashcanItemsInfo != null) {
                this.trashcanSearchService.clearResults(trashcanItemsInfo.getToken());
            }
        }
        return deletedItems;
    }

    public List<String> deleteItem(RecycleBinItem item) throws RecycleBinItemNotFoundException, RecycleBinItemDeleteException {
        Assert.notNull((Object)item, (String)"Recycle bin item is required to delete item from the recycle bin, null value specified");
        return this.deleteItemById(item.getId());
    }

    public List<String> deleteItemById(String recycleBinItemId) throws RecycleBinItemNotFoundException, RecycleBinItemDeleteException {
        Assert.hasText((String)recycleBinItemId, (String)"Recycle bin item identifier is required to delete an item from the recycle bin, null value specified");
        ArrayList<String> rval = new ArrayList<String>();
        try {
            TrashcanItem ti = this.trashcanService.getTrashcanItemById(recycleBinItemId);
            List deletedItems = this.trashcanService.deleteItem(ti.getPath());
            for (TrashcanItem deletedItem : deletedItems) {
                rval.add(deletedItem.getDeletedPath());
            }
        }
        catch (TrashcanItemNotFoundException e) {
            throw new RecycleBinItemNotFoundException(e.getLocalizedMessage());
        }
        catch (TrashcanItemDeleteException e) {
            throw new RecycleBinItemDeleteException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return rval;
    }

    public List<String> deleteItems(Set<RecycleBinItem> items) {
        Assert.notEmpty(items, (String)"Recycle bin items are required.");
        for (RecycleBinItem item : items) {
            Assert.notNull((Object)item, (String)"Recycle bin item set contains a null item. Non-null items are required.");
            Assert.hasText((String)item.getId(), (String)"Recycle bin item identifier is required to delete an item from the recycle bin, null value specified");
        }
        HashSet<String> recyclebFinItemIds = new HashSet<String>();
        for (RecycleBinItem trashcanItem : items) {
            recyclebFinItemIds.add(trashcanItem.getId());
        }
        return this.deleteItemsByIds(recyclebFinItemIds);
    }

    public List<String> deleteItemsByIds(Set<String> recycleBinItemIds) {
        Assert.notEmpty(recycleBinItemIds, (String)"Recycle bin item ids are required.");
        try {
            List trashcanItems = this.trashcanService.getTrashcanItemsByIds(new ArrayList<String>(recycleBinItemIds));
            HashSet<String> trashcanPaths = new HashSet<String>();
            for (TrashcanItem trashcanItem : trashcanItems) {
                trashcanPaths.add(trashcanItem.getPath());
            }
            ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(this.batchTrashcanService.batchDelete(trashcanPaths).getId());
            return this.getSuccesfullyDeletedPaths(as);
        }
        catch (TrashcanItemNotFoundException e) {
            throw new IllegalArgumentException("One of the recycle bin item ids provided was not valid or could not be found.");
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RecycleBinSearchResults search(RecycleBinQuery query) throws RecycleBinItemSearchException {
        SearchResultsInfo trashcanItemsInfo = null;
        try {
            TrashcanQuery trashcanQuery = RecycleBinHelper.toServerTrashcanQuery(query, this.trashcanSearchService.getQuery());
            trashcanItemsInfo = this.trashcanSearchService.search(trashcanQuery);
            if (trashcanItemsInfo.getRowCount() > 0) {
                List serverTrash = this.trashcanSearchService.getResults(trashcanItemsInfo.getToken(), 1, trashcanItemsInfo.getRowCount());
                RecycleBinSearchResults recycleBinSearchResults = new RecycleBinSearchResults(RecycleBinHelper.toApiRecycleBinItems(serverTrash), trashcanItemsInfo.isLimitReached());
                return recycleBinSearchResults;
            }
            RecycleBinSearchResults recycleBinSearchResults = new RecycleBinSearchResults(new HashSet(), false);
            return recycleBinSearchResults;
        }
        catch (TrashcanItemSearchException e) {
            throw new RecycleBinItemSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        finally {
            if (trashcanItemsInfo != null) {
                this.trashcanSearchService.clearResults(trashcanItemsInfo.getToken());
            }
        }
    }

    private List<String> getSuccesfullyDeletedPaths(ActionStatus actionStatus) {
        ArrayList<String> paths = new ArrayList<String>();
        if (actionStatus != null) {
            List details = actionStatus.getDetails();
            for (ActionStatusDetail detail : details) {
                if (detail.getCompletionStatus() != ActionStatus.CompletionStatus.INFO) continue;
                paths.add(detail.getItemLocation() + "/" + detail.getItemName());
            }
        }
        return paths;
    }
}

