/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.recyclebin.impl;

import com.sas.lsaf.content.repository.recyclebin.RecycleBinItem;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinQuery;
import com.sas.lsaf.svcs.content.trashcan.client.query.TrashcanQuery;
import com.sas.lsaf.svcs.content.trashcan.client.query.TrashcanSearchResultItem;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class RecycleBinHelper {
    public static Set<RecycleBinItem> toApiRecycleBinItems(List<TrashcanSearchResultItem> serverTrashcanItems) {
        LinkedHashSet<RecycleBinItem> rval = new LinkedHashSet<RecycleBinItem>();
        for (TrashcanSearchResultItem serverTrashcanItem : serverTrashcanItems) {
            rval.add(RecycleBinHelper.toApiRecycleBinItem(serverTrashcanItem));
        }
        return rval;
    }

    public static RecycleBinItem toApiRecycleBinItem(TrashcanSearchResultItem ti) {
        RecycleBinItem rval = null;
        if (ti != null) {
            rval = new RecycleBinItem(ti.getId(), ti.getTypeId(), ti.getDeletedPath(), ti.getDeletedBy(), ti.getDeletedDate(), ti.getSize(), ti.getLastModifiedBy(), ti.getLastModified());
        }
        return rval;
    }

    public static TrashcanQuery toServerTrashcanQuery(RecycleBinQuery rbq, TrashcanQuery serverQuery) {
        if (rbq != null) {
            serverQuery.setName(rbq.getName());
            serverQuery.setFromDeletedDate(rbq.getFromDate());
            serverQuery.setToDeletedDate(rbq.getToDate());
            if (rbq.getLocation() == null || rbq.getLocation().trim().isEmpty()) {
                serverQuery.setLocation(null);
            } else {
                serverQuery.setLocation(rbq.getLocation());
            }
            serverQuery.setRecurse(rbq.isRecurse());
            serverQuery.setDeletedBy(rbq.getDeletedBy());
        }
        return serverQuery;
    }
}

