/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.impl;

import com.sas.lsaf.content.repository.CheckedOutFilesQuery;
import com.sas.lsaf.content.repository.CheckedOutFilesSearchException;
import com.sas.lsaf.content.repository.CopyToWorkspaceException;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryFileVersionInfo;
import com.sas.lsaf.content.repository.RepositoryFolder;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.RepositoryItemCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemCopyException;
import com.sas.lsaf.content.repository.RepositoryItemDeleteException;
import com.sas.lsaf.content.repository.RepositoryItemExistsException;
import com.sas.lsaf.content.repository.RepositoryItemLockException;
import com.sas.lsaf.content.repository.RepositoryItemMoveException;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryItemUndoCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemUnlockException;
import com.sas.lsaf.content.repository.RepositoryItemUpdateException;
import com.sas.lsaf.content.repository.RepositoryItemVersioningException;
import com.sas.lsaf.content.repository.RepositorySearchException;
import com.sas.lsaf.content.repository.RepositorySearchResults;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.RepositorySharedFolder;
import com.sas.lsaf.content.repository.RepositoryStateChangeResult;
import com.sas.lsaf.content.repository.SearchQuery;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.content.repository.impl.InternalRepositoryService;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.IllegalPathException;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.ActionStatusDetail;
import com.sas.lsaf.core.action.impl.InternalActionStatusService;
import com.sas.lsaf.core.type.InvalidTypeException;
import com.sas.lsaf.core.utils.impl.CollectionUtils;
import com.sas.lsaf.security.membership.MembershipContextNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.BatchRepositoryService;
import com.sas.lsaf.svcs.content.repository.client.RepositoryCopyResults;
import com.sas.lsaf.svcs.content.repository.client.RepositoryMoveResults;
import com.sas.lsaf.svcs.content.repository.client.exception.BatchCheckinException;
import com.sas.lsaf.svcs.content.repository.client.exception.CheckoutException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryIdNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemIllegalStateException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemVersionException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryLimitReachedException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryPathNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.exception.UndoCheckoutException;
import com.sas.lsaf.svcs.content.synchronization.client.BatchSynchronizationService;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationService;
import com.sas.lsaf.svcs.content.synchronization.client.VersionSpecification;
import com.sas.lsaf.svcs.content.synchronization.client.exception.SynchronizationEntrySearchException;
import com.sas.lsaf.svcs.content.synchronization.client.query.SynchronizationQuery;
import com.sas.lsaf.svcs.content.synchronization.client.query.SynchronizationSearchService;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceFile;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceItem;
import com.sas.lsaf.svcs.content.workspace.client.WorkspaceService;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceItemNotFoundException;
import com.sas.lsaf.svcs.core.action.client.ActionStatusToken;
import com.sas.lsaf.svcs.core.common.client.exception.ConfigurationException;
import com.sas.lsaf.svcs.core.type.client.Type;
import com.sas.lsaf.svcs.core.type.client.TypeService;
import com.sas.lsaf.svcs.core.utils.client.PathUtils;
import com.sas.lsaf.svcs.core.validation.client.ValidationException;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import com.sas.lsaf.svcs.security.authentication.server.ServerSecurityContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class RepositoryServiceImpl
implements RepositoryService,
InternalRepositoryService {
    private WorkspaceService workspaceService;
    private com.sas.lsaf.svcs.content.repository.client.RepositoryService repositoryService;
    private com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService internalRepositoryService;
    private BatchRepositoryService batchRepositoryService;
    private SynchronizationService synchronizationService;
    private SynchronizationSearchService synchronizationSearchService;
    private BatchSynchronizationService batchSynchronizationService;
    private TypeService typeService;
    private InternalActionStatusService internalActionStatusService;
    private int searchPageSizeLimit = 5000;

    private RepositoryItemNotFoundException doHandleRepositoryItemNotFoundException(com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
        if (e instanceof RepositoryPathNotFoundException) {
            return new RepositoryItemNotFoundException(((RepositoryPathNotFoundException)e).getPath(), e.getMessage());
        }
        if (e instanceof RepositoryIdNotFoundException) {
            return new RepositoryItemNotFoundException(((RepositoryIdNotFoundException)e).getId(), e.getMessage());
        }
        return new RepositoryItemNotFoundException(null, e.getMessage());
    }

    private void doCreateParentFolders(String path, boolean createParentFolders) throws com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException, com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException {
        if (createParentFolders && !this.repositoryService.existsByPath(PathUtils.getParentPath((String)path))) {
            StringTokenizer uPath = new StringTokenizer(path, "/");
            StringBuffer dPath = new StringBuffer("");
            while (uPath.hasMoreTokens()) {
                String pathOnly = uPath.nextToken("/");
                dPath.append("/" + pathOnly);
                if (dPath.toString().equalsIgnoreCase(path)) break;
                if (this.repositoryService.existsByPath(dPath.toString())) continue;
                this.repositoryService.createFolder(dPath.toString());
            }
        }
    }

    private void doAssertPath(String path, boolean assertIsFile) throws RepositoryPathNotFoundException {
        com.sas.lsaf.svcs.content.repository.client.RepositoryItem lsafRepositoryItem = this.repositoryService.getByPath(path);
        if (assertIsFile && !(lsafRepositoryItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryFile)) {
            throw new IllegalPathException("Path must be to a file not a container.");
        }
    }

    private void doHandleCopyToWorkspaceActionStatusError(ActionStatus actionStatus, String path) {
        if (actionStatus != null && actionStatus.getCompletionStatus() == ActionStatus.CompletionStatus.ERROR) {
            ActionStatusDetail asd = (ActionStatusDetail)actionStatus.getDetails().get(0);
            throw new CopyToWorkspaceException(path, asd.getMessage());
        }
    }

    @Required
    public void setRepositoryService(com.sas.lsaf.svcs.content.repository.client.RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setInternalRepositoryService(com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    @Required
    public void setBatchRepositoryService(BatchRepositoryService batchRepositoryService) {
        this.batchRepositoryService = batchRepositoryService;
    }

    @Required
    public void setSynchronizationService(SynchronizationService synchronizationService) {
        this.synchronizationService = synchronizationService;
    }

    @Required
    public void setBatchSynchronizationService(BatchSynchronizationService batchSynchronizationService) {
        this.batchSynchronizationService = batchSynchronizationService;
    }

    @Required
    public void setSynchronizationSearchService(SynchronizationSearchService service) {
        this.synchronizationSearchService = service;
    }

    @Required
    public void setWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    public void setSearchPageSizeLimit(int searchPageSizeLimit) {
        this.searchPageSizeLimit = searchPageSizeLimit;
    }

    @Required
    public void setTypeService(TypeService typeService) {
        this.typeService = typeService;
    }

    @Required
    public void setInternalActionStatusService(InternalActionStatusService service) {
        this.internalActionStatusService = service;
    }

    public RepositoryContext createContext(String path, String typeId) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)typeId, (String)"Type identifier is required.");
        try {
            return RepositoryHelper.toApiRepositoryContext(this.repositoryService.createContext(path, typeId));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (ConfigurationException e) {
            throw new InvalidTypeException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFolder createFolder(String path, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doCreateParentFolders(path, createParentFolders);
            return RepositoryHelper.toApiRepositoryFolder(this.repositoryService.createFolder(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositorySharedFolder createSharedFolder(String path) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositorySharedFolder(this.repositoryService.createSharedFolder(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (RepositoryLimitReachedException e) {
            throw new RepositoryItemExistsException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile createFile(String path, String localFilePath, String comment, boolean createParentFolders) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public RepositoryFile createVersionedFile(String path, String localFilePath, String comment, String startingVersion, boolean createParentFolders) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public RepositoryItem updateItem(RepositoryItem item) throws RepositoryItemNotFoundException, RepositoryItemUpdateException {
        Assert.notNull((Object)item, (String)"Repository item is required.");
        try {
            com.sas.lsaf.svcs.content.repository.client.RepositoryItem serverItem = RepositoryHelper.toServerRepositoryItem(item);
            return RepositoryHelper.toApiRepositoryItem(this.repositoryService.update(serverItem));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(item.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemUpdateException e) {
            throw new RepositoryItemUpdateException(item.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryItem rename(String path, String name) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)name, (String)"Name is required.");
        try {
            return RepositoryHelper.toApiRepositoryItem(this.repositoryService.rename(path, name));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(path, e.getMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryItem move(String sourcePath, String destinationPath) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemMoveException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        if (sourcePath.equals("/Users/" + ServerSecurityContext.getCurrentUserId())) {
            throw new RepositoryItemMoveException(sourcePath, "Only files and folders can be moved.");
        }
        try {
            RepositoryMoveResults results = this.repositoryService.move(sourcePath, destinationPath, false);
            return RepositoryHelper.toApiRepositoryItem(results.getRepositoryItem());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(e.getPath(), e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemMoveException e) {
            throw new RepositoryItemMoveException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryItem copy(String sourcePath, String destinationPath) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemCopyException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        try {
            RepositoryCopyResults results = this.repositoryService.copy(sourcePath, destinationPath);
            return RepositoryHelper.toApiRepositoryItem(results.getRepositoryItem());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemExistsException e) {
            throw new RepositoryItemExistsException(e.getPath(), e.getMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemCopyException e) {
            throw new RepositoryItemCopyException(e.getPath(), e.getMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<String> delete(String path) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return this.repositoryService.deleteByPath(path);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemDeleteException e) {
            throw new RepositoryItemDeleteException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<VersionDeleteInfo> deleteVersions(String path, Set<String> versions) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.notEmpty(versions, (String)"Versions are required.");
        try {
            return RepositoryHelper.toApiVersionDeleteInfos(this.repositoryService.deleteVersions(path, versions));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemDeleteException e) {
            throw new RepositoryItemDeleteException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<String> permanentlyDelete(String path) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            if ("/".equals(path)) {
                throw new RepositoryItemDeleteException(path, "Cannot permanently delete root directory.");
            }
            com.sas.lsaf.svcs.content.repository.client.RepositoryItem lsafRepositoryItem = this.repositoryService.getByPath(path);
            if (lsafRepositoryItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryContext) {
                throw new RepositoryItemDeleteException(path, "Context types cannot be permanently deleted via the Java API");
            }
            List serverItems = this.repositoryService.deletePermanentlyByPath(path);
            ArrayList<String> paths = new ArrayList<String>(serverItems.size());
            for (com.sas.lsaf.svcs.content.repository.client.RepositoryItem serverItem : serverItems) {
                paths.add(serverItem.getPath());
            }
            return paths;
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemDeleteException e) {
            throw new RepositoryItemDeleteException(e.getPath(), e.getLocalizedMessage());
        }
        catch (RepositoryItemDeleteException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile enableVersioning(String path, String startingVersion, String comment) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.enableVersioning(path, startingVersion, comment));
        }
        catch (RepositoryItemIllegalStateException e) {
            throw new RepositoryItemVersioningException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (RepositoryItemVersionException e) {
            throw new RepositoryItemVersioningException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile disableVersioning(String path, String comment) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.disableVersioning(path, comment));
        }
        catch (RepositoryItemIllegalStateException e) {
            throw new RepositoryItemVersioningException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile lockFile(String path) throws RepositoryItemNotFoundException, RepositoryItemLockException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.lock(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemLockException e) {
            throw new RepositoryItemLockException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile unlockFile(String path) throws RepositoryItemNotFoundException, RepositoryItemUnlockException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.unlock(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemUnlockException e) {
            throw new RepositoryItemUnlockException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public boolean exists(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return this.repositoryService.existsByPath(path);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryContext getTopLevelContextByName(String name) throws RepositoryItemNotFoundException {
        Assert.hasText((String)name, (String)"Name is required.");
        try {
            return RepositoryHelper.toApiRepositoryContext(this.repositoryService.getTopLevelContextByName(name));
        }
        catch (RepositoryPathNotFoundException e) {
            throw new RepositoryItemNotFoundException(e.getPath(), e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<RepositoryContext> getTopLevelContexts() {
        try {
            return RepositoryHelper.toApiRepositoryContexts(this.repositoryService.getTopLevelContexts());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryItem getItem(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.checkIsRoot(path);
        try {
            return RepositoryHelper.toApiRepositoryItem(this.repositoryService.getByPath(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryContext getContext(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.checkIsRoot(path);
        try {
            return RepositoryHelper.toApiRepositoryContext(this.repositoryService.getContextByPath(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryContext getContextById(String id) throws RepositoryItemNotFoundException {
        Assert.hasText((String)id, (String)"Context identifier is required.");
        try {
            return RepositoryHelper.toApiRepositoryContext(this.repositoryService.getContextById(id));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(id, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryContext getParentMembershipContext(String path) throws RepositoryItemNotFoundException, MembershipContextNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.repositoryService.getByPath(path);
            RepositoryContext parentContext = RepositoryHelper.toApiRepositoryContext(this.internalRepositoryService.internalGetParentMembershipContextByPath(path, true));
            if (parentContext == null) {
                throw new MembershipContextNotFoundException("The path does not have a parent membership context.");
            }
            return parentContext;
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFolder getFolder(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFolder(this.repositoryService.getFolderByPath(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile getFile(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.getFileByPath(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<RepositoryItem> getChildren(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            return RepositoryHelper.toApiRepositoryItems(this.repositoryService.getChildren(path));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<RepositoryItem> getChildrenByType(String path, String typeId) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)typeId, (String)"Type is required.");
        try {
            return RepositoryHelper.toApiRepositoryItems(this.repositoryService.getChildrenByType(path, typeId, false));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile getFileVersion(String path, String version) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)version, (String)"Version is required.");
        try {
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.getVersion(path, version));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<RepositoryFile> getFileVersions(String path) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            if (!this.repositoryService.isVersioned(path)) {
                throw new RepositoryItemVersioningException(path, "Version information is not available for non-versioned files.");
            }
            return RepositoryHelper.toApiRepositoryFiles(this.repositoryService.getVersions(path));
        }
        catch (RepositoryItemVersioningException e) {
            throw e;
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<RepositoryFileVersionInfo> getFileVersionInfos(String path) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            if (!this.repositoryService.isVersioned(path)) {
                throw new RepositoryItemVersioningException(path, "Version information is not available for non-versioned files.");
            }
            return RepositoryHelper.toApiRepositoryFileVersionInfos(this.repositoryService.getVersionInfos(path));
        }
        catch (RepositoryItemVersioningException e) {
            throw e;
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void downloadFile(String path, String version, String outputFilePath) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public RepositoryFile updateFileContents(String path, RepositoryCheckinSpecification spec, String localFileLocation) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public List<RepositoryStateChangeResult> setState(String path, RepositoryItem.State state, String comment, boolean recurse) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.notNull((Object)state, (String)"State is required.");
        try {
            return RepositoryHelper.toApiRepositoryStateChangeResults(this.repositoryService.setState(path, RepositoryHelper.toServerState(state), comment, recurse));
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile checkout(String path) throws RepositoryItemNotFoundException, RepositoryItemCheckoutException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doAssertPath(path, true);
            this.synchronizationService.checkout(this.synchronizationService.getCurrentUserWorkspace().getId(), path);
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.getFileByPath(path));
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new RepositoryItemCheckoutException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (CheckoutException e) {
            throw new RepositoryItemCheckoutException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile undoCheckout(String path) throws RepositoryItemNotFoundException, RepositoryItemUndoCheckoutException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doAssertPath(path, true);
            this.synchronizationService.undoCheckout(this.synchronizationService.getCurrentUserWorkspace().getId(), path);
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.getFileByPath(path));
        }
        catch (UndoCheckoutException e) {
            throw new RepositoryItemUndoCheckoutException(path, e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw new RepositoryItemNotFoundException(path, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositoryFile checkin(String path, RepositoryCheckinSpecification spec) throws RepositoryItemCheckinException {
        Assert.hasText((String)path, (String)"Path is required.");
        RepositoryCheckinSpecification realSpec = spec;
        if (realSpec == null) {
            realSpec = new RepositoryCheckinSpecification();
        }
        try {
            WorkspaceItem workspaceFile = this.workspaceService.getByPath(this.synchronizationService.getCurrentUserWorkspace().getId(), path);
            if (!(workspaceFile instanceof WorkspaceFile)) {
                throw new IllegalPathException("Path must be to a file not a container.");
            }
            this.synchronizationService.checkin(this.synchronizationService.getCurrentUserWorkspace().getId(), RepositoryHelper.toServerSynchronizationCheckinSpecification(realSpec), path);
            return RepositoryHelper.toApiRepositoryFile(this.repositoryService.getFileByPath(path));
        }
        catch (BatchCheckinException e) {
            throw RepositoryHelper.handleBatchCheckinException(path, e);
        }
        catch (WorkspaceItemNotFoundException e) {
            throw new RepositoryItemCheckinException(e.getPath(), "Item does not exist in the workspace.");
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public SearchResultsInfo searchCheckedOutFiles(CheckedOutFilesQuery query) {
        try {
            return CoreHelper.toApiSearchResultsInfo(this.synchronizationSearchService.search(this.toServerSynchronizationQuery(query)));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<SynchronizationInfo> getCheckedOutFilesSearchResults(int fromRow, int toRow) {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    public SynchronizationInfo getSynchronizationInfo(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            ValidationUtils.validatePath((String)path);
            String workspaceId = this.synchronizationService.getCurrentUserWorkspace().getId();
            this.assertPathIsToFile(path, workspaceId);
            return RepositoryHelper.toApiSynchronizationInfo(this.synchronizationService.getSynchronizationEntry(workspaceId, path));
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<SynchronizationInfo> getSynchronizationInfos(Set<String> paths, boolean recurse) {
        Assert.notEmpty(paths, (String)"Paths are required.");
        Assert.isTrue((!paths.contains("/") ? 1 : 0) != 0, (String)"Synchronization info is not available at root.");
        ArrayList<SynchronizationInfo> syncInfos = new ArrayList<SynchronizationInfo>();
        try {
            this.assertValidPaths(paths);
            HashSet<String> pathsForSyncInfo = new HashSet<String>();
            String workspaceId = this.synchronizationService.getCurrentUserWorkspace().getId();
            for (String path : paths) {
                try {
                    List workspaceFilePaths = this.workspaceService.getFilePaths(workspaceId, path, recurse);
                    pathsForSyncInfo.addAll(workspaceFilePaths);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (pathsForSyncInfo.contains(path)) continue;
                pathsForSyncInfo.add(path);
            }
            if (!pathsForSyncInfo.isEmpty()) {
                return RepositoryHelper.toApiSynchronizationInfos(this.synchronizationService.getSynchronizationEntries(workspaceId, pathsForSyncInfo, recurse));
            }
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return syncInfos;
    }

    public void clearCheckedOutFilesSearchResults() {
        throw new UnsupportedOperationException("This implementation does not provide this functionality.");
    }

    public int getPageSizeLimit() {
        return this.searchPageSizeLimit;
    }

    public String batchPrepareUpload(Set<String> paths) {
        Assert.notEmpty(paths, (String)"Paths are required.");
        return this.batchRepositoryService.batchPrepareUpload(paths).getId();
    }

    public List<SynchronizationInfo> internalGetCheckedOutFilesSearchResults(String token, int fromRow, int toRow) throws CheckedOutFilesSearchException {
        Assert.hasText((String)token, (String)"Checked out files search token is required.");
        if (toRow - fromRow > this.searchPageSizeLimit) {
            throw new CheckedOutFilesSearchException("The number of entries requested exceeds the maximum limit, " + this.searchPageSizeLimit + ".  Please modify the number of rows requested.");
        }
        ArrayList<SynchronizationInfo> infos = new ArrayList();
        try {
            List items = this.synchronizationSearchService.getResults(token, fromRow, toRow);
            infos = RepositoryHelper.toApiSynchronizationInfos(items);
        }
        catch (SynchronizationEntrySearchException e) {
            throw new CheckedOutFilesSearchException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return infos;
    }

    public void internalClearCheckedOutFilesSearchResults(String token) {
        Assert.hasText((String)token, (String)"Checked out files  search token is required.");
        try {
            this.synchronizationSearchService.clearResults(token);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String batchPrepareUploadAndExpand(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.batchRepositoryService.batchPrepareUploadAndExpand(path).getId();
    }

    public void copyLatestFileVersionToWorkspace(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doAssertPath(path, false);
            HashSet<String> vs = new HashSet<String>();
            vs.add(path);
            ActionStatusToken token = this.batchSynchronizationService.batchGetLatestVersions(this.synchronizationService.getCurrentUserWorkspace().getId(), vs, false);
            ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(token.getId());
            this.doHandleCopyToWorkspaceActionStatusError(as, path);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (CopyToWorkspaceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void copySpecificFileVersionToWorkspace(String path, String version) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        try {
            this.doAssertPath(path, true);
            HashSet<VersionSpecification> vs = new HashSet<VersionSpecification>();
            vs.add(new VersionSpecification(path, version));
            ActionStatusToken token = this.batchSynchronizationService.batchGetSpecificVersions(this.synchronizationService.getCurrentUserWorkspace().getId(), vs);
            ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(token.getId());
            this.doHandleCopyToWorkspaceActionStatusError(as, path);
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            throw this.doHandleRepositoryItemNotFoundException(e);
        }
        catch (CopyToWorkspaceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public RepositorySearchResults search(SearchQuery query) throws RepositorySearchException {
        Assert.notNull((Object)query, (String)"Search query is required.");
        Assert.isTrue((query.getLocation() != null || query.getName() != null || query.getTypeId() != null || query.getLastModifiedBy() != null || query.getToCreated() != null || query.getFromCreated() != null || query.getCreatedBy() != null || query.getToLastModifiedDate() != null || query.getFromLastModifiedDate() != null || query.getContent() != null || query.getOwner() != null || query.getCopyToWorkspaceStatus() != null ? 1 : 0) != 0, (String)"A search query variable must be specified. If doing a file content search, a valid file object type must be specified.");
        try {
            if (query.getLocation() != null && !query.getLocation().isEmpty()) {
                if (query.getLocation().contains("*")) {
                    throw new ValidationException("Location cannot contain wildcard characters.");
                }
                if (!this.repositoryService.existsByPath(query.getLocation())) {
                    throw new RepositorySearchException("Location was not found or was not a valid search location.");
                }
            }
            com.sas.lsaf.svcs.content.repository.client.RepositorySearchResults lsafSearchResults = this.repositoryService.search(RepositoryHelper.toSearchRequest(query, this.typeService), false);
            return new RepositorySearchResults(CollectionUtils.asSet(RepositoryHelper.toApiRepositoryItems(lsafSearchResults.getResults())), lsafSearchResults.isLimitReached());
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositorySearchException e) {
            throw new RepositorySearchException(e.getLocalizedMessage());
        }
        catch (RepositorySearchException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private SynchronizationQuery toServerSynchronizationQuery(CheckedOutFilesQuery query) {
        SynchronizationQuery syncQuery = this.synchronizationSearchService.getQuery();
        syncQuery.setQueryMode(SynchronizationQuery.QueryMode.MANAGE);
        String currentUserId = ServerSecurityContext.getCurrentUserId();
        if (query != null) {
            if (query.getUserId() != null && !query.getUserId().isEmpty()) {
                syncQuery.setUserId(query.getUserId());
                if (query.getUserId().equals(currentUserId)) {
                    syncQuery.setQueryMode(SynchronizationQuery.QueryMode.EDIT);
                }
            } else {
                syncQuery.setUserId(currentUserId);
                syncQuery.setQueryMode(SynchronizationQuery.QueryMode.EDIT);
            }
            if (query.getLocation() != null) {
                syncQuery.setLocation(query.getLocation());
            }
            if (query.getName() != null) {
                syncQuery.setName(query.getName());
            }
        } else {
            syncQuery.setUserId(currentUserId);
            syncQuery.setQueryMode(SynchronizationQuery.QueryMode.EDIT);
        }
        return syncQuery;
    }

    private void checkIsRoot(String path) throws RepositoryItemNotFoundException {
        if ("/".equals(path)) {
            throw new RepositoryItemNotFoundException(path, "Repository item is not available at root.");
        }
    }

    private void assertValidPaths(Set<String> paths) {
        for (String path : paths) {
            ValidationUtils.validatePath((String)path);
        }
        String contextPath = this.getTopLevelContext(paths);
        if (contextPath != null) {
            throw new IllegalArgumentException("Synchronization info is not available for path " + contextPath + ". Synchronization info cannot be retrieved for top level contexts.");
        }
    }

    private String getTopLevelContext(Set<String> paths) {
        for (String path : paths) {
            try {
                com.sas.lsaf.svcs.content.repository.client.RepositoryContext ctx;
                com.sas.lsaf.svcs.content.repository.client.RepositoryItem repoItem = this.internalRepositoryService.internalGetByPath(path);
                if (!(repoItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryContext) || !this.typeService.isTypeCapable((ctx = (com.sas.lsaf.svcs.content.repository.client.RepositoryContext)repoItem).getTypeId(), Type.Capability.TOP)) continue;
                return ctx.getPath();
            }
            catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException repositoryItemNotFoundException) {
            }
        }
        return null;
    }

    private void assertPathIsToFile(String path, String workspaceId) {
        try {
            com.sas.lsaf.svcs.content.repository.client.RepositoryItem lsafRepositoryItem = this.repositoryService.getByPath(path);
            if (!(lsafRepositoryItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryFile)) {
                throw new IllegalArgumentException("Path must be to a file not a container.");
            }
        }
        catch (com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException e) {
            try {
                WorkspaceItem lsafWorkspaceItem = this.workspaceService.getByPath(workspaceId, path);
                if (!(lsafWorkspaceItem instanceof WorkspaceFile)) {
                    throw new IllegalArgumentException("Path must be to a file not a container.");
                }
            }
            catch (WorkspaceItemNotFoundException workspaceItemNotFoundException) {
                // empty catch block
            }
        }
    }
}

