/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.impl;

import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryExecutableFile;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryFileInfo;
import com.sas.lsaf.content.repository.RepositoryFileVersionInfo;
import com.sas.lsaf.content.repository.RepositoryFolder;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.RepositorySharedFolder;
import com.sas.lsaf.content.repository.RepositoryStateChangeResult;
import com.sas.lsaf.content.repository.RunHealthStatus;
import com.sas.lsaf.content.repository.SearchQuery;
import com.sas.lsaf.content.repository.SynchronizationFileInfo;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.content.repository.VersionLimits;
import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.content.repository.WorkspaceFileInfo;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.svcs.content.common.client.Synchronizable;
import com.sas.lsaf.svcs.content.repository.client.RepositoryFile;
import com.sas.lsaf.svcs.content.repository.client.RepositoryItem;
import com.sas.lsaf.svcs.content.repository.client.VersionDeleteInfo;
import com.sas.lsaf.svcs.content.repository.client.VersionInfo;
import com.sas.lsaf.svcs.content.repository.client.exception.BatchCheckinException;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryComparison;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryConstraint;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryContains;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryOrder;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryPredicate;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryQuery;
import com.sas.lsaf.svcs.content.repository.client.query.RepositoryScope;
import com.sas.lsaf.svcs.content.repository.client.query.RepositorySpecialOperator;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationCheckinSpecification;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationEntry;
import com.sas.lsaf.svcs.content.synchronization.client.query.SynchronizationSearchResultItem;
import com.sas.lsaf.svcs.core.action.client.ActionStatus;
import com.sas.lsaf.svcs.core.action.client.ActionStatusDetail;
import com.sas.lsaf.svcs.core.type.client.Type;
import com.sas.lsaf.svcs.core.type.client.TypeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class RepositoryHelper {
    private static SynchronizationInfo.FileStatus toApiFileStatus(SynchronizationEntry.FileStatus serverItem) {
        switch (serverItem) {
            case NON_EXISTENT: {
                return SynchronizationInfo.FileStatus.NON_EXISTENT;
            }
            case REPOSITORY_ONLY: {
                return SynchronizationInfo.FileStatus.REPOSITORY_ONLY;
            }
            case WORKSPACE_AND_REPOSITORY: {
                return SynchronizationInfo.FileStatus.WORKSPACE_AND_REPOSITORY;
            }
            case WORKSPACE_ONLY: {
                return SynchronizationInfo.FileStatus.WORKSPACE_ONLY;
            }
        }
        throw new SystemException("Unmapped file status: " + serverItem.name());
    }

    private static SynchronizationInfo.SynchronizationStatus toApiSynchronizationStatus(SynchronizationEntry.SynchronizationStatus serverItem) {
        switch (serverItem) {
            case IN_SYNC: {
                return SynchronizationInfo.SynchronizationStatus.IN_SYNC;
            }
            case NOT_SYNCED: {
                return SynchronizationInfo.SynchronizationStatus.NOT_SYNCED;
            }
            case OUT_OF_SYNC: {
                return SynchronizationInfo.SynchronizationStatus.OUT_OF_SYNC;
            }
        }
        throw new SystemException("Unmapped synchronization status: " + serverItem.name());
    }

    public static SynchronizationInfo.CheckoutStatus toApiCheckoutStatus(SynchronizationEntry.CheckoutStatus serverItem) {
        switch (serverItem) {
            case CHECKED_OUT: {
                return SynchronizationInfo.CheckoutStatus.CHECKED_OUT;
            }
            case MARKED_FOR_ADD: {
                return SynchronizationInfo.CheckoutStatus.MARKED_FOR_ADD;
            }
            case NOT_CHECKED_OUT: {
                return SynchronizationInfo.CheckoutStatus.NOT_CHECKED_OUT;
            }
        }
        throw new SystemException("Unmapped checkout status: " + serverItem.name());
    }

    private static VersionDeleteInfo.DeleteStatus toApiDeleteStatus(VersionDeleteInfo.DeleteStatus serverItem) {
        switch (serverItem) {
            case DELETED: {
                return VersionDeleteInfo.DeleteStatus.DELETED;
            }
            case NOT_DELETED_LAST_VERSION: {
                return VersionDeleteInfo.DeleteStatus.NOT_DELETED_LAST_VERSION;
            }
            case NOT_DELETED_VERSION_NOT_FOUND: {
                return VersionDeleteInfo.DeleteStatus.NOT_DELETED_VERSION_NOT_FOUND;
            }
        }
        throw new SystemException("Unmapped version delete status: " + serverItem.name());
    }

    private static RunHealthStatus toApiRunHealthStatus(com.sas.lsaf.svcs.content.repository.client.RunHealthStatus serverItem) {
        switch (serverItem) {
            case UNKNOWN: {
                return RunHealthStatus.UNKNOWN;
            }
            case STALE: {
                return RunHealthStatus.STALE;
            }
            case UP_TO_DATE: {
                return RunHealthStatus.UP_TO_DATE;
            }
        }
        throw new SystemException("Unmapped version run health status: " + serverItem.name());
    }

    public static RepositoryItem.State toApiState(RepositoryItem.State serverItem) {
        switch (serverItem) {
            case ACTIVE: {
                return RepositoryItem.State.ACTIVE;
            }
            case CLOSED: {
                return RepositoryItem.State.CLOSED;
            }
        }
        throw new SystemException("Unmapped repository item state: " + serverItem.name());
    }

    public static RepositoryItem.State toServerState(RepositoryItem.State apiItem) {
        switch (apiItem) {
            case ACTIVE: {
                return RepositoryItem.State.ACTIVE;
            }
            case CLOSED: {
                return RepositoryItem.State.CLOSED;
            }
        }
        throw new SystemException("Unmapped repository item state: " + apiItem.name());
    }

    public static RepositoryFile.SigningStatus toApiSigningStatus(RepositoryFile.SigningStatus serverSigningStatus) {
        if (serverSigningStatus == null) {
            return null;
        }
        switch (serverSigningStatus) {
            case NONE: {
                return RepositoryFile.SigningStatus.NONE;
            }
            case CURRENT: {
                return RepositoryFile.SigningStatus.CURRENT;
            }
            case BOTH: {
                return RepositoryFile.SigningStatus.CURRENT_AND_PREVIOUS;
            }
            case PREVIOUS: {
                return RepositoryFile.SigningStatus.PREVIOUS;
            }
        }
        throw new SystemException("Unmapped repository file signing status: " + serverSigningStatus.name());
    }

    public static RepositoryItem.Syncable toApiSyncable(Synchronizable.Syncable serverItem) {
        switch (serverItem) {
            case ALLOW: {
                return RepositoryItem.Syncable.ALLOW;
            }
            case WARN: {
                return RepositoryItem.Syncable.WARN;
            }
            case DENY: {
                return RepositoryItem.Syncable.DENY;
            }
            case DENY_ALL: {
                return RepositoryItem.Syncable.DENY_ALL;
            }
        }
        throw new SystemException("Unmapped repository item syncable: " + serverItem.name());
    }

    public static Synchronizable.Syncable toServerSyncable(RepositoryItem.Syncable apiItem) {
        switch (apiItem) {
            case ALLOW: {
                return Synchronizable.Syncable.ALLOW;
            }
            case WARN: {
                return Synchronizable.Syncable.WARN;
            }
            case DENY: {
                return Synchronizable.Syncable.DENY;
            }
            case DENY_ALL: {
                return Synchronizable.Syncable.DENY_ALL;
            }
        }
        throw new SystemException("Unmapped repository item syncable: " + apiItem.name());
    }

    public static List<RepositoryContext> toApiRepositoryContexts(List<com.sas.lsaf.svcs.content.repository.client.RepositoryContext> serverItems) {
        ArrayList<RepositoryContext> apiItems = new ArrayList<RepositoryContext>(serverItems.size());
        for (com.sas.lsaf.svcs.content.repository.client.RepositoryContext serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiRepositoryContext(serverItem));
        }
        return apiItems;
    }

    public static RepositoryContext toApiRepositoryContext(com.sas.lsaf.svcs.content.repository.client.RepositoryContext serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new RepositoryContext(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath(), serverItem.getRevision(), RepositoryHelper.toApiState(serverItem.getState()), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getPropertiesLastModifiedBy(), serverItem.getPropertiesLastModified(), serverItem.getDescription(), RepositoryHelper.toApiSyncable(serverItem.getSyncable()), CoreHelper.toApiAttributes(serverItem.getAttributes()), RepositoryHelper.toApiVersionLimits(serverItem.getDefaultVersionLimits()));
    }

    public static RepositoryFolder toApiRepositoryFolder(com.sas.lsaf.svcs.content.repository.client.RepositoryFolder serverItem) {
        return new RepositoryFolder(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath(), serverItem.getRevision(), RepositoryHelper.toApiState(serverItem.getState()), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getPropertiesLastModifiedBy(), serverItem.getPropertiesLastModified(), serverItem.getDescription(), RepositoryHelper.toApiSyncable(serverItem.getSyncable()), CoreHelper.toApiAttributes(serverItem.getAttributes()), RepositoryHelper.toApiVersionLimits(serverItem.getDefaultVersionLimits()));
    }

    public static RepositorySharedFolder toApiRepositorySharedFolder(com.sas.lsaf.svcs.content.repository.client.RepositorySharedFolder serverItem) {
        return new RepositorySharedFolder(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath(), serverItem.getRevision(), RepositoryHelper.toApiState(serverItem.getState()), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getPropertiesLastModifiedBy(), serverItem.getPropertiesLastModified(), serverItem.getDescription(), RepositoryHelper.toApiSyncable(serverItem.getSyncable()), CoreHelper.toApiAttributes(serverItem.getAttributes()), RepositoryHelper.toApiVersionLimits(serverItem.getDefaultVersionLimits()));
    }

    public static VersionLimits toApiVersionLimits(com.sas.lsaf.svcs.content.repository.client.VersionLimits serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new VersionLimits(serverItem.getMajorVersionLimit(), serverItem.getMinorVersionLimit());
    }

    public static com.sas.lsaf.svcs.content.repository.client.VersionLimits toServerVersionLimits(VersionLimits apiItem) {
        if (apiItem == null) {
            return null;
        }
        return new com.sas.lsaf.svcs.content.repository.client.VersionLimits(apiItem.getMajorVersionLimit(), apiItem.getMinorVersionLimit());
    }

    public static List<VersionDeleteInfo> toApiVersionDeleteInfos(List<com.sas.lsaf.svcs.content.repository.client.VersionDeleteInfo> serverItems) {
        ArrayList<VersionDeleteInfo> apiItems = new ArrayList<VersionDeleteInfo>(serverItems.size());
        for (com.sas.lsaf.svcs.content.repository.client.VersionDeleteInfo serverItem : serverItems) {
            if (serverItem == null) continue;
            apiItems.add(RepositoryHelper.toApiVersionDeleteInfo(serverItem));
        }
        return apiItems;
    }

    private static VersionDeleteInfo toApiVersionDeleteInfo(com.sas.lsaf.svcs.content.repository.client.VersionDeleteInfo serverItem) {
        if (serverItem != null) {
            return new VersionDeleteInfo(serverItem.getVersion(), RepositoryHelper.toApiDeleteStatus(serverItem.getDeleteStatus()));
        }
        return null;
    }

    public static RepositoryFile toApiRepositoryFile(com.sas.lsaf.svcs.content.repository.client.RepositoryFile serverItem) {
        if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile) {
            return RepositoryHelper.toApiRepositoryExecutableFile((com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile)serverItem);
        }
        return new RepositoryFile(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath(), serverItem.getRevision(), RepositoryHelper.toApiState(serverItem.getState()), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getPropertiesLastModifiedBy(), serverItem.getPropertiesLastModified(), serverItem.getDescription(), RepositoryHelper.toApiSyncable(serverItem.getSyncable()), CoreHelper.toApiAttributes(serverItem.getAttributes()), serverItem.getSize(), serverItem.isCheckedOut(), serverItem.getCheckedOutBy(), serverItem.getCheckedOutDate(), serverItem.isVersioned(), serverItem.getVersion(), serverItem.getCurrentComment(), serverItem.isLocked(), RepositoryHelper.toApiSigningStatus(serverItem.getSigningStatus()), RepositoryHelper.toApiVersionLimits(serverItem.getVersionLimits()), serverItem.getDigest());
    }

    public static RepositoryExecutableFile toApiRepositoryExecutableFile(com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile serverItem) {
        return new RepositoryExecutableFile(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath(), serverItem.getRevision(), RepositoryHelper.toApiState(serverItem.getState()), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getPropertiesLastModifiedBy(), serverItem.getPropertiesLastModified(), serverItem.getDescription(), RepositoryHelper.toApiSyncable(serverItem.getSyncable()), CoreHelper.toApiAttributes(serverItem.getAttributes()), serverItem.getSize(), serverItem.isCheckedOut(), serverItem.getCheckedOutBy(), serverItem.getCheckedOutDate(), serverItem.isVersioned(), serverItem.getVersion(), serverItem.getCurrentComment(), serverItem.isLocked(), RepositoryHelper.toApiSigningStatus(serverItem.getSigningStatus()), serverItem.isRunAsOwner(), RepositoryHelper.toApiVersionLimits(serverItem.getVersionLimits()), serverItem.getDigest(), serverItem.getLastRunDate(), RepositoryHelper.toApiRunHealthStatus(serverItem.getHealthStatus()));
    }

    public static RepositoryItem toApiRepositoryItem(com.sas.lsaf.svcs.content.repository.client.RepositoryItem serverItem) {
        if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile) {
            return RepositoryHelper.toApiRepositoryExecutableFile((com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile)serverItem);
        }
        if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryFile) {
            return RepositoryHelper.toApiRepositoryFile((com.sas.lsaf.svcs.content.repository.client.RepositoryFile)serverItem);
        }
        if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryContext) {
            return RepositoryHelper.toApiRepositoryContext((com.sas.lsaf.svcs.content.repository.client.RepositoryContext)serverItem);
        }
        if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositoryFolder) {
            if (serverItem instanceof com.sas.lsaf.svcs.content.repository.client.RepositorySharedFolder) {
                return RepositoryHelper.toApiRepositorySharedFolder((com.sas.lsaf.svcs.content.repository.client.RepositorySharedFolder)serverItem);
            }
            return RepositoryHelper.toApiRepositoryFolder((com.sas.lsaf.svcs.content.repository.client.RepositoryFolder)serverItem);
        }
        throw new SystemException("Unmapped repository item: " + serverItem);
    }

    public static List<RepositoryFile> toApiRepositoryFiles(List<com.sas.lsaf.svcs.content.repository.client.RepositoryFile> serverItems) {
        ArrayList<RepositoryFile> apiItems = new ArrayList<RepositoryFile>(serverItems.size());
        for (com.sas.lsaf.svcs.content.repository.client.RepositoryFile serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiRepositoryFile(serverItem));
        }
        return apiItems;
    }

    public static List<RepositoryItem> toApiRepositoryItems(List<com.sas.lsaf.svcs.content.repository.client.RepositoryItem> serverItems) {
        ArrayList<RepositoryItem> apiItems = new ArrayList<RepositoryItem>(serverItems.size());
        for (com.sas.lsaf.svcs.content.repository.client.RepositoryItem serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiRepositoryItem(serverItem));
        }
        return apiItems;
    }

    public static SynchronizationInfo toApiSynchronizationInfo(SynchronizationEntry serverItem) {
        if (serverItem == null) {
            return null;
        }
        RepositoryFileInfo rfi = serverItem.getRepositoryFileInfo() == null ? null : new RepositoryFileInfo(serverItem.getRepositoryFileInfo().getId(), serverItem.getRepositoryFileInfo().getPath(), serverItem.getRepositoryFileInfo().getVersion(), serverItem.getRepositoryFileInfo().getLastModifiedDate(), serverItem.getRepositoryFileInfo().getSize().longValue(), serverItem.getRepositoryFileInfo().isCheckedOut(), serverItem.getRepositoryFileInfo().getCheckedOutBy());
        SynchronizationFileInfo sfi = serverItem.getSynchronizationFileInfo() == null ? null : new SynchronizationFileInfo(serverItem.getSynchronizationFileInfo().getPath(), serverItem.getSynchronizationFileInfo().getVersion(), serverItem.getSynchronizationDate(), serverItem.getSynchronizationFileInfo().getLastModifiedDate(), serverItem.getSynchronizationFileInfo().getSize().longValue());
        WorkspaceFileInfo wfi = serverItem.getWorkspaceFileInfo() == null ? null : new WorkspaceFileInfo(serverItem.getWorkspaceFileInfo().getPath(), serverItem.getWorkspaceFileInfo().getLastModifiedDate(), serverItem.getWorkspaceFileInfo().getSize().longValue());
        return new SynchronizationInfo(serverItem.getPath(), rfi, sfi, wfi, RepositoryHelper.toApiFileStatus(serverItem.getFileStatus()), RepositoryHelper.toApiSynchronizationStatus(serverItem.getSynchronizationStatus()), RepositoryHelper.toApiCheckoutStatus(serverItem.getCheckoutStatus()));
    }

    public static List<SynchronizationInfo> toApiSynchronizationInfos(Set<SynchronizationEntry> serverItems) {
        ArrayList<SynchronizationInfo> apiItems = new ArrayList<SynchronizationInfo>();
        for (SynchronizationEntry serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiSynchronizationInfo(serverItem));
        }
        return apiItems;
    }

    public static com.sas.lsaf.svcs.content.repository.client.RepositoryItem toServerRepositoryItem(RepositoryItem apiItem) {
        if (apiItem instanceof RepositoryExecutableFile) {
            return RepositoryHelper.toServerRepositoryExecutableFile((RepositoryExecutableFile)apiItem);
        }
        if (apiItem instanceof RepositoryFile) {
            return RepositoryHelper.toServerRepositoryFile((RepositoryFile)apiItem);
        }
        if (apiItem instanceof RepositoryContext) {
            return RepositoryHelper.toServerRepositoryContext((RepositoryContext)apiItem);
        }
        if (apiItem instanceof RepositoryFolder) {
            return RepositoryHelper.toServerRepositoryFolder((RepositoryFolder)apiItem);
        }
        throw new SystemException("Unmapped repository item: " + apiItem);
    }

    private static void doSetBaseAttributes(RepositoryItem apiItem, com.sas.lsaf.svcs.content.repository.client.RepositoryItem serverItem) {
        serverItem.setId(apiItem.getId());
        serverItem.setTypeId(apiItem.getTypeId());
        serverItem.setName(apiItem.getName());
        serverItem.setPath(apiItem.getPath());
        serverItem.setRevision(apiItem.getRevision());
        serverItem.setState(RepositoryHelper.toServerState(apiItem.getState()));
        serverItem.setCreatedBy(apiItem.getCreatedBy());
        serverItem.setCreated(apiItem.getCreated());
        serverItem.setLastModifiedBy(apiItem.getLastModifiedBy());
        serverItem.setLastModified(apiItem.getLastModified());
        serverItem.setPropertiesLastModifiedBy(apiItem.getPropertiesLastModifiedBy());
        serverItem.setPropertiesLastModified(apiItem.getPropertiesLastModified());
        serverItem.setDescription(apiItem.getDescription());
        serverItem.setSyncable(RepositoryHelper.toServerSyncable(apiItem.getSyncable()));
        serverItem.setAttributes(CoreHelper.toServerAttributes(apiItem.getAttributes()));
    }

    public static com.sas.lsaf.svcs.content.repository.client.RepositoryContext toServerRepositoryContext(RepositoryContext apiItem) {
        com.sas.lsaf.svcs.content.repository.client.RepositoryContext serverItem = new com.sas.lsaf.svcs.content.repository.client.RepositoryContext();
        RepositoryHelper.doSetBaseAttributes((RepositoryItem)apiItem, (com.sas.lsaf.svcs.content.repository.client.RepositoryItem)serverItem);
        serverItem.setDefaultVersionLimits(RepositoryHelper.toServerVersionLimits(apiItem.getDefaultVersionLimits()));
        return serverItem;
    }

    public static com.sas.lsaf.svcs.content.repository.client.RepositoryFolder toServerRepositoryFolder(RepositoryFolder apiItem) {
        com.sas.lsaf.svcs.content.repository.client.RepositoryFolder serverItem = new com.sas.lsaf.svcs.content.repository.client.RepositoryFolder();
        RepositoryHelper.doSetBaseAttributes((RepositoryItem)apiItem, (com.sas.lsaf.svcs.content.repository.client.RepositoryItem)serverItem);
        serverItem.setDefaultVersionLimits(RepositoryHelper.toServerVersionLimits(apiItem.getDefaultVersionLimits()));
        return serverItem;
    }

    public static com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile toServerRepositoryExecutableFile(RepositoryExecutableFile apiItem) {
        com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile serverItem = new com.sas.lsaf.svcs.content.repository.client.RepositoryExecutableFile();
        RepositoryHelper.doSetBaseAttributes((RepositoryItem)apiItem, (com.sas.lsaf.svcs.content.repository.client.RepositoryItem)serverItem);
        serverItem.setSize(apiItem.getSize());
        serverItem.setCheckedOut(apiItem.isCheckedOut());
        serverItem.setCheckedOutBy(apiItem.getCheckedOutBy());
        serverItem.setCheckedOutDate(apiItem.getCheckedOutDate());
        serverItem.setVersioned(apiItem.isVersioned());
        serverItem.setLocked(apiItem.isLocked());
        serverItem.setRunAsOwner(apiItem.isRunAsOwner());
        serverItem.setVersionLimits(RepositoryHelper.toServerVersionLimits(apiItem.getVersionLimits()));
        return serverItem;
    }

    public static com.sas.lsaf.svcs.content.repository.client.RepositoryFile toServerRepositoryFile(RepositoryFile apiItem) {
        com.sas.lsaf.svcs.content.repository.client.RepositoryFile serverItem = new com.sas.lsaf.svcs.content.repository.client.RepositoryFile();
        RepositoryHelper.doSetBaseAttributes((RepositoryItem)apiItem, (com.sas.lsaf.svcs.content.repository.client.RepositoryItem)serverItem);
        serverItem.setSize(apiItem.getSize());
        serverItem.setCheckedOut(apiItem.isCheckedOut());
        serverItem.setCheckedOutBy(apiItem.getCheckedOutBy());
        serverItem.setCheckedOutDate(apiItem.getCheckedOutDate());
        serverItem.setVersioned(apiItem.isVersioned());
        serverItem.setLocked(apiItem.isLocked());
        serverItem.setVersionLimits(RepositoryHelper.toServerVersionLimits(apiItem.getVersionLimits()));
        return serverItem;
    }

    public static List<SynchronizationInfo> toApiSynchronizationInfos(List<SynchronizationSearchResultItem> serverItems) {
        ArrayList<SynchronizationInfo> apiItems = new ArrayList<SynchronizationInfo>(serverItems.size());
        for (SynchronizationSearchResultItem serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiSynchronizationInfo((SynchronizationEntry)serverItem));
        }
        return apiItems;
    }

    public static RepositoryItemCheckinException handleBatchCheckinException(String path, BatchCheckinException e) {
        List details;
        ActionStatus as = e.getActionStatus();
        if (as != null && (details = as.getDetails()) != null && !details.isEmpty()) {
            ActionStatusDetail detail = (ActionStatusDetail)details.get(0);
            String s = detail.getMessage();
            return new RepositoryItemCheckinException(path, s != null ? s : e.getLocalizedMessage());
        }
        return new RepositoryItemCheckinException(path, e.getLocalizedMessage());
    }

    public static com.sas.lsaf.svcs.content.common.client.VersionType toServerVersionType(VersionType apiItem) {
        if (apiItem == null) {
            return com.sas.lsaf.svcs.content.common.client.VersionType.MAJOR;
        }
        switch (apiItem) {
            case MINOR: {
                return com.sas.lsaf.svcs.content.common.client.VersionType.MINOR;
            }
            case MAJOR: {
                return com.sas.lsaf.svcs.content.common.client.VersionType.MAJOR;
            }
        }
        return com.sas.lsaf.svcs.content.common.client.VersionType.CUSTOM;
    }

    public static String toServerVersion(RepositoryCheckinSpecification apiCheckinSpec) {
        if (apiCheckinSpec == null) {
            return null;
        }
        if (apiCheckinSpec.isEnableVersioningForNewFiles()) {
            if (apiCheckinSpec.getCustomVersion() == null || apiCheckinSpec.getCustomVersion().trim().isEmpty()) {
                if (apiCheckinSpec.getVersionType() == null || apiCheckinSpec.getVersionType() == VersionType.MINOR) {
                    return "0.1";
                }
                if (apiCheckinSpec.getVersionType() == VersionType.MAJOR) {
                    return "1.0";
                }
                if (apiCheckinSpec.getVersionType() == VersionType.CUSTOM) {
                    throw new ValidationException("A valid custom version must be specified if VersionType is set to CUSTOM.");
                }
            } else {
                return apiCheckinSpec.getCustomVersion();
            }
        }
        return null;
    }

    public static VersionType toApiVersionType(com.sas.lsaf.svcs.content.common.client.VersionType serverItem) {
        switch (serverItem) {
            case CUSTOM: {
                return VersionType.CUSTOM;
            }
            case MINOR: {
                return VersionType.MINOR;
            }
            case MAJOR: {
                return VersionType.MAJOR;
            }
        }
        throw new SystemException("Unmapped repository item syncable: " + serverItem.name());
    }

    public static SynchronizationCheckinSpecification toServerSynchronizationCheckinSpecification(RepositoryCheckinSpecification apiItem) {
        SynchronizationCheckinSpecification serverItem = new SynchronizationCheckinSpecification();
        serverItem.setCheckoutInPlace(false);
        serverItem.setComment(apiItem.getComment());
        serverItem.setCustomVersion(apiItem.getCustomVersion());
        serverItem.setEnableVersioningForNewFiles(apiItem.isEnableVersioningForNewFiles());
        serverItem.setMarkForAddIfMissing(true);
        serverItem.setVersionType(RepositoryHelper.toServerVersionType(apiItem.getVersionType()));
        return serverItem;
    }

    public static List<RepositoryFileVersionInfo> toApiRepositoryFileVersionInfos(List<VersionInfo> serverItems) {
        ArrayList<RepositoryFileVersionInfo> apiItems = new ArrayList<RepositoryFileVersionInfo>(serverItems.size());
        for (VersionInfo serverItem : serverItems) {
            apiItems.add(RepositoryHelper.toApiRepositoryFileVersionInfo(serverItem));
        }
        return apiItems;
    }

    public static RepositoryFileVersionInfo toApiRepositoryFileVersionInfo(VersionInfo serverItem) {
        return new RepositoryFileVersionInfo(serverItem.getId(), serverItem.getName(), serverItem.getComment(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getSize(), serverItem.isLatest(), serverItem.isSigned(), serverItem.getDigest());
    }

    public static List<RepositoryStateChangeResult> toApiRepositoryStateChangeResults(List<com.sas.lsaf.svcs.content.repository.client.RepositoryStateChangeResult> serverItems) {
        ArrayList<RepositoryStateChangeResult> apiItems = new ArrayList<RepositoryStateChangeResult>(serverItems.size());
        for (com.sas.lsaf.svcs.content.repository.client.RepositoryStateChangeResult serverItem : serverItems) {
            apiItems.add(new RepositoryStateChangeResult(serverItem.getPath(), RepositoryHelper.toApiState(serverItem.getOldState())));
        }
        return apiItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RepositoryQuery toSearchRequest(SearchQuery query, TypeService typeService) {
        if (query == null) {
            return null;
        }
        RepositoryQuery q = new RepositoryQuery();
        RepositoryComparison comparison = null;
        ArrayList<Object> constraints = new ArrayList<Object>();
        RepositoryPredicate p = null;
        if (query.getName() != null && !query.getName().isEmpty()) {
            comparison = new RepositoryComparison("name", RepositoryComparison.Operator.LIKE, (Object)query.getName(), false);
            constraints.add(comparison);
        }
        if (query.getLastModifiedBy() != null && !query.getLastModifiedBy().isEmpty()) {
            comparison = new RepositoryComparison("lastModifiedBy", RepositoryComparison.Operator.LIKE, (Object)query.getLastModifiedBy(), false);
            constraints.add(comparison);
        }
        if (query.getCreatedBy() != null && !query.getCreatedBy().isEmpty()) {
            comparison = new RepositoryComparison("createdBy", RepositoryComparison.Operator.LIKE, (Object)query.getCreatedBy(), false);
            constraints.add(comparison);
        }
        if (query.getOwner() != null && !query.getOwner().isEmpty()) {
            comparison = new RepositoryComparison("owner", RepositoryComparison.Operator.LIKE, (Object)query.getOwner(), false);
            constraints.add(comparison);
        }
        if (query.getCopyToWorkspaceStatus() != null) {
            comparison = new RepositoryComparison("syncable", RepositoryComparison.Operator.EQUAL, (Object)query.getCopyToWorkspaceStatus().name(), false);
            constraints.add(comparison);
        }
        if (query.getTypeId() != null && !query.getTypeId().isEmpty()) {
            String typeId = query.getTypeId();
            RepositorySpecialOperator operator = null;
            if (typeId.equals("sas:file")) {
                operator = new RepositorySpecialOperator(RepositorySpecialOperator.Operator.IS_FILE);
            } else if (typeId.equals("sas:context")) {
                RepositoryPredicate contextTypesPredicate = new RepositoryPredicate(RepositoryPredicate.Operator.OR);
                List contextTypes = typeService.getContextTypes();
                for (Type type : contextTypes) {
                    contextTypesPredicate.addConstraint((RepositoryConstraint)new RepositoryComparison("type", RepositoryComparison.Operator.EQUAL, (Object)type.getId(), true));
                }
                constraints.add(contextTypesPredicate);
            } else {
                operator = new RepositoryComparison("type", RepositoryComparison.Operator.LIKE, (Object)typeId, false);
            }
            if (query.getContent() != null && !query.getContent().isEmpty()) {
                if (!RepositoryHelper.supportsContentSearch(typeId)) throw new IllegalArgumentException("The type specified, " + typeId + ", does not support content searches.");
                RepositoryPredicate contentPredicate = RepositoryHelper.createConstraintForContentSearch((RepositoryConstraint)operator, query.getContent());
                constraints.add(contentPredicate);
            } else if (operator != null) {
                constraints.add(operator);
            }
        } else if (query.getContent() != null && !query.getContent().isEmpty()) {
            throw new IllegalArgumentException("A content search requires a file object type to be specified on the query.");
        }
        if (query.getFromLastModifiedDate() != null) {
            comparison = new RepositoryComparison("lastModified", RepositoryComparison.Operator.GREATER_THAN_OR_EQUAL, (Object)query.getFromLastModifiedDate(), false);
            constraints.add(comparison);
        }
        if (query.getToLastModifiedDate() != null) {
            comparison = new RepositoryComparison("lastModified", RepositoryComparison.Operator.LESS_THAN_OR_EQUAL, (Object)query.getToLastModifiedDate(), false);
            constraints.add(comparison);
        }
        if (query.getFromCreated() != null) {
            comparison = new RepositoryComparison("created", RepositoryComparison.Operator.GREATER_THAN_OR_EQUAL, (Object)query.getFromCreated(), false);
            constraints.add(comparison);
        }
        if (query.getToCreated() != null) {
            comparison = new RepositoryComparison("created", RepositoryComparison.Operator.LESS_THAN_OR_EQUAL, (Object)query.getToCreated(), false);
            constraints.add(comparison);
        }
        if (!constraints.isEmpty()) {
            p = new RepositoryPredicate();
            p.setConstraints(constraints);
            p.setOperator(RepositoryPredicate.Operator.AND);
            q.setConstraint((RepositoryConstraint)p);
        }
        if (query.getLocation() != null && !query.getLocation().isEmpty()) {
            RepositoryScope scope = new RepositoryScope(query.getLocation());
            q.setScope(scope);
        }
        RepositoryOrder order = new RepositoryOrder("name", true, false);
        ArrayList<RepositoryOrder> orders = new ArrayList<RepositoryOrder>();
        orders.add(order);
        q.setOrder(orders);
        return q;
    }

    private static RepositoryPredicate createConstraintForContentSearch(RepositoryConstraint operator, String content) {
        RepositoryContains contains = new RepositoryContains(content);
        RepositoryPredicate p = new RepositoryPredicate();
        p.setOperator(RepositoryPredicate.Operator.AND);
        ArrayList<Object> constraints = new ArrayList<Object>(0);
        constraints.add(operator);
        constraints.add(contains);
        p.setConstraints(constraints);
        return p;
    }

    private static boolean supportsContentSearch(String objectType) {
        boolean ret = false;
        if (objectType != null) {
            return objectType.equals("sas:file") || objectType.equals("sas:sasprogram") || objectType.equals("sas:pdf") || objectType.equals("sas:job");
        }
        return ret;
    }
}

