/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.impl;

import com.sas.lsaf.content.repository.BatchRepositoryService;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.impl.InternalActionStatusService;
import com.sas.lsaf.core.utils.impl.CollectionUtils;
import com.sas.lsaf.svcs.content.synchronization.client.BatchSynchronizationService;
import com.sas.lsaf.svcs.content.synchronization.client.CheckinEntry;
import com.sas.lsaf.svcs.content.synchronization.client.SynchronizationService;
import com.sas.lsaf.svcs.content.synchronization.client.VersionSpecification;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class BatchRepositoryServiceImpl
implements BatchRepositoryService {
    private SynchronizationService synchronizationService;
    private BatchSynchronizationService batchSynchronizationService;
    private InternalActionStatusService internalActionStatusService;

    private String doGetWorkspaceId() {
        return this.synchronizationService.getCurrentUserWorkspace().getId();
    }

    private static String doIncrementMajorVersion(String currentVersion) {
        String newVersion = null;
        if (currentVersion == null || currentVersion == "") {
            return "1.0";
        }
        int dot = currentVersion.indexOf(46);
        int major = Integer.valueOf(currentVersion.substring(0, dot));
        if (major == 99999) {
            return currentVersion;
        }
        String newMajor = String.valueOf(major + 1);
        newVersion = newMajor + ".0";
        return newVersion;
    }

    @Required
    public void setBatchSynchronizationService(BatchSynchronizationService service) {
        this.batchSynchronizationService = service;
    }

    @Required
    public void setSynchronizationService(SynchronizationService service) {
        this.synchronizationService = service;
    }

    @Required
    public void setInternalActionStatusService(InternalActionStatusService service) {
        this.internalActionStatusService = service;
    }

    public ActionStatus checkout(List<String> paths) {
        Assert.notEmpty(paths, (String)"Repository paths are required.");
        ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(this.batchSynchronizationService.batchCheckout(this.doGetWorkspaceId(), CollectionUtils.asSet(paths)).getId());
        return as;
    }

    public ActionStatus checkin(List<String> paths, RepositoryCheckinSpecification spec) {
        Assert.notEmpty(paths, (String)"Repository paths are required.");
        String workspaceId = this.doGetWorkspaceId();
        HashSet<VersionSpecification> versionSpecs = new HashSet<VersionSpecification>();
        VersionType versionType = VersionType.MINOR;
        String comment = null;
        String version = null;
        if (spec != null) {
            if (spec.getVersionType() != null && (versionType = spec.getVersionType()).equals((Object)VersionType.CUSTOM)) {
                version = spec.getCustomVersion();
            }
            if (spec.getComment() != null) {
                comment = spec.getComment();
            }
        }
        Set checkinEntries = this.synchronizationService.getCheckinEntries(workspaceId, CollectionUtils.asSet(paths));
        for (String path : paths) {
            boolean pathFound = false;
            for (CheckinEntry ce : checkinEntries) {
                if (!path.equals(ce.getPath()) && !ce.getPath().startsWith(path)) continue;
                pathFound = true;
                versionSpecs.add(new VersionSpecification(ce.getPath(), versionType.equals((Object)VersionType.MAJOR) ? BatchRepositoryServiceImpl.doIncrementMajorVersion(ce.getVersion()) : version));
            }
            if (pathFound) continue;
            versionSpecs.add(new VersionSpecification(path, versionType.equals((Object)VersionType.MAJOR) ? BatchRepositoryServiceImpl.doIncrementMajorVersion(version) : version));
        }
        ActionStatus as = this.internalActionStatusService.getCompletedActionStatusById(this.batchSynchronizationService.batchCheckin(workspaceId, versionSpecs, comment).getId());
        return as;
    }

    public ActionStatus uploadAndExpand(String parentPath, String localZipFilePath, boolean enableVersioningOnAllNewFiles, RepositoryCheckinSpecification checkinSpec, boolean createParentFolders) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }

    public void downloadAsZip(Set<String> paths, String localFilePath, boolean overwrite) {
        throw new UnsupportedOperationException("Functionality is provided by file streaming helper.");
    }
}

