/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.tlftemplate.impl;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.common.ImportException;
import com.sas.lsaf.clinical.tlf.TlfUpdateException;
import com.sas.lsaf.clinical.tlf.TlfUpdateResult;
import com.sas.lsaf.clinical.tlf.impl.TlfHelper;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplate;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateExistsException;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateImportInfo;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateNotFoundException;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateService;
import com.sas.lsaf.clinical.tlftemplate.impl.TlfTemplateHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.svcs.clinical.arm.client.AnalysisResultsService;
import com.sas.lsaf.svcs.clinical.arm.client.exception.AnalysisResultNotFoundException;
import com.sas.lsaf.svcs.clinical.arm.client.exception.AnalysisResultsUpdateException;
import com.sas.lsaf.svcs.clinical.common.client.exception.ClinicalParseException;
import com.sas.lsaf.svcs.clinical.common.client.exception.ValidationReportException;
import com.sas.lsaf.svcs.clinical.model.client.exception.ModelNotFoundException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfImportException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfNotFoundException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public final class TlfTemplateServiceImpl
implements TlfTemplateService {
    private com.sas.lsaf.svcs.clinical.tlftemplate.client.TlfTemplateService tlfTemplateService;
    private AnalysisResultsService analysisResultsService;

    @Required
    public void setTlfTemplateService(com.sas.lsaf.svcs.clinical.tlftemplate.client.TlfTemplateService service) {
        this.tlfTemplateService = service;
    }

    @Required
    public void setAnalysisResultsService(AnalysisResultsService service) {
        this.analysisResultsService = service;
    }

    public TlfTemplate createTlfTemplate(String name, String description) throws TlfTemplateExistsException {
        Assert.hasText((String)name, (String)"Name is required.");
        try {
            return TlfTemplateHelper.toApiTlfTemplate(this.tlfTemplateService.createTlfTemplate(name, description));
        }
        catch (com.sas.lsaf.svcs.clinical.tlftemplate.client.exception.TlfTemplateExistsException e) {
            throw new TlfTemplateExistsException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<TlfTemplate> getTlfTemplates() {
        try {
            return TlfTemplateHelper.toApiTlfTemplates(this.tlfTemplateService.getTlfTemplates());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<String> exportTlfsToDataSets(String tlfTemplateId, BatchFileCreateInfo info, boolean includeAnalysisResults) throws TlfTemplateNotFoundException, ExportException {
        Assert.hasText((String)tlfTemplateId, (String)"TLF Template id is required for update.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return TlfHelper.toApiTlfDataSets(this.analysisResultsService.exportTlfsToDataSets(tlfTemplateId, ClinicalHelper.toServerBatchFileCreateInfo(info), includeAnalysisResults));
        }
        catch (AnalysisResultNotFoundException | com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | ModelNotFoundException | SectionNotFoundException | TlfNotFoundException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlftemplate.client.exception.TlfTemplateNotFoundException e) {
            throw new TlfTemplateNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public TlfUpdateResult importTlfsToTlfTemplate(TlfTemplateImportInfo importInfo, ExportFileCreateInfo validationInfo) throws TlfTemplateNotFoundException, TlfUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.notNull((Object)importInfo, (String)"Import information is required.");
        Assert.hasText((String)importInfo.getTlfTemplateId(), (String)"TLF Template id is required for update.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Replace action is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getSectionsFilePath()), (String)"Import file path for sections must be to a data set.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getTlfsFilePath()), (String)"Import file path for TLFs must be to a data set.");
        if (importInfo.getResultsFilePath() != null && !importInfo.getResultsFilePath().isEmpty()) {
            Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getResultsFilePath()), (String)"Import file path for study analysis results must be to a data set.");
        }
        if (importInfo.getDataSetsFilePath() != null && !importInfo.getDataSetsFilePath().isEmpty()) {
            Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getDataSetsFilePath()), (String)"Import file path for study analysis result data sets must be to a data set.");
        }
        try {
            com.sas.lsaf.svcs.clinical.tlf.client.TlfUpdateResult serverResult = this.analysisResultsService.updateTlfsFromFile(TlfHelper.toServerTlfImportInfo(importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo));
            com.sas.lsaf.svcs.clinical.tlftemplate.client.TlfTemplate serverTlfTemplate = this.tlfTemplateService.getTlfTemplateById(importInfo.getTlfTemplateId());
            return TlfTemplateHelper.toApiTlfUpdateResult(serverResult, serverTlfTemplate, validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (AnalysisResultNotFoundException | AnalysisResultsUpdateException | ModelNotFoundException | SectionNotFoundException | TlfNotFoundException | com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfUpdateException e) {
            throw new TlfUpdateException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlftemplate.client.exception.TlfTemplateNotFoundException e) {
            throw new TlfTemplateNotFoundException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | TlfImportException | RepositoryException | WorkspaceException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

