/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.tlf.impl;

import com.sas.lsaf.clinical.common.AttributeValue;
import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.tlf.AnalysisDataset;
import com.sas.lsaf.clinical.tlf.AnalysisResult;
import com.sas.lsaf.clinical.tlf.SectionDescriptor;
import com.sas.lsaf.clinical.tlf.Tlf;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateImportInfo;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.security.principal.impl.PrincipalHelper;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.security.user.impl.UserHelper;
import com.sas.lsaf.svcs.clinical.arm.client.TlfTemplateUpdateFromFileInfo;
import com.sas.lsaf.svcs.clinical.common.client.ClinicalConstants;
import com.sas.lsaf.svcs.clinical.standards.client.ImportSourceType;
import com.sas.lsaf.svcs.clinical.standards.client.StandardAttributeValue;
import com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfRoot;
import com.sas.lsaf.svcs.clinical.tlf.client.TlfDataSet;
import com.sas.lsaf.svcs.content.common.client.FileSpecification;
import com.sas.lsaf.svcs.core.common.client.Identifiable;
import com.sas.lsaf.svcs.core.common.client.ObjectIdentity;
import com.sas.lsaf.svcs.security.principal.client.Principal;
import com.sas.lsaf.svcs.security.principal.server.PrincipalIdentity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TlfHelper {
    public static List<Tlf> toApiTlfs(List<com.sas.lsaf.svcs.clinical.tlf.client.Tlf> serverItems) {
        ArrayList<Tlf> apiItems = new ArrayList<Tlf>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.tlf.client.Tlf serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(TlfHelper.toApiTlf(serverItem));
            }
        }
        return apiItems;
    }

    public static List<Tlf> toApiRootTlfs(List<com.sas.lsaf.svcs.clinical.tlf.client.Tlf> serverItems) {
        ArrayList<Tlf> apiItems = new ArrayList<Tlf>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.tlf.client.Tlf serverItem : serverItems) {
                if (serverItem == null || !(serverItem.getParent() instanceof StudyTlfRoot)) continue;
                apiItems.add(TlfHelper.toApiTlf(serverItem));
            }
        }
        return apiItems;
    }

    public static Tlf toApiTlf(com.sas.lsaf.svcs.clinical.tlf.client.Tlf serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new Tlf(serverItem.getId(), serverItem.getTypeId(), serverItem.getName(), serverItem.getIdentifier(), TlfHelper.toApiTlfParent(serverItem.getParent()), serverItem.getOrder(), serverItem.getResultCount(), TlfHelper.toApiAttributes(serverItem.getAttributes()), serverItem.isEnableAutoFlow());
    }

    public static List<com.sas.lsaf.svcs.clinical.tlf.client.Tlf> toServerTlfs(List<Tlf> apiItems) {
        ArrayList<com.sas.lsaf.svcs.clinical.tlf.client.Tlf> serverItems = new ArrayList<com.sas.lsaf.svcs.clinical.tlf.client.Tlf>();
        if (apiItems != null) {
            for (Tlf apiItem : apiItems) {
                if (apiItem == null) continue;
                serverItems.add(TlfHelper.toServerTlf(apiItem));
            }
        }
        return serverItems;
    }

    public static com.sas.lsaf.svcs.clinical.tlf.client.Tlf toServerTlf(Tlf apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.clinical.tlf.client.Tlf serverTlf = new com.sas.lsaf.svcs.clinical.tlf.client.Tlf();
        serverTlf.setId(apiItem.getId());
        serverTlf.setTypeId(apiItem.getTypeId());
        serverTlf.setName(apiItem.getName());
        serverTlf.setIdentifier(apiItem.getIdentifier());
        serverTlf.setParent(TlfHelper.toServerTlfParent(apiItem.getParent()));
        serverTlf.setAttributes(TlfHelper.toServerStandardAttributeValues(apiItem.getAttributes()));
        serverTlf.setEnableAutoFlow(apiItem.isEnableAutoFlow());
        serverTlf.setOrder(serverTlf.getOrder());
        return serverTlf;
    }

    public static Identifiable toServerTlfParent(com.sas.lsaf.core.Identifiable apiItem) {
        if (apiItem == null) {
            return null;
        }
        if (apiItem instanceof SectionDescriptor) {
            SectionDescriptor apiSection = (SectionDescriptor)apiItem;
            return new com.sas.lsaf.svcs.clinical.tlf.client.SectionDescriptor(apiSection.getId(), apiSection.getName(), apiSection.getSectionIdentifier(), apiSection.getDescription());
        }
        return new ObjectIdentity(apiItem.getTypeId(), apiItem.getId());
    }

    public static com.sas.lsaf.core.Identifiable toApiTlfParent(Identifiable serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.core.ObjectIdentity(serverItem.getTypeId(), serverItem.getId());
    }

    public static List<StandardAttributeValue> toServerStandardAttributeValues(List<AttributeValue> apiItems) {
        ArrayList<StandardAttributeValue> serverItems = new ArrayList<StandardAttributeValue>();
        if (apiItems != null) {
            for (AttributeValue apiItem : apiItems) {
                if (apiItem == null) continue;
                serverItems.add(TlfHelper.toServerStandardAttributeValue(apiItem));
            }
        }
        return serverItems;
    }

    private static StandardAttributeValue toServerStandardAttributeValue(AttributeValue apiItem) {
        if (apiItem == null) {
            return null;
        }
        Serializable value = apiItem.getValue();
        if (value instanceof UserDescriptor) {
            UserDescriptor u = (UserDescriptor)value;
            value = new PrincipalIdentity(u.getTypeId(), u.getId());
        } else if (value instanceof com.sas.lsaf.content.common.FileSpecification) {
            com.sas.lsaf.content.common.FileSpecification fileSpec = (com.sas.lsaf.content.common.FileSpecification)value;
            value = new FileSpecification(fileSpec.getPath(), fileSpec.getVersion());
        } else if (value instanceof com.sas.lsaf.security.principal.Principal) {
            com.sas.lsaf.security.principal.Principal p = (com.sas.lsaf.security.principal.Principal)value;
            value = new PrincipalIdentity(p.getTypeId(), p.getId());
        }
        return new StandardAttributeValue(apiItem.getId(), apiItem.getName(), value);
    }

    public static List<AttributeValue> toApiAttributes(List<StandardAttributeValue> serverItems) {
        ArrayList<AttributeValue> ret = new ArrayList<AttributeValue>();
        if (serverItems != null) {
            for (StandardAttributeValue serverItem : serverItems) {
                if (serverItem == null) continue;
                ret.add(new AttributeValue(serverItem.getId(), serverItem.getName(), TlfHelper.toApiTlfAttributeValue(serverItem.getValue())));
            }
        }
        return ret;
    }

    private static Serializable toApiTlfAttributeValue(Serializable serverValue) {
        if (serverValue == null) {
            return null;
        }
        if (serverValue instanceof FileSpecification) {
            FileSpecification serverFileSpec = (FileSpecification)serverValue;
            return new com.sas.lsaf.content.common.FileSpecification(serverFileSpec.getPath(), serverFileSpec.getVersion());
        }
        if (serverValue instanceof Principal) {
            return PrincipalHelper.toApiPrincipal((Principal)serverValue);
        }
        if (serverValue instanceof com.sas.lsaf.svcs.security.user.client.UserDescriptor) {
            return UserHelper.toApiUserDescriptor((com.sas.lsaf.svcs.security.user.client.UserDescriptor)serverValue);
        }
        return serverValue;
    }

    public static TlfTemplateUpdateFromFileInfo toServerTlfImportInfo(TlfTemplateImportInfo apiItem) {
        TlfTemplateUpdateFromFileInfo serverInfo = new TlfTemplateUpdateFromFileInfo();
        serverInfo.setTlfTemplateId(apiItem.getTlfTemplateId());
        serverInfo.setTlfRevision(apiItem.getTlfRevision());
        serverInfo.setSectionTablePath(apiItem.getSectionsFilePath());
        serverInfo.setSectionTableVersion(apiItem.getSectionsFileVersion());
        serverInfo.setTlfTablePath(apiItem.getTlfsFilePath());
        serverInfo.setTlfTableVersion(apiItem.getTlfsFileVersion());
        serverInfo.setResultTablePath(apiItem.getResultsFilePath());
        serverInfo.setResultTableVersion(apiItem.getResultsFileVersion());
        serverInfo.setResultDataSetTablePath(apiItem.getDataSetsFilePath());
        serverInfo.setResultDataSetTableVersion(apiItem.getDataSetsFileVersion());
        serverInfo.setSrcLocation(ClinicalHelper.toServerSourceLocation(apiItem.getImportFileSourceLocation()));
        serverInfo.setSourceType(ImportSourceType.DATASET);
        serverInfo.setUpdateAction(TlfHelper.toServerUpdateAction(apiItem.getUpdateAction()));
        return serverInfo;
    }

    private static ClinicalConstants.UpdateAction toServerUpdateAction(UpdateAction apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case ADD_NEW: {
                return ClinicalConstants.UpdateAction.ADD_NEW;
            }
            case REPLACE: {
                return ClinicalConstants.UpdateAction.REPLACE;
            }
        }
        throw new SystemException("Unmapped api study import update action: " + apiItem.name());
    }

    public static Set<String> toApiTlfDataSets(Set<TlfDataSet> serverItems) {
        HashSet<String> apiItems = new HashSet<String>();
        if (serverItems != null) {
            for (TlfDataSet serverItem : serverItems) {
                apiItems.add(serverItem.getPath());
            }
        }
        return apiItems;
    }

    public static List<AnalysisResult> toApiAnalysisResults(List<com.sas.lsaf.svcs.clinical.arm.client.AnalysisResult> serverItems) {
        ArrayList<AnalysisResult> apiItems = new ArrayList<AnalysisResult>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.arm.client.AnalysisResult serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(TlfHelper.toApiAnalysisResult(serverItem));
            }
        }
        return apiItems;
    }

    private static AnalysisResult toApiAnalysisResult(com.sas.lsaf.svcs.clinical.arm.client.AnalysisResult serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new AnalysisResult(serverItem.getId(), serverItem.getTlfId(), serverItem.getTlfIdentifier(), serverItem.getDescription(), serverItem.getReason(), serverItem.getPurpose(), serverItem.getAnalysisParameter(), serverItem.getDocumentReference(), serverItem.getDocumentation(), serverItem.getCode(), serverItem.getCodeContext(), serverItem.getTableJoinComment(), serverItem.getOrder(), serverItem.getDatasetCount());
    }

    public static List<AnalysisDataset> toApiAnalysisDatasets(List<com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset> serverItems) {
        ArrayList<AnalysisDataset> apiItems = new ArrayList<AnalysisDataset>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(TlfHelper.toApiAnalysisDataset(serverItem));
            }
        }
        return apiItems;
    }

    public static List<AnalysisDataset> toApiAnalysisDatasets(List<com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset> serverItems, String resultIdentifier) {
        ArrayList<AnalysisDataset> apiItems = new ArrayList<AnalysisDataset>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset serverItem : serverItems) {
                if (serverItem == null || serverItem.getResultIdentifier() == null || !serverItem.getResultIdentifier().equals(resultIdentifier)) continue;
                apiItems.add(TlfHelper.toApiAnalysisDataset(serverItem));
            }
        }
        return apiItems;
    }

    private static AnalysisDataset toApiAnalysisDataset(com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new AnalysisDataset(serverItem.getId(), serverItem.getResultId(), serverItem.getResultIdentifier(), serverItem.getName(), serverItem.getAnalysisColumns(), serverItem.getWhereClause());
    }
}

