/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.study.tlf.impl;

import com.sas.lsaf.clinical.model.AttributeMetadata;
import com.sas.lsaf.clinical.model.impl.ModelHelper;
import com.sas.lsaf.clinical.study.StudyNotFoundException;
import com.sas.lsaf.clinical.study.tlf.StudyTlfInfo;
import com.sas.lsaf.clinical.study.tlf.StudyTlfService;
import com.sas.lsaf.clinical.study.tlf.impl.StudyTlfHelper;
import com.sas.lsaf.clinical.tlf.AnalysisDataset;
import com.sas.lsaf.clinical.tlf.SectionNotFoundException;
import com.sas.lsaf.clinical.tlf.TlfNotFoundException;
import com.sas.lsaf.clinical.tlf.TlfUpdateException;
import com.sas.lsaf.clinical.tlf.impl.TlfHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.utils.impl.CollectionUtils;
import com.sas.lsaf.svcs.clinical.arm.client.AnalysisResult;
import com.sas.lsaf.svcs.clinical.arm.client.exception.AnalysisResultNotFoundException;
import com.sas.lsaf.svcs.clinical.model.client.exception.ModelNotFoundException;
import com.sas.lsaf.svcs.clinical.study.arm.client.StudyAnalysisDatasetInfo;
import com.sas.lsaf.svcs.clinical.study.arm.client.StudyAnalysisResultInfo;
import com.sas.lsaf.svcs.clinical.study.arm.client.StudyAnalysisResultsService;
import com.sas.lsaf.svcs.clinical.study.client.StudyService;
import com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfRoot;
import com.sas.lsaf.svcs.clinical.study.tlf.server.InternalStudyTlfService;
import com.sas.lsaf.svcs.clinical.tlf.client.SectionDescriptor;
import com.sas.lsaf.svcs.clinical.tlf.client.Tlf;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionUpdateException;
import com.sas.lsaf.svcs.core.utils.client.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public final class StudyTlfServiceImpl
implements StudyTlfService {
    private com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfService studyTlfService;
    private StudyService studyService;
    private InternalStudyTlfService internalStudyTlfService;
    private StudyAnalysisResultsService studyAnalysisResultsService;

    @Required
    public void setStudyTlfService(com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfService service) {
        this.studyTlfService = service;
    }

    @Required
    public void setStudyService(StudyService service) {
        this.studyService = service;
    }

    @Required
    public void setInternalStudyTlfService(InternalStudyTlfService service) {
        this.internalStudyTlfService = service;
    }

    @Required
    public void setStudyAnalysisResultsService(StudyAnalysisResultsService service) {
        this.studyAnalysisResultsService = service;
    }

    public StudyTlfInfo getTlfs(String studyId, String baseStandardName, String modelId) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        try {
            this.studyService.getStudyById(studyId);
            StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
            return StudyTlfHelper.toApiStudyTlfInfoWithRoot(this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, true), studyTlfRoot);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyTlfInfo setTlfs(StudyTlfInfo studyTlfInfo) throws StudyNotFoundException, TlfUpdateException {
        Assert.notNull((Object)studyTlfInfo, (String)"Tlf info is required.");
        Assert.hasText((String)studyTlfInfo.getStudyId(), (String)"Study id is required.");
        Assert.hasText((String)studyTlfInfo.getBaseStandardName(), (String)"Base standard name is required.");
        Assert.hasText((String)studyTlfInfo.getModelId(), (String)"Model id is required.");
        try {
            return StudyTlfHelper.toApiStudyTlfInfo(this.studyTlfService.setTlfs(StudyTlfHelper.toServerStudyTlfInfo(studyTlfInfo)));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (ModelNotFoundException | com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException | SectionUpdateException | com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfNotFoundException | com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfUpdateException e) {
            throw new TlfUpdateException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<AttributeMetadata> getTlfAttributeMetadata() throws com.sas.lsaf.clinical.model.ModelNotFoundException {
        try {
            return ModelHelper.toApiAttributeMetadataList(this.studyTlfService.getTlfAttributeMetadata());
        }
        catch (ModelNotFoundException e) {
            throw new com.sas.lsaf.clinical.model.ModelNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<com.sas.lsaf.clinical.tlf.SectionDescriptor> getStudySections(String studyId, String baseStandardName, String modelId) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        try {
            this.studyService.getStudyById(studyId);
            StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
            return StudyTlfHelper.toApiStudySectionDescriptors(this.studyTlfService.getSectionDescriptors(studyId, baseStandardName, modelId), this.studyTlfService, studyId, studyTlfRoot);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public com.sas.lsaf.clinical.tlf.SectionDescriptor getStudySectionDescriptorById(String studyId, String id) throws StudyNotFoundException, SectionNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)id, (String)"Section id is required.");
        try {
            return StudyTlfHelper.toApiStudySectionDescriptor(this.studyTlfService.getSectionById(studyId, id));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException e) {
            throw new SectionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<com.sas.lsaf.clinical.tlf.Tlf> getStudyTlfsBySectionId(String studyId, String baseStandardName, String modelId, String sectionId, boolean recurse) throws StudyNotFoundException, SectionNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        try {
            List<Object> tlfs = new ArrayList();
            com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo studyTlfInfo = this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, recurse);
            if (sectionId == null) {
                if (recurse) {
                    StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
                    return StudyTlfHelper.toApiTlfsWithRoot(studyTlfInfo.getTlfs(), studyTlfRoot);
                }
                tlfs = TlfHelper.toApiRootTlfs(studyTlfInfo.getTlfs());
            } else {
                studyTlfInfo = this.studyTlfService.getTlfsBySection(studyId, baseStandardName, modelId, sectionId, recurse);
                tlfs = TlfHelper.toApiTlfs(studyTlfInfo.getTlfs());
            }
            return tlfs;
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException e) {
            throw new SectionNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<com.sas.lsaf.clinical.tlf.Tlf> getStudyTlfsBySectionNameAndIdentifier(String studyId, String baseStandardName, String modelId, String sectionName, String sectionIdentifier, boolean recurse) throws StudyNotFoundException, SectionNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        try {
            com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo studyTlfInfo;
            List serverSections = this.studyTlfService.getSectionDescriptors(studyId, baseStandardName, modelId);
            SectionDescriptor section = null;
            boolean sectionSpecified = true;
            if (StringUtils.isEmpty((Object)sectionName) && StringUtils.isEmpty((Object)sectionIdentifier)) {
                sectionSpecified = false;
            } else {
                for (SectionDescriptor serverSection : serverSections) {
                    if (!serverSection.getName().equals(sectionName) || !(sectionIdentifier != null && sectionIdentifier.equals(serverSection.getSectionIdentifier()) || serverSection.getSectionIdentifier() != null && serverSection.getSectionIdentifier().equals(sectionIdentifier)) && (serverSection.getSectionIdentifier() != null || sectionIdentifier != null)) continue;
                    section = serverSection;
                    break;
                }
            }
            List<Object> tlfs = new ArrayList();
            if (!sectionSpecified) {
                studyTlfInfo = this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, recurse);
                if (recurse) {
                    StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
                    return StudyTlfHelper.toApiTlfsWithRoot(studyTlfInfo.getTlfs(), studyTlfRoot);
                }
                tlfs = TlfHelper.toApiRootTlfs(studyTlfInfo.getTlfs());
            } else if (section != null) {
                studyTlfInfo = this.studyTlfService.getTlfsBySection(studyId, baseStandardName, modelId, section.getId(), recurse);
                tlfs = TlfHelper.toApiTlfs(studyTlfInfo.getTlfs());
            } else {
                throw new SectionNotFoundException("Section does not exist.");
            }
            return tlfs;
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException e) {
            throw new SectionNotFoundException(e.getLocalizedMessage());
        }
        catch (SectionNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<com.sas.lsaf.clinical.tlf.AnalysisResult> getAnalysisResultsByStudyTlfId(String studyId, String baseStandardName, String modelId, String tlfId) throws StudyNotFoundException, TlfNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.hasText((String)tlfId, (String)"TLF id is required.");
        try {
            StudyAnalysisResultInfo resultsInfo = this.studyAnalysisResultsService.getAnalysisResultsByTlfIds(studyId, baseStandardName, modelId, CollectionUtils.asSet((Object[])new String[]{tlfId}));
            return TlfHelper.toApiAnalysisResults(resultsInfo.getResults());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfNotFoundException e) {
            throw new TlfNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<com.sas.lsaf.clinical.tlf.AnalysisResult> getAnalysisResultsByStudyTlfIdentifier(String studyId, String baseStandardName, String modelId, String tlfIdentifier) throws StudyNotFoundException, TlfNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.hasText((String)tlfIdentifier, (String)"TLF identifier is required.");
        try {
            com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo studyTlfInfo = this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, true);
            com.sas.lsaf.clinical.tlf.Tlf tlf = StudyTlfHelper.toApiStudyTlfByTlfIdentifier(studyTlfInfo.getTlfs(), tlfIdentifier);
            if (tlf == null) {
                throw new TlfNotFoundException("TLF does not exist.");
            }
            StudyAnalysisResultInfo resultsInfo = this.studyAnalysisResultsService.getAnalysisResultsByTlfIds(studyId, baseStandardName, modelId, CollectionUtils.asSet((Object[])new String[]{tlf.getId()}));
            return TlfHelper.toApiAnalysisResults(resultsInfo.getResults());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfNotFoundException e) {
            throw new TlfNotFoundException(e.getLocalizedMessage());
        }
        catch (TlfNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<AnalysisDataset> getAnalysisDatasetsByResultId(String studyId, String baseStandardName, String modelId, String resultId) throws StudyNotFoundException, com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.hasText((String)resultId, (String)"Result id is required.");
        try {
            StudyAnalysisDatasetInfo dataSetInfo = this.studyAnalysisResultsService.getAnalysisDatasetsByResultIds(studyId, baseStandardName, modelId, resultId == null ? new HashSet() : CollectionUtils.asSet((Object[])new String[]{resultId}));
            return TlfHelper.toApiAnalysisDatasets(dataSetInfo.getDatasets());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (AnalysisResultNotFoundException e) {
            throw new com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<AnalysisDataset> getAnalysisDatasetsByResultIdentifier(String studyId, String baseStandardName, String modelId, String resultIdentifier) throws StudyNotFoundException, com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.hasText((String)resultIdentifier, (String)"Result identifier is required.");
        try {
            com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo studyTlfInfo = this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, true);
            Set<String> tlfIds = this.getTlfIds(studyTlfInfo.getTlfs());
            StudyAnalysisResultInfo resultInfo = this.studyAnalysisResultsService.getAnalysisResultsByTlfIds(studyId, baseStandardName, modelId, tlfIds);
            List<AnalysisResult> serverResults = this.getResultIdWithResultIdentifier(resultInfo.getResults(), resultIdentifier);
            if (serverResults == null || serverResults.isEmpty()) {
                throw new com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException("Analysis result could not be found.");
            }
            ArrayList<com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset> serverDatasets = new ArrayList<com.sas.lsaf.svcs.clinical.arm.client.AnalysisDataset>();
            for (AnalysisResult serverResult : serverResults) {
                StudyAnalysisDatasetInfo dataSetInfo = this.studyAnalysisResultsService.getAnalysisDatasetsByResultIdentifier(studyId, baseStandardName, modelId, serverResult.getTlfIdentifier(), resultIdentifier);
                serverDatasets.addAll(dataSetInfo.getDatasets());
            }
            return TlfHelper.toApiAnalysisDatasets(serverDatasets, resultIdentifier);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (AnalysisResultNotFoundException e) {
            throw new com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public com.sas.lsaf.clinical.tlf.Tlf getStudyTlfByTlfIdentifier(String studyId, String baseStandardName, String modelId, String tlfIdentifier) throws StudyNotFoundException, TlfNotFoundException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.hasText((String)tlfIdentifier, (String)"Tlf identifier is required.");
        try {
            this.studyService.getStudyById(studyId);
            StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
            com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo studyTlfInfo = this.studyTlfService.getTlfs(studyId, baseStandardName, modelId, true);
            com.sas.lsaf.clinical.tlf.Tlf tlf = StudyTlfHelper.toApiStudyTlfByTlfIdentifier(studyTlfInfo.getTlfs(), tlfIdentifier, studyTlfRoot);
            if (tlf == null) {
                throw new TlfNotFoundException("TLF does not exist.");
            }
            return tlf;
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (TlfNotFoundException e) {
            throw new TlfNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private Set<String> getTlfIds(List<Tlf> tlfs) {
        HashSet<String> tlfIds = new HashSet<String>();
        if (tlfs != null) {
            for (Tlf tlf : tlfs) {
                tlfIds.add(tlf.getId());
            }
        }
        return tlfIds;
    }

    private List<AnalysisResult> getResultIdWithResultIdentifier(List<AnalysisResult> results, String resultIdentifier) {
        ArrayList<AnalysisResult> serverResults = new ArrayList<AnalysisResult>();
        if (results != null) {
            for (AnalysisResult result : results) {
                if (!result.getDocumentReference().equalsIgnoreCase(resultIdentifier)) continue;
                serverResults.add(result);
            }
        }
        return serverResults;
    }
}

