/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.study.tlf.impl;

import com.sas.lsaf.clinical.study.tlf.StudyTlfInfo;
import com.sas.lsaf.clinical.tlf.impl.TlfHelper;
import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException;
import com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfRoot;
import com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfService;
import com.sas.lsaf.svcs.clinical.tlf.client.Section;
import com.sas.lsaf.svcs.clinical.tlf.client.SectionDescriptor;
import com.sas.lsaf.svcs.clinical.tlf.client.Tlf;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException;
import com.sas.lsaf.svcs.core.common.client.Identifiable;
import java.util.ArrayList;
import java.util.List;

public abstract class StudyTlfHelper {
    public static StudyTlfInfo toApiStudyTlfInfo(com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo serverItem) {
        if (serverItem == null) {
            return null;
        }
        StudyTlfInfo apiItem = new StudyTlfInfo(serverItem.getStudyId(), serverItem.getBaseStandardName(), serverItem.getModelId(), TlfHelper.toApiTlfs(serverItem.getTlfs()), serverItem.getRevision());
        return apiItem;
    }

    public static StudyTlfInfo toApiStudyTlfInfoWithRoot(com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo serverItem, StudyTlfRoot studyTlfRoot) {
        if (serverItem == null) {
            return null;
        }
        StudyTlfInfo apiItem = new StudyTlfInfo(serverItem.getStudyId(), serverItem.getBaseStandardName(), serverItem.getModelId(), StudyTlfHelper.toApiTlfsWithRoot(serverItem.getTlfs(), studyTlfRoot), serverItem.getRevision());
        return apiItem;
    }

    public static com.sas.lsaf.clinical.tlf.Tlf toApiStudyTlfByTlfIdentifier(List<Tlf> tlfs, String tlfIdentifier) {
        if (tlfIdentifier == null || tlfs == null) {
            return null;
        }
        for (Tlf tlf : tlfs) {
            if (!tlfIdentifier.equals(tlf.getIdentifier())) continue;
            return TlfHelper.toApiTlf(tlf);
        }
        return null;
    }

    public static com.sas.lsaf.clinical.tlf.Tlf toApiStudyTlfByTlfIdentifier(Tlf tlf, StudyTlfRoot studyTlfRoot) {
        if (tlf == null) {
            return null;
        }
        return StudyTlfHelper.toApiTlfWithRoot(tlf, studyTlfRoot);
    }

    public static com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo toServerStudyTlfInfo(StudyTlfInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo serverItem = new com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfInfo(apiItem.getStudyId(), apiItem.getBaseStandardName(), apiItem.getModelId());
        serverItem.setTlfs(TlfHelper.toServerTlfs(apiItem.getTlfs()));
        serverItem.setRevision(apiItem.getRevision());
        return serverItem;
    }

    public static List<com.sas.lsaf.clinical.tlf.SectionDescriptor> toApiStudySectionDescriptors(List<SectionDescriptor> serverItems, StudyTlfRoot studyTlfRoot) {
        ArrayList<com.sas.lsaf.clinical.tlf.SectionDescriptor> apiItems = new ArrayList<com.sas.lsaf.clinical.tlf.SectionDescriptor>();
        if (serverItems != null) {
            for (SectionDescriptor serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(StudyTlfHelper.toApiStudySectionDescriptorWithRoot(serverItem, studyTlfRoot));
            }
        }
        return apiItems;
    }

    public static List<com.sas.lsaf.clinical.tlf.SectionDescriptor> toApiStudySectionDescriptors(List<SectionDescriptor> serverItems, StudyTlfService studyTlfService, String studyId, StudyTlfRoot studyTlfRoot) throws SectionNotFoundException, StudyNotFoundException {
        ArrayList<com.sas.lsaf.clinical.tlf.SectionDescriptor> apiItems = new ArrayList<com.sas.lsaf.clinical.tlf.SectionDescriptor>();
        if (serverItems != null) {
            for (SectionDescriptor serverItem : serverItems) {
                if (serverItem == null) continue;
                Section serverSection = studyTlfService.getSectionById(studyId, serverItem.getId());
                apiItems.add(StudyTlfHelper.toApiStudySectionDescriptorWithRoot((SectionDescriptor)serverSection, studyTlfRoot));
            }
        }
        return apiItems;
    }

    private static com.sas.lsaf.clinical.tlf.SectionDescriptor toApiStudySectionDescriptorWithRoot(SectionDescriptor serverItem, StudyTlfRoot studyTlfRoot) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.clinical.tlf.SectionDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getSectionIdentifier(), serverItem.getDescription(), StudyTlfHelper.toApiParent(serverItem.getParent(), studyTlfRoot));
    }

    private static com.sas.lsaf.core.Identifiable toApiParent(Identifiable parent, StudyTlfRoot studyTlfRoot) {
        if (parent == null) {
            return new ObjectIdentity(studyTlfRoot.getTypeId(), studyTlfRoot.getId());
        }
        return new ObjectIdentity(parent.getTypeId(), parent.getId());
    }

    public static com.sas.lsaf.clinical.tlf.SectionDescriptor toApiStudySectionDescriptor(Section serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.clinical.tlf.SectionDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getSectionIdentifier(), serverItem.getDescription(), (com.sas.lsaf.core.Identifiable)(serverItem.getParent() != null ? new ObjectIdentity(serverItem.getParent().getTypeId(), serverItem.getParent().getId()) : null));
    }

    public static com.sas.lsaf.clinical.tlf.SectionDescriptor toApiStudySectionDescriptor(SectionDescriptor serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.clinical.tlf.SectionDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getSectionIdentifier(), serverItem.getDescription(), TlfHelper.toApiTlfParent((Identifiable)serverItem));
    }

    public static List<com.sas.lsaf.clinical.tlf.Tlf> toApiTlfsWithRoot(List<Tlf> serverItems, StudyTlfRoot studyTlfRoot) {
        ArrayList<com.sas.lsaf.clinical.tlf.Tlf> apiItems = new ArrayList<com.sas.lsaf.clinical.tlf.Tlf>();
        if (serverItems != null) {
            for (Tlf serverItem : serverItems) {
                if (serverItem == null) continue;
                apiItems.add(StudyTlfHelper.toApiTlfWithRoot(serverItem, studyTlfRoot));
            }
        }
        return apiItems;
    }

    public static com.sas.lsaf.clinical.tlf.Tlf toApiTlfWithRoot(Tlf serverItem, StudyTlfRoot studyTlfRoot) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.clinical.tlf.Tlf(serverItem.getId(), serverItem.getTypeId(), serverItem.getName(), serverItem.getIdentifier(), (com.sas.lsaf.core.Identifiable)(serverItem.getParent() == null ? new ObjectIdentity(studyTlfRoot.getTypeId(), studyTlfRoot.getId()) : new ObjectIdentity(serverItem.getParent().getTypeId(), serverItem.getParent().getId())), serverItem.getOrder(), serverItem.getResultCount(), TlfHelper.toApiAttributes(serverItem.getAttributes()), serverItem.isEnableAutoFlow());
    }

    public static com.sas.lsaf.clinical.tlf.Tlf toApiStudyTlfByTlfIdentifier(List<Tlf> tlfs, String tlfIdentifier, StudyTlfRoot studyTlfRoot) {
        if (tlfIdentifier == null || tlfs == null) {
            return null;
        }
        for (Tlf tlf : tlfs) {
            if (!tlfIdentifier.equals(tlf.getIdentifier())) continue;
            return StudyTlfHelper.toApiTlfWithRoot(tlf, studyTlfRoot);
        }
        return null;
    }
}

