/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.study.impl;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.common.ImportException;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.clinical.dictionary.impl.DictionaryHelper;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.clinical.standards.impl.StandardsHelper;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationExistsException;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationNotFoundException;
import com.sas.lsaf.clinical.study.StandardAssociationExistsException;
import com.sas.lsaf.clinical.study.StandardAssociationNotFoundException;
import com.sas.lsaf.clinical.study.Study;
import com.sas.lsaf.clinical.study.StudyCodeListUpdateException;
import com.sas.lsaf.clinical.study.StudyComponent;
import com.sas.lsaf.clinical.study.StudyComponentEditException;
import com.sas.lsaf.clinical.study.StudyComponentEditableStatus;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.study.StudyDictionaryException;
import com.sas.lsaf.clinical.study.StudyNotFoundException;
import com.sas.lsaf.clinical.study.StudyService;
import com.sas.lsaf.clinical.study.StudyStandardReferencedException;
import com.sas.lsaf.clinical.study.StudySupportingDocumentUpdateException;
import com.sas.lsaf.clinical.study.StudyTableUpdateException;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.clinical.study.StudyUpdateException;
import com.sas.lsaf.clinical.study.StudyUpdateResult;
import com.sas.lsaf.clinical.study.StudyValueLevelMetadataUpdateException;
import com.sas.lsaf.clinical.study.impl.StudyHelper;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.clinical.tlf.TlfUpdateException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.ValidationMessage;
import com.sas.lsaf.core.ValidationResult;
import com.sas.lsaf.core.utils.impl.PathUtils;
import com.sas.lsaf.svcs.clinical.arm.client.exception.AnalysisResultNotFoundException;
import com.sas.lsaf.svcs.clinical.arm.client.exception.AnalysisResultsUpdateException;
import com.sas.lsaf.svcs.clinical.common.client.exception.ClinicalParseException;
import com.sas.lsaf.svcs.clinical.common.client.exception.ValidationReportException;
import com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionaryService;
import com.sas.lsaf.svcs.clinical.dictionary.client.exception.DictionaryImportException;
import com.sas.lsaf.svcs.clinical.dictionary.client.exception.DictionaryNotFoundException;
import com.sas.lsaf.svcs.clinical.model.client.exception.ModelNotFoundException;
import com.sas.lsaf.svcs.clinical.standards.client.exception.StandardNotFoundException;
import com.sas.lsaf.svcs.clinical.study.arm.client.StudyAnalysisResultsService;
import com.sas.lsaf.svcs.clinical.study.client.StudyUpdateInfo;
import com.sas.lsaf.svcs.clinical.study.client.exception.StudyIdNotFoundException;
import com.sas.lsaf.svcs.clinical.study.dictionary.client.StudyDictionaryService;
import com.sas.lsaf.svcs.clinical.study.submission.client.StudySubmissionService;
import com.sas.lsaf.svcs.clinical.study.supportingdocument.client.StudySupportingDocumentService;
import com.sas.lsaf.svcs.clinical.study.table.client.StudyTableDataSet;
import com.sas.lsaf.svcs.clinical.study.table.client.StudyTableService;
import com.sas.lsaf.svcs.clinical.study.tlf.client.StudyTlfRoot;
import com.sas.lsaf.svcs.clinical.study.tlf.server.InternalStudyTlfService;
import com.sas.lsaf.svcs.clinical.study.vlm.client.StudyVlmService;
import com.sas.lsaf.svcs.clinical.supportingdocument.client.exception.SupportingDocumentUpdateException;
import com.sas.lsaf.svcs.clinical.tlf.client.TlfDataSet;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionNotFoundException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.SectionUpdateException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfImportException;
import com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfNotFoundException;
import com.sas.lsaf.svcs.clinical.vlm.client.exception.VlmUpdateException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import com.sas.lsaf.svcs.core.event.server.EventListenerException;
import com.sas.lsaf.svcs.core.lock.client.exception.LockException;
import com.sas.lsaf.svcs.core.lock.client.exception.LockNotFoundException;
import com.sas.lsaf.svcs.core.lock.client.exception.UnlockException;
import com.sas.lsaf.svcs.core.validation.server.ValidationUtils;
import com.sas.lsaf.svcs.execution.session.client.exception.ConnectionException;
import com.sas.lsaf.svcs.security.authentication.server.ServerSecurityContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class StudyServiceImpl
implements StudyService {
    private com.sas.lsaf.svcs.clinical.study.client.StudyService studyService;
    private ExternalDictionaryService externalDictionaryService;
    private StudyTableService studyTableService;
    private StudySupportingDocumentService studySupportingDocumentService;
    private StudyVlmService studyVlmService;
    private StudyDictionaryService studyDictionaryService;
    private StudyAnalysisResultsService studyAnalysisResultsService;
    private InternalStudyTlfService internalStudyTlfService;
    private StudySubmissionService studySubmissionService;

    @Required
    public void setStudyService(com.sas.lsaf.svcs.clinical.study.client.StudyService service) {
        this.studyService = service;
    }

    @Required
    public void setExternalDictionaryService(ExternalDictionaryService service) {
        this.externalDictionaryService = service;
    }

    @Required
    public void setStudyTableService(StudyTableService studyTableService) {
        this.studyTableService = studyTableService;
    }

    @Required
    public void setStudyVlmService(StudyVlmService studyVlmService) {
        this.studyVlmService = studyVlmService;
    }

    @Required
    public void setStudySupportingDocumentService(StudySupportingDocumentService studySupportingDocumentService) {
        this.studySupportingDocumentService = studySupportingDocumentService;
    }

    @Required
    public void setStudyDictionaryService(StudyDictionaryService studyDictionaryService) {
        this.studyDictionaryService = studyDictionaryService;
    }

    @Required
    public void setStudyAnalysisResultsService(StudyAnalysisResultsService studyAnalysisResultsService) {
        this.studyAnalysisResultsService = studyAnalysisResultsService;
    }

    @Required
    public void setInternalStudyTlfService(InternalStudyTlfService internalStudyTlfService) {
        this.internalStudyTlfService = internalStudyTlfService;
    }

    @Required
    public void setStudySubmissionService(StudySubmissionService service) {
        this.studySubmissionService = service;
    }

    public Set<Study> getStudiesAssociatedWithStandard(String standardId) throws com.sas.lsaf.clinical.standards.StandardNotFoundException {
        Assert.hasText((String)standardId, (String)"Standard id is required.");
        try {
            return StudyHelper.toApiStudies(this.studyService.getStudiesAssociatedWithStandard(standardId));
        }
        catch (StandardNotFoundException e) {
            throw new com.sas.lsaf.clinical.standards.StandardNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Study> getStudiesAssociatedWithDictionary(String dictionaryId) throws com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException {
        Assert.hasText((String)dictionaryId, (String)"Dictionary id is required.");
        try {
            return StudyHelper.toApiStudies(this.studyService.getStudiesAssociatedWithDictionary(dictionaryId));
        }
        catch (DictionaryNotFoundException e) {
            throw new com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<Study> getStudiesAssociatedWithExternalDictionary(String externalDictionaryId) throws com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException {
        Assert.hasText((String)externalDictionaryId, (String)"External dictionary id is required.");
        try {
            this.externalDictionaryService.getExternalDictionaryById(externalDictionaryId);
            return StudyHelper.toApiStudies(this.studyService.getStudiesAssociatedWithExternalDictionary(externalDictionaryId));
        }
        catch (DictionaryNotFoundException e) {
            throw new com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void associateStandards(String studyId, Set<String> standardIds) throws StudyNotFoundException, com.sas.lsaf.clinical.standards.StandardNotFoundException, StandardAssociationExistsException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notEmpty(standardIds, (String)"Standard identifiers are required.");
        try {
            this.studyService.addStandards(studyId, standardIds);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (StandardNotFoundException e) {
            throw new com.sas.lsaf.clinical.standards.StandardNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StandardAssociationExistsException e) {
            throw new StandardAssociationExistsException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void disassociateStandards(String studyId, Set<String> standardIds) throws StudyNotFoundException, StandardAssociationNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notEmpty(standardIds, (String)"Standard identifiers are required.");
        try {
            this.checkForReferencedComponentsOfStandard(studyId, standardIds);
            this.studyService.removeStandards(studyId, standardIds);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StandardAssociationNotFoundException e) {
            throw new StandardAssociationNotFoundException(e.getLocalizedMessage());
        }
        catch (StudyStandardReferencedException | EventListenerException e) {
            throw new StudyStandardReferencedException("Standard cannot be removed because one or more components within the study are referencing that standard.");
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void disassociateExternalDictionaries(String studyId, Set<String> externalDictionaryIds) throws StudyNotFoundException, ExternalDictionaryAssociationNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notEmpty(externalDictionaryIds, (String)"External dictionaries are required.");
        try {
            this.studyService.removeExternalDictionariesForStudy(studyId, externalDictionaryIds);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.ExternalDictionaryAssociationNotFoundException e) {
            throw new ExternalDictionaryAssociationNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void associateExternalDictionaries(String studyId, Set<String> externalDictionaryIds) throws StudyNotFoundException, com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException, ExternalDictionaryAssociationExistsException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notEmpty(externalDictionaryIds, (String)"External dictionary identifiers are required.");
        try {
            this.studyService.addExternalDictionariesForStudy(studyId, externalDictionaryIds);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (DictionaryNotFoundException e) {
            throw new com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.ExternalDictionaryAssociationExistsException e) {
            throw new ExternalDictionaryAssociationExistsException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void associateDictionaries(String studyId, List<String> dictionaryIds) throws StudyNotFoundException, com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException, StudyDictionaryException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull(dictionaryIds, (String)"Dictionary ids are required.");
        try {
            this.studyService.setDictionariesForStudy(studyId, dictionaryIds);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (DictionaryNotFoundException e) {
            throw new com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.dictionary.client.exception.StudyDictionaryException e) {
            throw new StudyDictionaryException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<StandardDescriptor> getStandardsAssociatedWithStudy(String studyId) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        try {
            return StandardsHelper.toApiStandardDescriptors(new ArrayList<com.sas.lsaf.svcs.clinical.standards.client.StandardDescriptor>(this.studyService.getStandardsAssociatedWithStudy(studyId)));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public List<DictionaryDescriptor> getDictionariesAssociatedWithStudy(String studyId) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        try {
            return DictionaryHelper.toApiDictionaryDescriptors(this.studyService.getDictionariesAssociatedWithStudy(studyId));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ExternalDictionary> getExternalDictionariesAssociatedWithStudy(String studyId) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        try {
            return DictionaryHelper.toApiExternalDictionaries(this.studyService.getExternalDictionariesForStudy(studyId));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyComponentEditableStatus setStudyComponentEditableByCurrentUser(String studyId, StudyComponent studyComponent) throws StudyNotFoundException, StudyComponentEditException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)studyComponent, (String)"Study component is required.");
        try {
            return StudyHelper.toApiStudyComponentLock(this.studyService.lockStudyComponent(studyId, StudyHelper.toServerStudyComponent(studyComponent)));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (LockException e) {
            throw new StudyComponentEditException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyComponentEditableStatus setStudyComponentAsNotEditable(String studyId, StudyComponent studyComponent) throws StudyNotFoundException, StudyComponentEditException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)studyComponent, (String)"Study component is required.");
        try {
            this.studyService.unlockStudyComponent(studyId, StudyHelper.toServerStudyComponent(studyComponent));
            return StudyHelper.toApiStudyComponentLock(this.studyService.getStudyComponentLock(studyId, StudyHelper.toServerStudyComponent(studyComponent)));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (UnlockException e) {
            throw new StudyComponentEditException(e.getLocalizedMessage());
        }
        catch (LockNotFoundException e) {
            return new StudyComponentEditableStatus(false, null, null);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyComponentEditableStatus getStudyComponentEditableStatus(String studyId, StudyComponent studyComponent) throws StudyNotFoundException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)studyComponent, (String)"Study component is required.");
        try {
            return StudyHelper.toApiStudyComponentLock(this.studyService.getStudyComponentLock(studyId, StudyHelper.toServerStudyComponent(studyComponent)));
        }
        catch (StudyIdNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (LockNotFoundException e) {
            return new StudyComponentEditableStatus(false, null, null);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportStudyStandardsToDataSet(String studyId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyService.exportStandardsAsDataSet(studyId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public void importStudyDetails(String studyId, StudyComponentImportInfo importInfo) throws StudyNotFoundException, StudyUpdateException, ImportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.notNull((Object)importInfo, (String)"Study import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.hasText((String)importInfo.getImportFilePath(), (String)"Import file path is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getImportFilePath()), (String)"Import file path for study details must be to a data set.");
        if (importInfo.getUpdateAction() != null && !UpdateAction.REPLACE.equals((Object)importInfo.getUpdateAction())) {
            throw new IllegalArgumentException("Import action " + importInfo.getUpdateAction().name() + " is not supported for study details. " + UpdateAction.REPLACE.name() + " is the only supported action.");
        }
        try {
            StudyUpdateInfo info = new StudyUpdateInfo(studyId, importInfo.getImportFilePath(), importInfo.getImportFileVersion(), ClinicalHelper.toServerSourceLocation(importInfo.getImportFileSourceLocation()));
            this.studyService.updateStudyFromFile(info);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.StudyUpdateException e) {
            if (e.getMessage().contains("not updated because no differences were found")) {
                return;
            }
            throw new StudyUpdateException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | RepositoryException | WorkspaceException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyUpdateResult importStudyCodeLists(String studyId, StudyComponentImportInfo importInfo, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, StudyCodeListUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.notNull((Object)importInfo, (String)"Study import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.hasText((String)importInfo.getImportFilePath(), (String)"Import file path is required.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Update action is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getImportFilePath()), (String)"Import file path for study code lists must be to a data set.");
        try {
            return ClinicalHelper.toApiStudyUpdateResult((com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult)this.studyDictionaryService.updateStudyCodeListsFromFile(studyId, StudyHelper.toServerStudyMetadataUpdateInfo(importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | DictionaryImportException | RepositoryException | WorkspaceException | ConnectionException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.study.dictionary.client.exception.StudyDictionaryException e) {
            throw new StudyCodeListUpdateException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportStudyDictionariesToDataSet(String studyId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyService.exportControlTerminologiesAsDataSet(studyId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportStudyCodeListsToDataSet(String studyId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyDictionaryService.exportStudyDictionaryToDataSet(studyId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportStudyDetailsToDataSet(String studyId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyService.exportStudyDetailsToDataSet(studyId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportStudyExternalDictionariesToDataSet(String studyId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyService.exportExternalDictionariesAsDataSet(studyId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<String> exportStudyTablesToDataSets(String studyId, String baseStandardName, String modelId, BatchFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return StudyHelper.toApiStudyTablePaths(this.studyTableService.exportTablesByBaseStandardAndModelToDataSets(studyId, baseStandardName, modelId, ClinicalHelper.toServerBatchFileCreateInfo(info)));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | ModelNotFoundException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyUpdateResult importStudyTables(String studyId, String standardId, StudyTablesImportInfo importInfo, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, com.sas.lsaf.clinical.standards.StandardNotFoundException, StudyTableUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)standardId, (String)"Standard id is required.");
        Assert.notNull((Object)importInfo, (String)"Study table import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.hasText((String)importInfo.getTablesImportFilePath(), (String)"Study tables import file path is required.");
        Assert.hasText((String)importInfo.getColumnsImportFilePath(), (String)"Study columns import file path is required.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Update action is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getTablesImportFilePath()), (String)"Import file path for study tables must be to a data set.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getColumnsImportFilePath()), (String)"Import file path for study table columns must be to a data set.");
        try {
            return ClinicalHelper.toApiStudyUpdateResult((com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult)this.studyTableService.updateTablesFromFile(studyId, standardId, StudyHelper.toServerStudyTablesFileInfo(importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (StandardNotFoundException e) {
            throw new com.sas.lsaf.clinical.standards.StandardNotFoundException(e.getLocalizedMessage());
        }
        catch (ModelNotFoundException | com.sas.lsaf.svcs.clinical.study.table.client.exception.StudyTableUpdateException e) {
            throw new StudyTableUpdateException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | RepositoryException | WorkspaceException | IOException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportZeroObservationDataSetsForStudyTables(String studyId, String baseStandardName, String modelId, BatchFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        PathUtils.validatePath((String)info.getPath());
        try {
            String tablePath;
            this.assertStudyHasTables(studyId, baseStandardName, modelId);
            Set tables = this.studyTableService.exportZeroObsDataSetsForAllStudyTablesByBaseStandardAndModel(studyId, baseStandardName, modelId, ClinicalHelper.toServerBatchFileCreateInfo(info));
            if (tables != null && !tables.isEmpty() && (tablePath = ((StudyTableDataSet)tables.iterator().next()).getPath()) != null) {
                return PathUtils.getParentPath((String)tablePath);
            }
            return null;
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | ModelNotFoundException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportSupportingDocumentsToDataSet(String studyId, String baseStandardName, String modelId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studySupportingDocumentService.exportSupportingDocumentsToDataSet(studyId, baseStandardName, modelId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyUpdateResult importStudySupportingDocuments(String studyId, String baseStandardName, String modelId, StudyComponentImportInfo importInfo, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, StudySupportingDocumentUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)importInfo, (String)"Study supporting document import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.hasText((String)importInfo.getImportFilePath(), (String)"Import file path is required.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Update action is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getImportFilePath()), (String)"Import file path for study supporting documents must be to a data set.");
        try {
            return ClinicalHelper.toApiStudyUpdateResult((com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult)this.studySupportingDocumentService.updateSupportingDocumentsFromFile(studyId, baseStandardName, modelId, StudyHelper.toServerStudyMetadataUpdateInfo(importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (ModelNotFoundException | SupportingDocumentUpdateException e) {
            throw new StudySupportingDocumentUpdateException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | RepositoryException | WorkspaceException | IOException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportValueLevelMetadataToDataSet(String studyId, String baseStandardName, String modelId, ExportFileCreateInfo info) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.studyVlmService.exportVlmToDataSet(studyId, baseStandardName, modelId, ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyUpdateResult importStudyValueLevelMetadata(String studyId, String baseStandardName, String modelId, StudyComponentImportInfo importInfo, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, StudyValueLevelMetadataUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)importInfo, (String)"Study value level metadata import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.hasText((String)importInfo.getImportFilePath(), (String)"Import file path is required.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Update action is required.");
        if (importInfo.getImportFilePath() != null && !importInfo.getImportFilePath().isEmpty()) {
            Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getImportFilePath()), (String)"Import file path for study vlm must be to a data set.");
        }
        try {
            return ClinicalHelper.toApiStudyUpdateResult((com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult)this.studyVlmService.updateVlmFromFile(studyId, baseStandardName, modelId, StudyHelper.toServerStudyMetadataUpdateInfo(importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (ModelNotFoundException | VlmUpdateException e) {
            throw new StudyValueLevelMetadataUpdateException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | RepositoryException | WorkspaceException | IOException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public StudyUpdateResult importStudyTlfs(String studyId, String baseStandardName, String modelId, TlfImportInfo importInfo, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, TlfUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)importInfo, (String)"TLF import info is required.");
        Assert.notNull((Object)importInfo.getImportFileSourceLocation(), (String)"Import file source location is required.");
        Assert.notNull((Object)importInfo.getUpdateAction(), (String)"Update action is required.");
        Assert.hasText((String)importInfo.getSectionsFilePath(), (String)"Sections file path is required.");
        Assert.hasText((String)importInfo.getTlfsFilePath(), (String)"TLF file path is required.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getSectionsFilePath()), (String)"Import file path for study sections must be to a data set.");
        Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getTlfsFilePath()), (String)"Import file path for study TLF's must be to a data set.");
        if (importInfo.getResultsFilePath() != null && !importInfo.getResultsFilePath().isEmpty()) {
            Assert.isTrue((boolean)baseStandardName.equals("ADaM"), (String)"A results import file was specified but the metadata is not supported for non-analysis standards");
            Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getResultsFilePath()), (String)"Import file path for study analysis results must be to a data set.");
            Assert.isTrue((importInfo.getDataSetsFilePath() != null && !importInfo.getDataSetsFilePath().isEmpty() ? 1 : 0) != 0, (String)"Import file path is required for data sets when a path for analysis results is provided.");
        }
        if (importInfo.getDataSetsFilePath() != null && !importInfo.getDataSetsFilePath().isEmpty()) {
            Assert.isTrue((boolean)baseStandardName.equals("ADaM"), (String)"A data sets import file was specified but the metadata is not supported for non-analysis standards");
            Assert.isTrue((boolean)ValidationUtils.isSasDatasetFileResource((String)importInfo.getDataSetsFilePath()), (String)"Import file path for study analysis result data sets must be to a data set.");
        }
        try {
            this.studyService.getStudyById(studyId);
            StudyTlfRoot studyTlfRoot = this.internalStudyTlfService.internalGetStudyTlfRoot(studyId, baseStandardName, modelId);
            long tlfRevision = studyTlfRoot != null ? studyTlfRoot.getRevision() : -1L;
            return ClinicalHelper.toApiStudyUpdateResult((com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult)this.studyAnalysisResultsService.updateTlfsFromFile(StudyHelper.toServerStudyTlfUpdateInfo(studyId, baseStandardName, modelId, tlfRevision, importInfo), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (AnalysisResultNotFoundException | AnalysisResultsUpdateException | ModelNotFoundException | SectionNotFoundException | SectionUpdateException | TlfNotFoundException | com.sas.lsaf.svcs.clinical.tlf.client.exception.TlfUpdateException e) {
            throw new TlfUpdateException(e.getLocalizedMessage());
        }
        catch (ClinicalParseException | TlfImportException | RepositoryException | WorkspaceException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<String> exportTlfsToDataSets(String studyId, String baseStandardName, String modelId, BatchFileCreateInfo info, boolean includeAnalysisResultsAndDatasets) throws StudyNotFoundException, ExportException {
        Assert.hasText((String)studyId, (String)"Study identifier is required.");
        Assert.hasText((String)baseStandardName, (String)"Base standard name is required.");
        Assert.hasText((String)modelId, (String)"Model id is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        HashSet<String> paths = new HashSet<String>();
        try {
            Set tlfDataSets = this.studyAnalysisResultsService.exportTlfsAsDataSets(studyId, baseStandardName, modelId, ClinicalHelper.toServerBatchFileCreateInfo(info), includeAnalysisResultsAndDatasets);
            for (TlfDataSet ds : tlfDataSets) {
                paths.add(ds.getPath());
            }
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (AnalysisResultNotFoundException | com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | ModelNotFoundException | SectionNotFoundException | SectionUpdateException | TlfNotFoundException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return paths;
    }

    public StudyUpdateResult importStudyFromDefine(String studyId, String standardId, String definePath, String defineVersion, SourceLocation defineSourceLocation, UpdateAction codeListUpdateAction, ExportFileCreateInfo validationInfo) throws StudyNotFoundException, com.sas.lsaf.clinical.standards.StandardNotFoundException, StudyUpdateException, ImportException, com.sas.lsaf.clinical.common.ValidationReportException {
        Assert.hasText((String)studyId, (String)"Study id is required.");
        Assert.hasText((String)standardId, (String)"Standard id is required.");
        Assert.hasText((String)definePath, (String)"Import define path is required.");
        Assert.notNull((Object)defineSourceLocation, (String)"Import define source location is required.");
        Assert.notNull((Object)codeListUpdateAction, (String)"Code list update action is required.");
        Assert.isTrue((boolean)ValidationUtils.isXMLFileResource((String)definePath), (String)"Import Define XML file path must be to an XML file.");
        try {
            return ClinicalHelper.toApiStudyUpdateResult(this.studySubmissionService.updateStudyFromDefine(studyId, standardId, definePath, defineVersion, ClinicalHelper.toServerSourceLocation(defineSourceLocation), StudyHelper.toServerUpdateAction(codeListUpdateAction), ClinicalHelper.toServerExportFileCreateInfo(validationInfo)), validationInfo != null ? validationInfo.getLocation() : null);
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        catch (StandardNotFoundException e) {
            throw new com.sas.lsaf.clinical.standards.StandardNotFoundException(e.getLocalizedMessage());
        }
        catch (ModelNotFoundException | com.sas.lsaf.svcs.clinical.study.client.StudyUpdateException e) {
            throw new StudyUpdateException(e.getLocalizedMessage());
        }
        catch (RepositoryException | WorkspaceException e) {
            throw new ImportException(e.getLocalizedMessage());
        }
        catch (ValidationReportException e) {
            throw new com.sas.lsaf.clinical.common.ValidationReportException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.core.validation.client.ValidationException e) {
            return this.generateUpdateResultFromValidationException(e.getLocalizedMessage(), validationInfo, studyId);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private StudyUpdateResult generateUpdateResultFromValidationException(String errorMessage, ExportFileCreateInfo validationInfo, String studyId) throws StudyNotFoundException {
        Study study = null;
        try {
            study = StudyHelper.toApiStudy(this.studyService.getStudyById(studyId));
        }
        catch (com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException e) {
            throw new StudyNotFoundException(e.getLocalizedMessage());
        }
        ArrayList<ValidationMessage> errorMsgs = new ArrayList<ValidationMessage>();
        ArrayList warnMsgs = new ArrayList();
        ArrayList infoMsgs = new ArrayList();
        String valMsgNotForResult = "Study does not have standard associations for the model and base standard.";
        if (errorMessage != null) {
            if (errorMessage.equals(valMsgNotForResult)) {
                throw new ValidationException(valMsgNotForResult);
            }
            errorMsgs.add(new ValidationMessage(errorMessage, ValidationMessage.Severity.ERROR, null, -1));
        } else {
            errorMsgs.add(new ValidationMessage("An unexpected error occurred.", ValidationMessage.Severity.ERROR, null, -1));
        }
        ValidationResult vr = new ValidationResult(errorMsgs, warnMsgs, infoMsgs, ServerSecurityContext.getCurrentUserId(), new Date());
        String validationPath = null;
        if (validationInfo != null && validationInfo.getPath() != null && !validationInfo.getPath().trim().isEmpty()) {
            validationPath = validationInfo.getPath();
            validationPath = validationPath.endsWith(".csv") ? validationPath : validationPath + ".csv";
        }
        return new StudyUpdateResult(study, vr, validationPath, validationInfo != null ? validationInfo.getLocation() : null);
    }

    private void assertStudyHasTables(String studyId, String baseStandardName, String modelId) throws Exception {
        Set studyTables = this.studyTableService.getStudyTableDescriptorsByStudyAndBaseStandard(studyId, baseStandardName, modelId);
        if (studyTables.isEmpty()) {
            throw new ValidationException("Cannot export because no tables exist for the specified standard.");
        }
    }

    private void checkForReferencedComponentsOfStandard(String studyId, Set<String> standardIds) throws com.sas.lsaf.svcs.clinical.study.client.exception.StudyNotFoundException {
        Set components = this.studyService.getDissociatingStandardsWithStudyMetadataByBaseStandardAndModel(studyId, standardIds);
        if (!components.isEmpty()) {
            throw new StudyStandardReferencedException("Standard cannot be removed because one or more components within the study are referencing that standard.");
        }
    }
}

