/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.study.impl;

import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.study.Study;
import com.sas.lsaf.clinical.study.StudyComponent;
import com.sas.lsaf.clinical.study.StudyComponentEditableStatus;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.svcs.clinical.common.client.ClinicalConstants;
import com.sas.lsaf.svcs.clinical.common.client.StudyMetadataUpdateInfo;
import com.sas.lsaf.svcs.clinical.standards.client.ImportSourceType;
import com.sas.lsaf.svcs.clinical.study.arm.client.StudyTlfUpdateFromFileInfo;
import com.sas.lsaf.svcs.clinical.study.table.client.StudyTableDataSet;
import com.sas.lsaf.svcs.clinical.study.table.client.StudyTablesFileInfo;
import com.sas.lsaf.svcs.core.lock.client.Lock;
import java.util.HashSet;
import java.util.Set;

public abstract class StudyHelper {
    public static Study toApiStudy(com.sas.lsaf.svcs.clinical.study.client.Study serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new Study(serverItem.getTypeId(), serverItem.getId(), serverItem.getName(), serverItem.getPath());
    }

    public static Set<Study> toApiStudies(Set<com.sas.lsaf.svcs.clinical.study.client.Study> serverItems) {
        if (serverItems == null) {
            return null;
        }
        HashSet<Study> apiItems = new HashSet<Study>(serverItems.size());
        for (com.sas.lsaf.svcs.clinical.study.client.Study serverItem : serverItems) {
            Study apiItem = StudyHelper.toApiStudy(serverItem);
            if (apiItem == null) continue;
            apiItems.add(apiItem);
        }
        return apiItems;
    }

    public static com.sas.lsaf.svcs.clinical.study.client.StudyComponent toServerStudyComponent(StudyComponent apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case TABLES_ANALYSIS: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.TABLES_ANALYSIS;
            }
            case TABLES_TABULATION: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.TABLES_TABULATION;
            }
            case DICTIONARIES: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.CONTROLLED_TERMINOLOGY;
            }
            case SUPPORTING_DOCUMENTS: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.SUPPORTING_DOCS;
            }
            case VALUE_LEVEL_METADATA: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.VALUE_LEVEL_METADATA;
            }
            case TLFS: {
                return com.sas.lsaf.svcs.clinical.study.client.StudyComponent.TLFS;
            }
        }
        throw new SystemException("Unmapped api study component: " + apiItem.name());
    }

    public static StudyMetadataUpdateInfo toServerStudyMetadataUpdateInfo(StudyComponentImportInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        StudyMetadataUpdateInfo studyMetadataUpdateInfo = new StudyMetadataUpdateInfo();
        studyMetadataUpdateInfo.setSourceLocation(ClinicalHelper.toServerSourceLocation(apiItem.getImportFileSourceLocation()));
        studyMetadataUpdateInfo.setSourceType(ClinicalConstants.StudyMetadataSourceType.DATASET);
        studyMetadataUpdateInfo.setSrcPath(apiItem.getImportFilePath());
        studyMetadataUpdateInfo.setSrcVersion(apiItem.getImportFileVersion());
        studyMetadataUpdateInfo.setUpdateAction(StudyHelper.toServerUpdateAction(apiItem.getUpdateAction()));
        return studyMetadataUpdateInfo;
    }

    public static ClinicalConstants.UpdateAction toServerUpdateAction(UpdateAction apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case ADD_NEW: {
                return ClinicalConstants.UpdateAction.ADD_NEW;
            }
            case REPLACE: {
                return ClinicalConstants.UpdateAction.REPLACE;
            }
        }
        throw new SystemException("Unmapped api study import update action: " + apiItem.name());
    }

    public static StudyComponentEditableStatus toApiStudyComponentLock(Lock serverItem) {
        if (serverItem == null) {
            return new StudyComponentEditableStatus(false, null, null);
        }
        return new StudyComponentEditableStatus(true, serverItem.getLockedBy(), serverItem.getLocked());
    }

    public static Set<String> toApiStudyTablePaths(Set<StudyTableDataSet> serverItems) {
        HashSet<String> apiItems = new HashSet<String>();
        for (StudyTableDataSet serverItem : serverItems) {
            apiItems.add(serverItem.getPath());
        }
        return apiItems;
    }

    public static StudyTablesFileInfo toServerStudyTablesFileInfo(StudyTablesImportInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        StudyTablesFileInfo serverInfo = new StudyTablesFileInfo();
        serverInfo.setTablesPath(apiItem.getTablesImportFilePath());
        serverInfo.setTablesVersion(apiItem.getTablesImportFileVersion());
        serverInfo.setColumnsPath(apiItem.getColumnsImportFilePath());
        serverInfo.setColumnsVersion(apiItem.getColumnsImportFileVersion());
        serverInfo.setSourceLocation(ClinicalHelper.toServerSourceLocation(apiItem.getImportFileSourceLocation()));
        serverInfo.setSourceType(ClinicalConstants.StudyMetadataSourceType.DATASET);
        serverInfo.setUpdateAction(StudyHelper.toServerUpdateAction(apiItem.getUpdateAction()));
        return serverInfo;
    }

    public static StudyTlfUpdateFromFileInfo toServerStudyTlfUpdateInfo(String studyId, String baseStandardName, String modelId, long revision, TlfImportInfo apiItem) {
        StudyTlfUpdateFromFileInfo serverInfo = new StudyTlfUpdateFromFileInfo();
        serverInfo.setStudyId(studyId);
        serverInfo.setBaseStandardName(baseStandardName);
        serverInfo.setModelId(modelId);
        serverInfo.setSectionTablePath(apiItem.getSectionsFilePath());
        serverInfo.setSectionTableVersion(apiItem.getSectionsFileVersion());
        serverInfo.setTlfTablePath(apiItem.getTlfsFilePath());
        serverInfo.setTlfTableVersion(apiItem.getTlfsFileVersion());
        serverInfo.setResultTablePath(apiItem.getResultsFilePath());
        serverInfo.setResultTableVersion(apiItem.getResultsFileVersion());
        serverInfo.setResultDataSetTablePath(apiItem.getDataSetsFilePath());
        serverInfo.setResultDataSetTableVersion(apiItem.getDataSetsFileVersion());
        serverInfo.setSrcLocation(ClinicalHelper.toServerSourceLocation(apiItem.getImportFileSourceLocation()));
        serverInfo.setSourceType(ImportSourceType.DATASET);
        serverInfo.setUpdateAction(StudyHelper.toServerUpdateAction(apiItem.getUpdateAction()));
        serverInfo.setRevision(revision);
        return serverInfo;
    }
}

