/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.standards.impl;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.clinical.standards.StandardNotFoundException;
import com.sas.lsaf.clinical.standards.StandardsService;
import com.sas.lsaf.clinical.standards.impl.StandardsHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.svcs.clinical.model.client.exception.ModelNotFoundException;
import com.sas.lsaf.svcs.clinical.standards.client.StandardDataSet;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public class StandardsServiceImpl
implements StandardsService {
    private com.sas.lsaf.svcs.clinical.standards.client.StandardsService standardsService;

    @Required
    public void setStandardsService(com.sas.lsaf.svcs.clinical.standards.client.StandardsService service) {
        this.standardsService = service;
    }

    public Set<StandardDescriptor> getStandardDescriptorsByStatus(EntityStatus standardStatus) {
        Assert.notNull((Object)standardStatus, (String)"Standard status is required.");
        try {
            List lsafStandards = this.standardsService.getLatestVersionOfStandardDescriptorsByType(StandardsHelper.toServerStandardVersionType(standardStatus));
            return StandardsHelper.toApiStandardDescriptors(lsafStandards);
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<String> exportStandardToDataSets(String standardId, EntityStatus standardStatus, String version, BatchFileCreateInfo info) throws StandardNotFoundException, ExportException {
        Assert.hasText((String)standardId, (String)"Standard id is required.");
        Assert.notNull((Object)standardStatus, (String)"Standard status is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        HashSet<String> paths = new HashSet<String>();
        try {
            Set standardDataSets = null;
            standardDataSets = version != null && !version.trim().isEmpty() ? this.standardsService.exportStandardAsDataSets(standardId, version, ClinicalHelper.toServerBatchFileCreateInfo(info)) : this.standardsService.exportStandardAsDataSets(standardId, StandardsHelper.toServerStandardVersionType(standardStatus), ClinicalHelper.toServerBatchFileCreateInfo(info));
            if (standardDataSets != null) {
                for (StandardDataSet ds : standardDataSets) {
                    paths.add(ds.getPath());
                }
            }
        }
        catch (com.sas.lsaf.svcs.clinical.standards.client.exception.StandardNotFoundException e) {
            throw new StandardNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | ModelNotFoundException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
        return paths;
    }

    public StandardDescriptor getStandardDescriptorByNameAndStatus(String name, EntityStatus standardStatus) throws StandardNotFoundException {
        Assert.hasText((String)name, (String)"Standard name is required.");
        Assert.notNull((Object)standardStatus, (String)"Standard status is required.");
        try {
            return StandardsHelper.toApiStandardDescriptor(this.standardsService.getStandardDescriptorByNameAndVersionType(name, StandardsHelper.toServerStandardVersionType(standardStatus)));
        }
        catch (com.sas.lsaf.svcs.clinical.standards.client.exception.StandardNotFoundException e) {
            throw new StandardNotFoundException("Standard was not found with name " + name + " and status " + standardStatus + ".");
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

