/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.standards.impl;

import com.sas.lsaf.clinical.standards.BaseStandardTypeInfo;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.core.EntityState;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.svcs.clinical.standards.client.StandardState;
import com.sas.lsaf.svcs.clinical.standards.client.StandardVersionInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class StandardsHelper {
    public static StandardVersionInfo.StandardVersionType toServerStandardVersionType(EntityStatus apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case CHECKEDOUT: {
                return StandardVersionInfo.StandardVersionType.CHECKEDOUT;
            }
            case INPROGRESS: {
                return StandardVersionInfo.StandardVersionType.INPROGRESS;
            }
            case PUBLISHED: {
                return StandardVersionInfo.StandardVersionType.PUBLISHED;
            }
        }
        throw new SystemException("Unmapped api standard status type: " + apiItem.name());
    }

    public static StandardDescriptor toApiStandardDescriptor(com.sas.lsaf.svcs.clinical.standards.client.StandardDescriptor serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new StandardDescriptor(serverItem.getId(), serverItem.getName(), StandardsHelper.toApiBaseStandardTypeInfo(serverItem.getBaseStandardTypeInfo()), serverItem.getMetadataId(), serverItem.getDescription(), serverItem.isCheckedOut(), serverItem.getCheckedOutBy(), serverItem.getCheckedOutDate(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), StandardsHelper.toApiStandardState(serverItem.getState()), StandardsHelper.toApiStandardState(serverItem.getPublishedState()), StandardsHelper.toApiStandardType(serverItem.getVersionInfo().getType()), serverItem.getCurrentVersion(), serverItem.getNumStudiesAssociated());
    }

    public static Set<StandardDescriptor> toApiStandardDescriptors(List<com.sas.lsaf.svcs.clinical.standards.client.StandardDescriptor> serverItems) {
        if (serverItems == null) {
            return null;
        }
        HashSet<StandardDescriptor> apiItems = new HashSet<StandardDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.clinical.standards.client.StandardDescriptor serverItem : serverItems) {
            apiItems.add(StandardsHelper.toApiStandardDescriptor(serverItem));
        }
        return apiItems;
    }

    public static BaseStandardTypeInfo toApiBaseStandardTypeInfo(com.sas.lsaf.svcs.clinical.standards.client.BaseStandardTypeInfo serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new BaseStandardTypeInfo(serverItem.getType(), serverItem.getName(), serverItem.getVersion());
    }

    private static EntityStatus toApiStandardType(StandardVersionInfo.StandardVersionType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case CHECKEDOUT: {
                return EntityStatus.CHECKEDOUT;
            }
            case INPROGRESS: {
                return EntityStatus.INPROGRESS;
            }
            case PUBLISHED: {
                return EntityStatus.PUBLISHED;
            }
        }
        throw new SystemException("Unmapped server standard type: " + serverItem.name());
    }

    public static EntityState toApiStandardState(StandardState.StandardStateId serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case DEV: {
                return EntityState.DEVELOPMENT;
            }
            case PROD: {
                return EntityState.PRODUCTION;
            }
            case RETIRED: {
                return EntityState.RETIRED;
            }
        }
        throw new SystemException("Unmapped server standard version state: " + serverItem.name());
    }
}

