/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.model.impl;

import com.sas.lsaf.clinical.model.ModelDescriptor;
import com.sas.lsaf.clinical.model.ModelNotFoundException;
import com.sas.lsaf.clinical.model.ModelService;
import com.sas.lsaf.clinical.model.impl.ModelHelper;
import com.sas.lsaf.core.CoreHelper;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ModelServiceImpl
implements ModelService {
    private com.sas.lsaf.svcs.clinical.model.client.ModelService modelService;

    @Required
    public void setModelService(com.sas.lsaf.svcs.clinical.model.client.ModelService service) {
        this.modelService = service;
    }

    public ModelDescriptor getModelDescriptorById(String id) throws ModelNotFoundException {
        Assert.hasText((String)id, (String)"Model id is required.");
        try {
            return ModelHelper.toApiModelDescriptor(this.modelService.getModelDescriptorById(id));
        }
        catch (com.sas.lsaf.svcs.clinical.model.client.exception.ModelNotFoundException e) {
            throw new ModelNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public Set<ModelDescriptor> getAllModelDescriptors() {
        try {
            return ModelHelper.toApiModelDescriptors(this.modelService.getAllModelDescriptors());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

