/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.model.impl;

import com.sas.lsaf.clinical.model.AttributeMetadata;
import com.sas.lsaf.clinical.model.ModelConstants;
import com.sas.lsaf.clinical.model.ModelDescriptor;
import com.sas.lsaf.clinical.model.ValueListMetadata;
import com.sas.lsaf.clinical.model.ValueListValueMetadata;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.svcs.clinical.common.client.DataType;
import com.sas.lsaf.svcs.clinical.model.client.ModelConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ModelHelper {
    public static ModelDescriptor toApiModelDescriptor(com.sas.lsaf.svcs.clinical.model.client.ModelDescriptor serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ModelDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getStandardType());
    }

    public static Set<ModelDescriptor> toApiModelDescriptors(List<com.sas.lsaf.svcs.clinical.model.client.ModelDescriptor> serverItems) {
        if (serverItems == null) {
            return null;
        }
        HashSet<ModelDescriptor> apiItems = new HashSet<ModelDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.clinical.model.client.ModelDescriptor serverItem : serverItems) {
            apiItems.add(ModelHelper.toApiModelDescriptor(serverItem));
        }
        return apiItems;
    }

    public static List<AttributeMetadata> toApiAttributeMetadataList(List<com.sas.lsaf.svcs.clinical.model.client.AttributeMetadata> serverItems) {
        ArrayList<AttributeMetadata> apiItems = new ArrayList<AttributeMetadata>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.model.client.AttributeMetadata serverItem : serverItems) {
                apiItems.add(ModelHelper.toApiAttributeMetadata(serverItem));
            }
        }
        return apiItems;
    }

    public static AttributeMetadata toApiAttributeMetadata(com.sas.lsaf.svcs.clinical.model.client.AttributeMetadata att) {
        if (att == null) {
            return null;
        }
        AttributeMetadata apiItem = new AttributeMetadata(att.getId(), att.getName(), att.getSasName(), att.getDescription(), att.getOrdering(), ModelHelper.toApiDataType(att.getDataType()), att.getLength(), ModelHelper.toApiValueListMetadata(att.getValuelist()), att.getSortSequence(), att.getKeySequence(), att.isRequired(), att.contributesToDefine(), ModelHelper.toApiLogicalType(att.getLogicalType()), ModelHelper.toApiAttributeScope(att.getScope()), att.isDerived(), att.getHelp(), ModelHelper.toApiAttributeState(att.getState()), att.mustBeUnique());
        return apiItem;
    }

    private static ModelConstants.AttributeScope toApiAttributeScope(ModelConstants.AttributeScope serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case Context: {
                return ModelConstants.AttributeScope.CONTEXT;
            }
            case Global: {
                return ModelConstants.AttributeScope.GLOBAL;
            }
        }
        throw new SystemException("Unmapped server clinical attribute scope: " + serverItem.name());
    }

    private static ModelConstants.AttributeState toApiAttributeState(ModelConstants.AttributeState serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case Active: {
                return ModelConstants.AttributeState.ACTIVE;
            }
            case Retired: {
                return ModelConstants.AttributeState.RETIRED;
            }
        }
        throw new SystemException("Unmapped server clinical attribute state: " + serverItem.name());
    }

    private static ModelConstants.LogicalType toApiLogicalType(ModelConstants.LogicalType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case Date: {
                return ModelConstants.LogicalType.DATE;
            }
            case File: {
                return ModelConstants.LogicalType.FILE;
            }
            case Folder: {
                return ModelConstants.LogicalType.FOLDER;
            }
            case Principal: {
                return ModelConstants.LogicalType.PRINCIPAL;
            }
            case User: {
                return ModelConstants.LogicalType.USER;
            }
        }
        throw new SystemException("Unmapped server clinical logical type: " + serverItem.name());
    }

    private static ValueListMetadata toApiValueListMetadata(com.sas.lsaf.svcs.clinical.model.client.ValueListMetadata serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ValueListMetadata(serverItem.getId(), serverItem.getName(), serverItem.getModelId(), serverItem.isBuiltIn(), serverItem.isExtensible(), ModelHelper.toApiValueListValueMetadataList(serverItem.getValueListValues()));
    }

    public static List<ValueListValueMetadata> toApiValueListValueMetadataList(List<com.sas.lsaf.svcs.clinical.model.client.ValueListValueMetadata> serverItems) {
        ArrayList<ValueListValueMetadata> ret = new ArrayList<ValueListValueMetadata>();
        if (serverItems != null) {
            for (com.sas.lsaf.svcs.clinical.model.client.ValueListValueMetadata serverItem : serverItems) {
                if (serverItem == null) continue;
                ret.add(ModelHelper.toApiValueListValueMetadata(serverItem));
            }
        }
        return ret;
    }

    private static ValueListValueMetadata toApiValueListValueMetadata(com.sas.lsaf.svcs.clinical.model.client.ValueListValueMetadata serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ValueListValueMetadata(serverItem.getId(), serverItem.getValue(), serverItem.isDefault(), serverItem.getOrdering());
    }

    private static ModelConstants.DataType toApiDataType(DataType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case BOOLEAN: {
                return ModelConstants.DataType.BOOLEAN;
            }
            case FLOAT: {
                return ModelConstants.DataType.FLOAT;
            }
            case INTEGER: {
                return ModelConstants.DataType.INTEGER;
            }
            case LONG: {
                return ModelConstants.DataType.LONG;
            }
            case STRING: {
                return ModelConstants.DataType.STRING;
            }
        }
        throw new SystemException("Unmapped server clinical data type: " + serverItem.name());
    }
}

