/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.dictionary.impl;

import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.clinical.dictionary.ExternalDictionaryService;
import com.sas.lsaf.clinical.dictionary.impl.DictionaryHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.DataType;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ExternalDictionaryServiceImpl
implements ExternalDictionaryService {
    private com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionaryService externalDictionaryService;

    @Required
    public void setExternalDictionaryService(com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionaryService service) {
        this.externalDictionaryService = service;
    }

    public Set<ExternalDictionary> getExternalDictionaries() {
        try {
            Set extDs = this.externalDictionaryService.getAllExternalDictionaries();
            Set<ExternalDictionary> apiExtDs = DictionaryHelper.toApiExternalDictionaries(extDs);
            return apiExtDs;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportExternalDictionariesToDataSet(ExportFileCreateInfo info) throws ExportException {
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            return this.externalDictionaryService.exportExternalDictionariesToDataSet(ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public ExternalDictionary getExternalDictionary(String dictionary, DataType dataType, String version) throws DictionaryNotFoundException {
        Assert.hasText((String)dictionary, (String)"Dictionary name is required.");
        Assert.notNull((Object)dataType, (String)"Data type is required.");
        Assert.hasText((String)version, (String)"Version is required.");
        try {
            return DictionaryHelper.toApiExternalDictionary(this.externalDictionaryService.getExternalDictionary(dictionary, ClinicalHelper.toServerDataType(dataType), version));
        }
        catch (com.sas.lsaf.svcs.clinical.dictionary.client.exception.DictionaryNotFoundException e) {
            throw new DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }
}

