/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.dictionary.impl;

import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException;
import com.sas.lsaf.clinical.dictionary.DictionaryService;
import com.sas.lsaf.clinical.dictionary.impl.DictionaryHelper;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.svcs.clinical.common.client.ClinicalPrivileges;
import com.sas.lsaf.svcs.content.repository.client.RepositoryContext;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryException;
import com.sas.lsaf.svcs.content.repository.client.exception.RepositoryItemNotFoundException;
import com.sas.lsaf.svcs.content.repository.server.InternalRepositoryService;
import com.sas.lsaf.svcs.content.workspace.client.exception.WorkspaceException;
import com.sas.lsaf.svcs.security.authorization.client.AuthorizationService;
import com.sas.lsaf.svcs.security.authorization.client.Securable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class DictionaryServiceImpl
implements DictionaryService {
    private com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryService dictionaryService;
    private AuthorizationService authorizationService;
    private InternalRepositoryService internalRepositoryService;

    @Required
    public void setDictionaryService(com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryService service) {
        this.dictionaryService = service;
    }

    @Required
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    public Set<DictionaryDescriptor> getDictionaryDescriptorsByStatus(EntityStatus status) {
        Assert.notNull((Object)status, (String)"Dictionary status is required.");
        try {
            List<DictionaryDescriptor> dictionaries = DictionaryHelper.toApiDictionaryDescriptors(this.dictionaryService.getLatestVersionOfDictionaryDescriptorsByType(DictionaryHelper.toServerDictionaryVersionType(status)));
            return dictionaries != null ? new HashSet<DictionaryDescriptor>(dictionaries) : null;
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public String exportDictionaryToDataSet(String dictionaryId, EntityStatus dictionaryStatus, String version, ExportFileCreateInfo info) throws DictionaryNotFoundException, ExportException {
        Assert.hasText((String)dictionaryId, (String)"Dictionary id is required.");
        Assert.notNull((Object)dictionaryStatus, (String)"Dictionary status is required.");
        Assert.notNull((Object)info, (String)"Export file details are required.");
        Assert.notNull((Object)info.getLocation(), (String)"Export file source location is required.");
        Assert.hasText((String)info.getPath(), (String)"Export file path is required.");
        try {
            if (version != null && !version.trim().isEmpty()) {
                return this.dictionaryService.exportDictionaryToDataSet(dictionaryId, version, ClinicalHelper.toServerExportFileCreateInfo(info));
            }
            return this.dictionaryService.exportDictionaryToDataSet(dictionaryId, DictionaryHelper.toServerDictionaryVersionType(dictionaryStatus), ClinicalHelper.toServerExportFileCreateInfo(info));
        }
        catch (com.sas.lsaf.svcs.clinical.dictionary.client.exception.DictionaryNotFoundException e) {
            throw new DictionaryNotFoundException(e.getLocalizedMessage());
        }
        catch (com.sas.lsaf.svcs.clinical.common.client.exception.ExportException | RepositoryException | WorkspaceException e) {
            throw new ExportException(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    public DictionaryDescriptor getDictionaryDescriptorByNameAndStatus(String name, EntityStatus dictionaryStatus) throws DictionaryNotFoundException {
        Assert.hasText((String)name, (String)"Dictionary name is required.");
        Assert.notNull((Object)dictionaryStatus, (String)"Dictionary status is required.");
        try {
            if (!dictionaryStatus.equals((Object)EntityStatus.PUBLISHED)) {
                this.checkStandardPrivilege();
            }
            return DictionaryHelper.toApiDictionaryDescriptor(this.dictionaryService.getDictionaryDescriptorByNameAndVersionType(name, DictionaryHelper.toServerDictionaryVersionType(dictionaryStatus)));
        }
        catch (com.sas.lsaf.svcs.clinical.dictionary.client.exception.DictionaryNotFoundException e) {
            throw new DictionaryNotFoundException("Dictionary was not found with name " + name + " and status " + dictionaryStatus + ".");
        }
        catch (Throwable t) {
            throw CoreHelper.handleThrowable(t);
        }
    }

    private void checkStandardPrivilege() throws RepositoryItemNotFoundException {
        RepositoryContext tenant = this.internalRepositoryService.internalGetContextByPath("/");
        if (!this.authorizationService.hasPrivilege((Securable)tenant, ClinicalPrivileges.PRIVILEGE_MANAGE_STANDARDS)) {
            throw new AccessDeniedException("User has access to published dictionaries only.");
        }
    }
}

