/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.dictionary.impl;

import com.sas.lsaf.clinical.common.ClinicalHelper;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.core.EntityState;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryState;
import com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryVersionInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DictionaryHelper {
    public static DictionaryDescriptor toApiDictionaryDescriptor(com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryDescriptor serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new DictionaryDescriptor(serverItem.getId(), serverItem.getName(), serverItem.getDescription(), serverItem.getStandard(), serverItem.isCheckedOut(), serverItem.getCheckedOutBy(), serverItem.getCheckedOutDate(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getReleaseDate(), DictionaryHelper.toApiDictionaryState(serverItem.getState()), DictionaryHelper.toApiDictionaryState(serverItem.getPublishedState()), DictionaryHelper.toApiDictionaryType(serverItem.getVersionInfo().getType()), serverItem.getCurrentVersion(), serverItem.getNumStudiesAssociated());
    }

    public static EntityState toApiDictionaryState(DictionaryState.DictionaryStateId serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case DEV: {
                return EntityState.DEVELOPMENT;
            }
            case PROD: {
                return EntityState.PRODUCTION;
            }
            case RETIRED: {
                return EntityState.RETIRED;
            }
        }
        throw new SystemException("Unmapped server dictionary state: " + serverItem.name());
    }

    public static EntityStatus toApiDictionaryType(DictionaryVersionInfo.DictionaryVersionType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case CHECKEDOUT: {
                return EntityStatus.CHECKEDOUT;
            }
            case INPROGRESS: {
                return EntityStatus.INPROGRESS;
            }
            case PUBLISHED: {
                return EntityStatus.PUBLISHED;
            }
        }
        throw new SystemException("Unmapped server dictionary type: " + serverItem.name());
    }

    public static List<DictionaryDescriptor> toApiDictionaryDescriptors(List<com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryDescriptor> serverItems) {
        if (serverItems == null) {
            return null;
        }
        ArrayList<DictionaryDescriptor> apiItems = new ArrayList<DictionaryDescriptor>(serverItems.size());
        for (com.sas.lsaf.svcs.clinical.dictionary.client.DictionaryDescriptor serverItem : serverItems) {
            apiItems.add(DictionaryHelper.toApiDictionaryDescriptor(serverItem));
        }
        return apiItems;
    }

    public static DictionaryVersionInfo.DictionaryVersionType toServerDictionaryVersionType(EntityStatus apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case CHECKEDOUT: {
                return DictionaryVersionInfo.DictionaryVersionType.CHECKEDOUT;
            }
            case INPROGRESS: {
                return DictionaryVersionInfo.DictionaryVersionType.INPROGRESS;
            }
            case PUBLISHED: {
                return DictionaryVersionInfo.DictionaryVersionType.PUBLISHED;
            }
        }
        throw new SystemException("Unmapped api dictionary status type: " + apiItem.name());
    }

    public static Set<ExternalDictionary> toApiExternalDictionaries(Set<com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionary> serverItems) {
        if (serverItems == null) {
            return null;
        }
        HashSet<ExternalDictionary> apiItems = new HashSet<ExternalDictionary>(serverItems.size());
        for (com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionary serverItem : serverItems) {
            apiItems.add(DictionaryHelper.toApiExternalDictionary(serverItem));
        }
        return apiItems;
    }

    public static ExternalDictionary toApiExternalDictionary(com.sas.lsaf.svcs.clinical.dictionary.client.ExternalDictionary serverItem) {
        if (serverItem == null) {
            return null;
        }
        return new ExternalDictionary(serverItem.getId(), serverItem.getDictionaryName(), serverItem.getDictionaryVersion(), ClinicalHelper.toApiDataType(serverItem.getDataType()), serverItem.getShortName(), serverItem.getReferenceName(), serverItem.getDictionaryHref(), serverItem.getDescription(), serverItem.getCreatedBy(), serverItem.getCreated(), serverItem.getLastModifiedBy(), serverItem.getLastModified(), serverItem.getNumStudiesAssociated());
    }
}

