/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.clinical.common;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ClinicalUpdateResult;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.study.impl.StudyHelper;
import com.sas.lsaf.content.repository.impl.RepositoryHelper;
import com.sas.lsaf.core.CoreHelper;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.svcs.clinical.common.client.ClinicalConstants;
import com.sas.lsaf.svcs.clinical.dictionary.client.DataType;
import com.sas.lsaf.svcs.clinical.study.client.StudyUpdateResult;

public abstract class ClinicalHelper {
    public static com.sas.lsaf.svcs.clinical.common.client.BatchFileCreateInfo toServerBatchFileCreateInfo(BatchFileCreateInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.clinical.common.client.BatchFileCreateInfo info = new com.sas.lsaf.svcs.clinical.common.client.BatchFileCreateInfo(apiItem.getPath());
        info.setLocation(ClinicalHelper.toServerSourceLocation(apiItem.getLocation()));
        info.setEnableVersioning(apiItem.isEnableVersioning());
        info.setOverwrite(apiItem.isOverwrite());
        info.setComment(apiItem.getComment());
        info.setDescription(apiItem.getDescription());
        info.setVersionTypeForNewFiles(RepositoryHelper.toServerVersionType(apiItem.getVersionTypeForNewFiles()));
        info.setVersionTypeForExistingFiles(RepositoryHelper.toServerVersionType(apiItem.getVersionTypeForExistingFiles()));
        info.setCustomVersionForNewFiles(apiItem.getCustomVersionForNewFiles());
        info.setCustomVersionForExistingFiles(apiItem.getCustomVersionForExistingFiles());
        return info;
    }

    public static com.sas.lsaf.svcs.clinical.common.client.ExportFileCreateInfo toServerExportFileCreateInfo(ExportFileCreateInfo apiItem) {
        if (apiItem == null) {
            return null;
        }
        com.sas.lsaf.svcs.clinical.common.client.ExportFileCreateInfo info = new com.sas.lsaf.svcs.clinical.common.client.ExportFileCreateInfo(apiItem.getPath(), ClinicalHelper.toServerSourceLocation(apiItem.getLocation()));
        info.setEnableVersioning(apiItem.isEnableVersioning());
        info.setOverwrite(apiItem.isOverwrite());
        info.setComment(apiItem.getComment());
        info.setVersionType(RepositoryHelper.toServerVersionType(apiItem.getVersionType()));
        info.setCustomVersion(apiItem.getCustomVersion());
        info.setDescription(apiItem.getDescription());
        return info;
    }

    public static ClinicalConstants.SourceLocation toServerSourceLocation(SourceLocation apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case REPOSITORY: {
                return ClinicalConstants.SourceLocation.REPOSITORY;
            }
            case WORKSPACE: {
                return ClinicalConstants.SourceLocation.WORKSPACE;
            }
        }
        throw new SystemException("Unmapped api source location: " + apiItem.name());
    }

    public static com.sas.lsaf.core.DataType toApiDataType(DataType serverItem) {
        if (serverItem == null) {
            return null;
        }
        switch (serverItem) {
            case FLOAT: {
                return com.sas.lsaf.core.DataType.FLOAT;
            }
            case INTEGER: {
                return com.sas.lsaf.core.DataType.INTEGER;
            }
            case TEXT: {
                return com.sas.lsaf.core.DataType.TEXT;
            }
        }
        throw new SystemException("Unmapped server data type: " + serverItem.name());
    }

    public static DataType toServerDataType(com.sas.lsaf.core.DataType apiItem) {
        if (apiItem == null) {
            return null;
        }
        switch (apiItem) {
            case FLOAT: {
                return DataType.FLOAT;
            }
            case INTEGER: {
                return DataType.INTEGER;
            }
            case TEXT: {
                return DataType.TEXT;
            }
        }
        throw new SystemException("Unmapped api data type: " + apiItem.name());
    }

    public static ClinicalUpdateResult toApiClinicalUpdateResult(com.sas.lsaf.svcs.clinical.common.client.ClinicalUpdateResult serverItem, SourceLocation sourceLocation) {
        if (serverItem == null) {
            return null;
        }
        return new ClinicalUpdateResult(CoreHelper.toApiValidationResult(serverItem.getValidationResult()), serverItem.getValidationReportPath(), sourceLocation);
    }

    public static com.sas.lsaf.clinical.study.StudyUpdateResult toApiStudyUpdateResult(StudyUpdateResult serverItem, SourceLocation sourceLocation) {
        if (serverItem == null) {
            return null;
        }
        return new com.sas.lsaf.clinical.study.StudyUpdateResult(StudyHelper.toApiStudy(serverItem.getStudy()), CoreHelper.toApiValidationResult(serverItem.getValidationResult()), serverItem.getValidationReportPath(), sourceLocation);
    }
}

